/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resource.filter.impl;

import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.resource.filter.impl.Context;
import org.apache.sling.resource.filter.impl.Visitor;
import org.apache.sling.resource.filter.impl.node.Node;
import org.apache.sling.resource.filter.impl.predicates.ComparisonPredicateFactory;

public class LogicVisitor
implements Visitor<Predicate<Resource>> {
    private Context context;

    public LogicVisitor(Context context) {
        this.context = context;
        context.setLogicVisitor(this);
    }

    @Override
    public Predicate<Resource> visit(Node node) {
        switch (node.kind) {
            case 21: {
                return this.createAndPredicate(node);
            }
            case 22: {
                return this.createOrPredicate(node);
            }
        }
        return this.createComparisonPredicate(node);
    }

    private Predicate<Resource> createAndPredicate(Node node2) {
        return node2.children.stream().map(node -> this.visit((Node)node)).reduce(null, (predicate, accumulator) -> {
            if (predicate == null) {
                return accumulator;
            }
            return accumulator.and(predicate);
        });
    }

    private Predicate<Resource> createOrPredicate(Node node2) {
        return node2.children.stream().map(node -> this.visit((Node)node)).reduce(null, (predicate, accumulator) -> {
            if (predicate == null) {
                return accumulator;
            }
            return accumulator.or(predicate);
        });
    }

    private Predicate<Resource> createComparisonPredicate(Node comparisonNode) {
        Function<Resource, Object> leftValue = comparisonNode.leftNode.accept(this.context.getComparisonVisitor());
        Function<Resource, Object> rightValue = comparisonNode.rightNode.accept(this.context.getComparisonVisitor());
        return ComparisonPredicateFactory.toPredicate(comparisonNode.kind, leftValue, rightValue);
    }
}

