/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.sling.launchpad.api.LaunchpadContentProvider;

public class ContextConnection
extends URLConnection {
    private final LaunchpadContentProvider resourceProvider;
    private URLConnection delegatee;

    ContextConnection(URL url, LaunchpadContentProvider resourceProvider) {
        super(url);
        this.resourceProvider = resourceProvider;
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            URL contextURL = this.resourceProvider.getResource(this.url.getPath());
            if (contextURL == null) {
                throw new IOException("Resource " + this.url.getPath() + " does not exist");
            }
            this.delegatee = contextURL.openConnection();
            this.connected = true;
        }
    }

    @Override
    public int getContentLength() {
        return this.delegatee == null ? -1 : this.delegatee.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.delegatee == null ? null : this.delegatee.getContentType();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.delegatee.getInputStream();
    }

    @Override
    public long getLastModified() {
        return this.delegatee == null ? 0L : this.delegatee.getLastModified();
    }
}

