/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.sling.installer.provider.jcr.impl.InstallerConfig;
import org.apache.sling.installer.provider.jcr.impl.RescanTimer;
import org.apache.sling.installer.provider.jcr.impl.WatchedFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RootFolderListener
implements EventListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RescanTimer timer;
    private final String watchedPath;
    private final InstallerConfig cfg;
    private final String pathWithSlash;

    RootFolderListener(Session session, String path, RescanTimer timer, InstallerConfig cfg) throws RepositoryException {
        this.timer = timer;
        this.watchedPath = path;
        this.pathWithSlash = path;
        this.cfg = cfg;
        int eventTypes = 31;
        boolean isDeep = true;
        boolean noLocal = true;
        session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 31, this.watchedPath, true, null, null, true);
        this.logger.info("Watching {} to detect potential changes in subfolders", (Object)this.watchedPath);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.watchedPath + ")";
    }

    void cleanup(Session session) throws RepositoryException {
        session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
    }

    public void onEvent(EventIterator it) {
        boolean globalScan = false;
        List<WatchedFolder> checkFolders = this.cfg.cloneWatchedFolders();
        Iterator<WatchedFolder> i = checkFolders.iterator();
        while (i.hasNext()) {
            WatchedFolder wf = i.next();
            if (wf.getPathWithSlash().startsWith(this.pathWithSlash)) continue;
            i.remove();
        }
        while (it.hasNext()) {
            Event e = it.nextEvent();
            this.logger.debug("Got event {}", (Object)e);
            if (e.getType() == 1 || e.getType() == 2) {
                globalScan = true;
            }
            try {
                String path = e.getPath();
                Iterator<WatchedFolder> ii = checkFolders.iterator();
                while (ii.hasNext()) {
                    WatchedFolder folder = ii.next();
                    if (!path.startsWith(folder.getPathWithSlash())) continue;
                    folder.markForScan();
                    ii.remove();
                }
            }
            catch (RepositoryException re) {
                this.logger.warn("Error while getting path from event", (Throwable)re);
            }
        }
        if (globalScan) {
            this.timer.scheduleScan();
        }
    }
}

