/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.lan;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Locale;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.cat.CodeListUID;
import org.apache.sis.xml.bind.gco.CharSequenceAdapter;
import org.apache.sis.xml.bind.gco.GO_CharacterString;

@XmlType(name="LanguageCode_PropertyType")
public final class LanguageCode
extends GO_CharacterString {
    @XmlElement(name="LanguageCode")
    public CodeListUID identifier;

    public LanguageCode() {
    }

    private LanguageCode(CharSequence code) {
        super(code);
    }

    private LanguageCode(Context context, String codeListValue, String codeSpace, String value) {
        this.identifier = new CodeListUID(context, "LanguageCode", codeListValue, codeSpace, value);
    }

    public static LanguageCode create(Context context, Locale locale) {
        String codeListValue = Context.converter(context).toLanguageCode(context, locale);
        if (codeListValue != null) {
            CharSequence string;
            if (!codeListValue.isEmpty() && Context.isFlagSet(context, 2) && (string = CharSequenceAdapter.value(context, locale, codeListValue)) != null) {
                return new LanguageCode(string);
            }
            Locale marshalLocale = LanguageCode.marshalLocale(context);
            String codeSpace = Context.converter(context).toLanguageCode(context, marshalLocale);
            String value = locale.getDisplayLanguage(marshalLocale);
            if (value.isEmpty()) {
                codeSpace = null;
                value = null;
            }
            if (!codeListValue.isEmpty() || value != null) {
                return new LanguageCode(context, codeListValue, codeSpace, value);
            }
        }
        return null;
    }

    static Locale marshalLocale(Context context) {
        Locale marshalLocale;
        if (context != null && (marshalLocale = context.getLocale()) != null) {
            return marshalLocale;
        }
        return Locale.getDefault(Locale.Category.DISPLAY);
    }

    public String getLanguage() {
        String code = this.identifier != null ? this.identifier.toString() : this.toString();
        return code;
    }
}

