/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx;

import io.netty.buffer.ByteBuf;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxBuilder;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.VertxThreadFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.vertx.SimpleJsonObject;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolManager;
import org.apache.servicecomb.foundation.vertx.stream.BufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VertxUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxUtils.class);
    private static final long BLOCKED_THREAD_CHECK_INTERVAL = 0x3FFFFFFFFFFFFFFFL;
    private static final Map<String, Vertx> vertxMap = new ConcurrentHashMapEx();

    private VertxUtils() {
    }

    public static Map<String, Vertx> getVertxMap() {
        return vertxMap;
    }

    public static <T extends AbstractVerticle> void deployVerticle(Vertx vertx, Class<T> cls, int instanceCount) {
        DeploymentOptions options = new DeploymentOptions().setInstances(instanceCount);
        vertx.deployVerticle(cls.getName(), options);
    }

    public static <CLIENT_POOL> DeploymentOptions createClientDeployOptions(ClientPoolManager<CLIENT_POOL> clientMgr, int instanceCount) {
        DeploymentOptions options = new DeploymentOptions().setInstances(instanceCount);
        SimpleJsonObject config = new SimpleJsonObject();
        config.put("clientMgr", clientMgr);
        options.setConfig((JsonObject)config);
        return options;
    }

    public static <VERTICLE extends Verticle> Map<String, Object> blockDeploy(Vertx vertx, Class<VERTICLE> cls, DeploymentOptions options) throws InterruptedException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CountDownLatch latch = new CountDownLatch(1);
        vertx.deployVerticle(cls.getName(), options, ar -> {
            result.put("code", ar.succeeded());
            if (ar.failed()) {
                result.put("message", ar.cause().getMessage());
                LOGGER.error("deploy vertx failed, cause ", ar.cause());
            }
            latch.countDown();
        });
        latch.await();
        return result;
    }

    public static Vertx getOrCreateVertxByName(String name, VertxOptions vertxOptions) {
        return vertxMap.computeIfAbsent(name, vertxName -> VertxUtils.init(vertxName, vertxOptions));
    }

    public static Vertx init(final String name, VertxOptions vertxOptions) {
        boolean isDebug;
        if (vertxOptions == null) {
            vertxOptions = new VertxOptions();
        }
        if (isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp")) {
            vertxOptions.setBlockedThreadCheckInterval(0x3FFFFFFFFFFFFFFFL);
            LOGGER.info("in debug mode, disable blocked thread check.");
        }
        VertxUtils.configureVertxFileCaching(vertxOptions);
        return new VertxBuilder(vertxOptions).threadFactory(new VertxThreadFactory(){

            public VertxThread newVertxThread(Runnable target, String threadName, boolean worker, long maxExecTime, TimeUnit maxExecTimeUnit) {
                return super.newVertxThread(target, name + "-" + threadName, worker, maxExecTime, maxExecTimeUnit);
            }
        }).init().vertx();
    }

    private static void configureVertxFileCaching(VertxOptions vertxOptions) {
        boolean disableFileCPResolving = LegacyPropertyFactory.getBooleanProperty((String)"vertx.disableFileCPResolving", (boolean)true);
        vertxOptions.getFileSystemOptions().setClassPathResolvingEnabled(!disableFileCPResolving);
    }

    public static byte[] getBytesFast(InputStream inputStream) throws IOException {
        if (inputStream instanceof BufferInputStream) {
            return VertxUtils.getBytesFast(((BufferInputStream)((Object)inputStream)).getByteBuf());
        }
        return IOUtils.toByteArray((InputStream)inputStream);
    }

    public static byte[] getBytesFast(Buffer buffer) {
        byte[] arr = new byte[buffer.length()];
        buffer.getBytes(arr, 0);
        return arr;
    }

    public static byte[] getBytesFast(ByteBuf byteBuf) {
        if (byteBuf.hasArray()) {
            return byteBuf.array();
        }
        byte[] arr = new byte[byteBuf.writerIndex()];
        byteBuf.getBytes(0, arr);
        return arr;
    }

    public static CompletableFuture<Void> closeVertxByName(String name) {
        LOGGER.info("Closing vertx {}.", (Object)name);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Vertx vertx = vertxMap.remove(name);
        if (vertx == null) {
            LOGGER.info("Vertx {} not exist.", (Object)name);
            future.complete(null);
            return future;
        }
        vertx.close(ar -> {
            if (ar.succeeded()) {
                LOGGER.info("Success to close vertx {}.", (Object)name);
                future.complete(null);
                return;
            }
            future.completeExceptionally(ar.cause());
        });
        return future;
    }

    public static void blockCloseVertxByName(String name) {
        CompletableFuture<Void> future = VertxUtils.closeVertxByName(name);
        try {
            future.get(30L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to wait close vertx {}.", (Object)name, (Object)e);
        }
    }

    public static void blockCloseVertx(Vertx vertx) {
        CountDownLatch latch = new CountDownLatch(1);
        vertx.close(ar -> {
            if (ar.succeeded()) {
                LOGGER.info("Success to close vertx {}.", (Object)vertx);
            } else {
                LOGGER.info("Failed to close vertx {}.", (Object)vertx);
            }
            latch.countDown();
        });
        try {
            latch.await(30L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            LOGGER.info("Failed to wait close vertx {}.", (Object)vertx);
        }
    }
}

