/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.impl.ints;

import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.AbstractPrimitiveWriters;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.RepeatedPrimitiveWriteSchemas;

public class SInt32PackedWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        return RepeatedPrimitiveWriteSchemas.create(protoField, propertyDescriptor, new SInt32PackedWriters(protoField));
    }

    private static class SInt32PackedWriters
    extends AbstractPrimitiveWriters<int[], Integer> {
        public SInt32PackedWriters(Field protoField) {
            super(protoField);
            this.primitiveArrayWriter = (o, value) -> {
                if (((int[])value).length == 0) {
                    return;
                }
                o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                    for (int element : array) {
                        output.writePackedSInt32(element);
                    }
                });
            };
            this.arrayWriter = (o, value) -> {
                if (((Integer[])value).length == 0) {
                    return;
                }
                o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                    for (Integer element : array) {
                        if (element != null) {
                            output.writePackedSInt32(element);
                            continue;
                        }
                        ProtoUtils.throwNotSupportNullElement(protoField);
                    }
                });
            };
            this.collectionWriter = (o, value) -> {
                if (value.isEmpty()) {
                    return;
                }
                o.writeObject(this.tag, this.tagSize, value, (output, collection) -> {
                    for (Integer element : collection) {
                        if (element != null) {
                            output.writePackedSInt32(element);
                            continue;
                        }
                        ProtoUtils.throwNotSupportNullElement(protoField);
                    }
                });
            };
            this.stringArrayWriter = (o, value) -> {
                if (((String[])value).length == 0) {
                    return;
                }
                o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                    for (String element : array) {
                        if (element != null) {
                            int parsedValue = Integer.parseInt(element, 10);
                            output.writePackedSInt32(parsedValue);
                            continue;
                        }
                        ProtoUtils.throwNotSupportNullElement(protoField);
                    }
                });
            };
        }
    }
}

