/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.config.YAMLUtil;
import org.apache.servicecomb.foundation.common.utils.JvmUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public final class ConfigMapping {
    private static final Map<String, Object> configMap;
    private static final Logger LOGGER;

    private ConfigMapping() {
    }

    @VisibleForTesting
    static <T> T map(String key) {
        return (T)configMap.get(key);
    }

    public static Map<String, Object> getMapping() {
        return configMap;
    }

    public static Map<String, Object> getConvertedMap(Map<String, Object> oldMap) {
        if (configMap == null) {
            return new LinkedHashMap<String, Object>();
        }
        LinkedHashMap<String, Object> retMap = new LinkedHashMap<String, Object>();
        retMap.putAll(oldMap);
        configMap.entrySet().forEach(entry -> ConfigMapping.putConfigsToRetMap(retMap, entry, oldMap.get(entry.getKey())));
        return retMap;
    }

    public static Map<String, Object> getConvertedMap(Configuration config) {
        if (configMap == null) {
            return new LinkedHashMap<String, Object>();
        }
        LinkedHashMap<String, Object> retMap = new LinkedHashMap<String, Object>();
        configMap.entrySet().forEach(entry -> ConfigMapping.putConfigsToRetMap(retMap, entry, config.getProperty((String)entry.getKey())));
        return retMap;
    }

    public static Map<String, Object> getConvertedMap(Environment environment) {
        if (configMap == null) {
            return new LinkedHashMap<String, Object>();
        }
        LinkedHashMap<String, Object> retMap = new LinkedHashMap<String, Object>();
        configMap.entrySet().forEach(entry -> ConfigMapping.putConfigsToRetMap(retMap, entry, environment.getProperty((String)entry.getKey())));
        return retMap;
    }

    private static void putConfigsToRetMap(Map<String, Object> retMap, Map.Entry<String, Object> entry, Object configValue) {
        if (configValue != null) {
            if (entry.getValue() instanceof List) {
                List newKeys = (List)entry.getValue();
                newKeys.forEach(newKey -> retMap.put((String)newKey, configValue));
                return;
            }
            String newKey2 = (String)entry.getValue();
            retMap.put(newKey2, configValue);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(ConfigMapping.class);
        ClassLoader loader = JvmUtils.findClassLoader();
        ArrayList<Map<String, Object>> mappingList = new ArrayList<Map<String, Object>>();
        configMap = new HashMap<String, Object>();
        try {
            Enumeration<URL> urls = loader.getResources("mapping.yaml");
            while (urls.hasMoreElements()) {
                InputStream in = urls.nextElement().openStream();
                try {
                    mappingList.add(YAMLUtil.yaml2Properties(in));
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            mappingList.sort((a, b) -> {
                int orderA = a.get("servicecomb-config-order") == null ? 0 : (Integer)a.get("servicecomb-config-order");
                int orderB = b.get("servicecomb-config-order") == null ? 0 : (Integer)b.get("servicecomb-config-order");
                return orderA - orderB;
            });
            mappingList.forEach(item -> {
                item.remove("servicecomb-config-order");
                configMap.putAll((Map<String, Object>)item);
            });
        }
        catch (IOException e) {
            LOGGER.error("get config mapping file error!", (Throwable)e);
        }
    }
}

