/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.inject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.servicecomb.config.ConfigUtil;

public class PlaceholderResolver {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("(?<escape>\\\\)?\\$\\{(?<name>[^{}]+)\\}");

    public List<String> replace(String str, Map<String, Object> parameters) {
        List<Row> finalRows = this.replaceToRows(str, parameters);
        ArrayList<String> replaced = new ArrayList<String>();
        for (Row row : finalRows) {
            this.resolve(row, replaced);
        }
        for (int idx = 0; idx < replaced.size(); ++idx) {
            String string = (String)replaced.get(idx);
            replaced.set(idx, string.replace("\\$", "$"));
        }
        return replaced;
    }

    private List<Row> replaceToRows(String str, Map<String, Object> parameters) {
        ArrayList<Row> finalRows = new ArrayList<Row>();
        ArrayList<String> remainRows = new ArrayList<String>();
        this.replaceToRows(str, parameters, remainRows, finalRows);
        for (String row : remainRows) {
            List<Row> nestedRows = this.replaceToRows(row, parameters);
            finalRows.addAll(nestedRows);
        }
        return finalRows;
    }

    private void replaceToRows(String str, Map<String, Object> parameters, List<String> remainRows, List<Row> finalRows) {
        Row row = this.parseToRow(str, parameters);
        if (row.varCount == 0 && row.cartesianProductCount == 1) {
            finalRows.add(row);
            return;
        }
        this.resolve(row, remainRows);
    }

    private Row parseToRow(String str, Map<String, Object> parameters) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(str);
        Row row = new Row();
        int last = 0;
        while (matcher.find()) {
            row.parts.add(new SplitPart(false, str.substring(last, matcher.start())));
            last = matcher.end();
            if (matcher.group("escape") != null) {
                row.parts.add(new SplitPart(false, matcher.group().substring(1)));
                continue;
            }
            String name = matcher.group("name");
            Object value = this.findValue(parameters, name);
            if (value instanceof Collection) {
                row.cartesianProductCount *= ((Collection)value).size();
            }
            if (value != null) {
                ++row.varCount;
            }
            SplitPart splitPart = new SplitPart(value != null, matcher.group());
            splitPart.value = value;
            row.parts.add(splitPart);
        }
        row.parts.add(new SplitPart(false, str.substring(last)));
        return row;
    }

    private void resolve(Row row, List<String> resolvedRows) {
        ArrayList<StringBuilder> stringBuilders = new ArrayList<StringBuilder>();
        for (int idx = 0; idx < row.cartesianProductCount; ++idx) {
            stringBuilders.add(new StringBuilder());
        }
        int collectionRepeatCount = 1;
        for (SplitPart part : row.parts) {
            int idx;
            if (!part.var) {
                for (idx = 0; idx < row.cartesianProductCount; ++idx) {
                    StringBuilder sb = (StringBuilder)stringBuilders.get(idx);
                    if (part.fullName.startsWith("$")) {
                        sb.append("\\" + part.fullName);
                        continue;
                    }
                    sb.append(part.fullName);
                }
                continue;
            }
            if (part.value instanceof Collection) {
                int size = ((Collection)part.value).size();
                int rowRepeatCount = row.cartesianProductCount / size / collectionRepeatCount;
                int valueIdx = 0;
                for (int collectionRepeatIdx = 0; collectionRepeatIdx < collectionRepeatCount; ++collectionRepeatIdx) {
                    for (String value : (Collection)part.value) {
                        for (int repeatIdx = 0; repeatIdx < rowRepeatCount; ++repeatIdx) {
                            StringBuilder sb = (StringBuilder)stringBuilders.get(valueIdx);
                            ++valueIdx;
                            sb.append(value);
                        }
                    }
                }
                collectionRepeatCount *= size;
                continue;
            }
            for (idx = 0; idx < row.cartesianProductCount; ++idx) {
                StringBuilder sb = (StringBuilder)stringBuilders.get(idx);
                sb.append(part.value);
            }
        }
        for (StringBuilder sb : stringBuilders) {
            resolvedRows.add(sb.toString());
        }
    }

    private Object findValue(Map<String, Object> parameters, String key) {
        Object value = parameters.get(key);
        if (value == null) {
            value = ConfigUtil.getProperty(key);
        }
        return value;
    }

    static class Row {
        List<SplitPart> parts = new ArrayList<SplitPart>();
        int cartesianProductCount = 1;
        int varCount = 0;

        Row() {
        }
    }

    static class SplitPart {
        boolean var;
        String fullName;
        Object value;

        public SplitPart(boolean var, String fullName) {
            this.var = var;
            this.fullName = fullName;
        }

        public String toString() {
            return "SplitPart{var=" + this.var + ", fullName='" + this.fullName + '\'' + ", value=" + this.value + '}';
        }
    }
}

