/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.rewrite;

import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class HttpMessageWriterResponse
implements ServerHttpResponse {
    private final HttpHeaders headers = new HttpHeaders();
    private final DataBufferFactory dataBufferFactory;
    private Publisher<? extends DataBuffer> body;

    public HttpMessageWriterResponse(DataBufferFactory dataBufferFactory) {
        this.dataBufferFactory = dataBufferFactory;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        this.body = body;
        return Mono.empty();
    }

    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        return this.writeWith((Publisher<? extends DataBuffer>)Flux.from(body).flatMapSequential(p -> p));
    }

    public Publisher<? extends DataBuffer> getBody() {
        return this.body;
    }

    public boolean setStatusCode(HttpStatus status) {
        return false;
    }

    public HttpStatus getStatusCode() {
        return null;
    }

    public MultiValueMap<String, ResponseCookie> getCookies() {
        return null;
    }

    public void addCookie(ResponseCookie cookie) {
    }

    public DataBufferFactory bufferFactory() {
        return this.dataBufferFactory;
    }

    public void beforeCommit(Supplier<? extends Mono<Void>> action) {
    }

    public boolean isCommitted() {
        return false;
    }

    public Mono<Void> setComplete() {
        return null;
    }
}

