/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.jmx;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.boot.actuate.endpoint.jmx.AbstractJmxEndpoint;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AuditEventsJmxEndpoint
extends AbstractJmxEndpoint {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private final AuditEventRepository auditEventRepository;

    public AuditEventsJmxEndpoint(ObjectMapper objectMapper, AuditEventRepository auditEventRepository) {
        super(objectMapper);
        Assert.notNull((Object)auditEventRepository, (String)"AuditEventRepository must not be null");
        this.auditEventRepository = auditEventRepository;
    }

    @ManagedOperation(description="Retrieves a list of audit events meeting the given criteria")
    public Object getData(String dateAfter) {
        List<AuditEvent> auditEvents = this.auditEventRepository.find(this.parseDate(dateAfter));
        return this.convert(auditEvents);
    }

    @ManagedOperation(description="Retrieves a list of audit events meeting the given criteria")
    public Object getData(String dateAfter, String principal) {
        List<AuditEvent> auditEvents = this.auditEventRepository.find(principal, this.parseDate(dateAfter));
        return this.convert(auditEvents);
    }

    @ManagedOperation(description="Retrieves a list of audit events meeting the given criteria")
    public Object getData(String principal, String dateAfter, String type) {
        List<AuditEvent> auditEvents = this.auditEventRepository.find(principal, this.parseDate(dateAfter), type);
        return this.convert(auditEvents);
    }

    private Date parseDate(String date) {
        try {
            if (StringUtils.hasLength((String)date)) {
                return new SimpleDateFormat(DATE_FORMAT).parse(date);
            }
            return null;
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

