/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.cloudfoundry;

import java.util.Iterator;
import java.util.Set;
import org.springframework.boot.actuate.cloudfoundry.CloudFoundryDiscoveryMvcEndpoint;
import org.springframework.boot.actuate.cloudfoundry.CloudFoundryHealthMvcEndpoint;
import org.springframework.boot.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.AbstractEndpointHandlerMapping;
import org.springframework.boot.actuate.endpoint.mvc.AbstractEndpointMvcAdapter;
import org.springframework.boot.actuate.endpoint.mvc.HalJsonMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.HealthMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.NamedMvcEndpoint;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.HandlerInterceptor;

class CloudFoundryEndpointHandlerMapping
extends AbstractEndpointHandlerMapping<NamedMvcEndpoint> {
    CloudFoundryEndpointHandlerMapping(Set<? extends NamedMvcEndpoint> endpoints, CorsConfiguration corsConfiguration, HandlerInterceptor securityInterceptor) {
        super(endpoints, corsConfiguration);
        this.setSecurityInterceptor(securityInterceptor);
    }

    @Override
    protected void postProcessEndpoints(Set<NamedMvcEndpoint> endpoints) {
        super.postProcessEndpoints(endpoints);
        Iterator<NamedMvcEndpoint> iterator = endpoints.iterator();
        AbstractEndpointMvcAdapter healthMvcEndpoint = null;
        while (iterator.hasNext()) {
            NamedMvcEndpoint endpoint = iterator.next();
            if (endpoint instanceof HalJsonMvcEndpoint) {
                iterator.remove();
                continue;
            }
            if (!(endpoint instanceof HealthMvcEndpoint)) continue;
            iterator.remove();
            healthMvcEndpoint = (HealthMvcEndpoint)endpoint;
        }
        if (healthMvcEndpoint != null) {
            endpoints.add(new CloudFoundryHealthMvcEndpoint((HealthEndpoint)healthMvcEndpoint.getDelegate()));
        }
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.detectHandlerMethods(new CloudFoundryDiscoveryMvcEndpoint(this.getEndpoints()));
    }

    @Override
    protected String getPath(MvcEndpoint endpoint) {
        if (endpoint instanceof NamedMvcEndpoint) {
            return "/" + ((NamedMvcEndpoint)endpoint).getName();
        }
        return super.getPath(endpoint);
    }
}

