/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.servo;

import com.netflix.servo.monitor.MaxGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.NumericMonitor;
import com.netflix.servo.monitor.StepCounter;
import com.netflix.servo.util.Clock;
import com.netflix.spectator.api.AbstractTimer;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.servo.DoubleCounter;
import com.netflix.spectator.servo.FactorMonitor;
import com.netflix.spectator.servo.ServoClock;
import com.netflix.spectator.servo.ServoMeter;
import com.netflix.spectator.servo.ServoRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class ServoTimer
extends AbstractTimer
implements ServoMeter {
    private static final double CNV_SECONDS = 1.0 / (double)TimeUnit.SECONDS.toNanos(1L);
    private static final double CNV_SQUARES = CNV_SECONDS * CNV_SECONDS;
    private final Id id;
    private final AtomicLong count;
    private final AtomicLong totalTime;
    private final StepCounter servoCount;
    private final StepCounter servoTotal;
    private final DoubleCounter servoTotalOfSquares;
    private final MaxGauge servoMax;
    private final AtomicLong lastUpdated;

    ServoTimer(ServoRegistry r, Id id) {
        super(r.clock());
        this.id = id;
        this.count = new AtomicLong(0L);
        this.totalTime = new AtomicLong(0L);
        ServoClock sc = new ServoClock(this.clock);
        this.servoCount = new StepCounter(r.toMonitorConfig(id.withTag((Tag)Statistic.count), null), (Clock)sc);
        this.servoTotal = new StepCounter(r.toMonitorConfig(id.withTag((Tag)Statistic.totalTime), null), (Clock)sc);
        this.servoTotalOfSquares = new DoubleCounter(r.toMonitorConfig(id.withTag((Tag)Statistic.totalOfSquares), null), sc);
        this.servoMax = new MaxGauge(r.toMonitorConfig(id.withTag((Tag)Statistic.max), null));
        this.lastUpdated = new AtomicLong(this.clock.wallTime());
    }

    @Override
    public void addMonitors(List<Monitor<?>> monitors) {
        monitors.add((Monitor<?>)this.servoCount);
        monitors.add((Monitor<?>)new FactorMonitor(this.servoTotal, CNV_SECONDS));
        monitors.add((Monitor<?>)new FactorMonitor(this.servoTotalOfSquares, CNV_SQUARES));
        monitors.add((Monitor<?>)new FactorMonitor(this.servoMax, CNV_SECONDS));
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        long now = this.clock.wallTime();
        return now - this.lastUpdated.get() > ServoRegistry.EXPIRATION_TIME_MILLIS;
    }

    public void record(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            long nanos = unit.toNanos(amount);
            double nanosSquared = (double)nanos * (double)nanos;
            this.totalTime.addAndGet(nanos);
            this.count.incrementAndGet();
            this.servoTotal.increment(nanos);
            this.servoTotalOfSquares.increment(nanosSquared);
            this.servoCount.increment();
            this.servoMax.update(nanos);
            this.lastUpdated.set(this.clock.wallTime());
        }
    }

    private Measurement newMeasurement(Tag t, long timestamp, Number n) {
        return new Measurement(this.id.withTag(t), timestamp, n.doubleValue());
    }

    private double getValue(NumericMonitor<?> m, double factor) {
        return ((Number)m.getValue(0)).doubleValue() * factor;
    }

    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        ArrayList<Measurement> ms = new ArrayList<Measurement>(2);
        ms.add(this.newMeasurement((Tag)Statistic.count, now, this.servoCount.getValue(0)));
        ms.add(this.newMeasurement((Tag)Statistic.totalTime, now, this.getValue((NumericMonitor<?>)this.servoTotal, CNV_SECONDS)));
        ms.add(this.newMeasurement((Tag)Statistic.totalOfSquares, now, this.getValue(this.servoTotalOfSquares, CNV_SQUARES)));
        ms.add(this.newMeasurement((Tag)Statistic.max, now, this.getValue((NumericMonitor<?>)this.servoMax, CNV_SECONDS)));
        return ms;
    }

    public long count() {
        return this.count.get();
    }

    public long totalTime() {
        return this.totalTime.get();
    }
}

