/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.util;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

public abstract class SpringFactoryImportSelector<T>
implements DeferredImportSelector,
BeanClassLoaderAware,
EnvironmentAware {
    private ClassLoader beanClassLoader;
    private Class<T> annotationClass;
    private Environment environment;
    private final Log log = LogFactory.getLog(SpringFactoryImportSelector.class);

    protected SpringFactoryImportSelector() {
        this.annotationClass = GenericTypeResolver.resolveTypeArgument(this.getClass(), SpringFactoryImportSelector.class);
    }

    public String[] selectImports(AnnotationMetadata metadata) {
        if (!this.isEnabled()) {
            return new String[0];
        }
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(this.annotationClass.getName(), true));
        Assert.notNull((Object)attributes, (String)("No " + this.getSimpleName() + " attributes found. Is " + metadata.getClassName() + " annotated with @" + this.getSimpleName() + "?"));
        ArrayList factories = new ArrayList(new LinkedHashSet(SpringFactoriesLoader.loadFactoryNames(this.annotationClass, (ClassLoader)this.beanClassLoader)));
        if (factories.isEmpty() && !this.hasDefaultFactory()) {
            throw new IllegalStateException("Annotation @" + this.getSimpleName() + " found, but there are no implementations. Did you forget to include a starter?");
        }
        if (factories.size() > 1) {
            this.log.warn((Object)("More than one implementation of @" + this.getSimpleName() + " (now relying on @Conditionals to pick one): " + factories));
        }
        return factories.toArray(new String[factories.size()]);
    }

    protected boolean hasDefaultFactory() {
        return false;
    }

    protected abstract boolean isEnabled();

    protected String getSimpleName() {
        return this.annotationClass.getSimpleName();
    }

    protected Class<T> getAnnotationClass() {
        return this.annotationClass;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }
}

