/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.netflix.servo.Metric;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.util.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMetricPoller
implements MetricPoller {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public abstract List<Metric> pollImpl(boolean var1);

    @Override
    public final List<Metric> poll(MetricFilter filter) {
        return this.poll(filter, false);
    }

    @Override
    public final List<Metric> poll(MetricFilter filter, boolean reset) {
        Preconditions.checkNotNull(filter, "filter");
        List<Metric> metrics = this.pollImpl(reset);
        List retained = metrics.stream().filter(m -> filter.matches(m.getConfig())).collect(Collectors.toList());
        this.logger.debug("received {} metrics, retained {} metrics", (Object)metrics.size(), (Object)retained.size());
        return Collections.unmodifiableList(retained);
    }
}

