/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import com.fasterxml.jackson.databind.util.ArrayBuilders;
import io.protostuff.ByteString;
import io.protostuff.InputEx;
import io.protostuff.ProtobufException;
import io.protostuff.SchemaReader;
import io.protostuff.StringSerializer;
import io.protostuff.WireFormat;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class ByteArrayInputEx
implements InputEx {
    private final byte[] buffer;
    private int offset;
    private int limit;
    private int lastTag = 0;
    private int packedLimit = 0;
    private ArrayBuilders arrayBuilders;

    public ByteArrayInputEx(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public ByteArrayInputEx(byte[] buffer, int offset, int len) {
        this.buffer = buffer;
        this.offset = offset;
        this.limit = offset + len;
    }

    public boolean isCurrentFieldPacked() {
        return this.packedLimit != 0 && this.packedLimit != this.offset;
    }

    public int readTag() throws IOException {
        if (this.offset == this.limit) {
            this.lastTag = 0;
            return 0;
        }
        int tag = this.readRawVarint32();
        if (tag >>> 3 == 0) {
            throw ProtobufException.invalidTag();
        }
        this.lastTag = tag;
        return tag;
    }

    public void checkLastTagWas(int value) throws ProtobufException {
        if (this.lastTag != value) {
            throw ProtobufException.invalidEndTag();
        }
    }

    public boolean skipField(int tag) throws IOException {
        switch (WireFormat.getTagWireType((int)tag)) {
            case 0: {
                this.readInt32();
                return true;
            }
            case 1: {
                this.readRawLittleEndian64();
                return true;
            }
            case 2: {
                int size = this.readRawVarint32();
                if (size < 0) {
                    throw ProtobufException.negativeSize();
                }
                this.offset += size;
                return true;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(WireFormat.makeTag((int)WireFormat.getTagFieldNumber((int)tag), (int)4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.readRawLittleEndian32();
                return true;
            }
        }
        throw ProtobufException.invalidWireType();
    }

    public void skipMessage() throws IOException {
        int tag;
        while ((tag = this.readTag()) != 0 && this.skipField(tag)) {
        }
    }

    @Override
    public void handleUnknownField(int fieldNumber) throws IOException {
        this.skipField(this.lastTag);
    }

    @Override
    public int readFieldNumber() throws IOException {
        if (this.offset == this.limit) {
            this.lastTag = 0;
            return 0;
        }
        if (this.isCurrentFieldPacked()) {
            if (this.packedLimit < this.offset) {
                throw ProtobufException.misreportedSize();
            }
            return this.lastTag >>> 3;
        }
        this.packedLimit = 0;
        int tag = this.readRawVarint32();
        int fieldNumber = tag >>> 3;
        if (fieldNumber == 0) {
            throw ProtobufException.invalidTag();
        }
        this.lastTag = tag;
        return fieldNumber;
    }

    private void checkIfPackedField() throws IOException {
        if (this.packedLimit == 0 && WireFormat.getTagWireType((int)this.lastTag) == 2) {
            int length = this.readRawVarint32();
            if (length < 0) {
                throw ProtobufException.negativeSize();
            }
            if (this.offset + length > this.limit) {
                throw ProtobufException.misreportedSize();
            }
            this.packedLimit = this.offset + length;
        }
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    @Override
    public long readUInt64() throws IOException {
        return this.readRawVarint64();
    }

    @Override
    public long readInt64() throws IOException {
        return this.readRawVarint64();
    }

    @Override
    public int readInt32() throws IOException {
        return this.readRawVarint32();
    }

    @Override
    public long readFixed64() {
        return this.readRawLittleEndian64();
    }

    @Override
    public int readFixed32() {
        return this.readRawLittleEndian32();
    }

    @Override
    public boolean readBool() {
        return this.buffer[this.offset++] != 0;
    }

    @Override
    public int readUInt32() throws IOException {
        return this.readRawVarint32();
    }

    @Override
    public int readEnum() throws IOException {
        return this.readRawVarint32();
    }

    @Override
    public int readSFixed32() {
        return this.readRawLittleEndian32();
    }

    @Override
    public long readSFixed64() {
        return this.readRawLittleEndian64();
    }

    @Override
    public int readSInt32() throws IOException {
        int n = this.readRawVarint32();
        return n >>> 1 ^ -(n & 1);
    }

    @Override
    public long readSInt64() throws IOException {
        long n = this.readRawVarint64();
        return n >>> 1 ^ -(n & 1L);
    }

    @Override
    public String readString() throws IOException {
        int length = this.readRawVarint32();
        if (length < 0) {
            throw ProtobufException.negativeSize();
        }
        if (this.offset + length > this.limit) {
            throw ProtobufException.misreportedSize();
        }
        int offset = this.offset;
        this.offset += length;
        return StringSerializer.STRING.deser((byte[])this.buffer, (int)offset, (int)length);
    }

    @Override
    public ByteString readBytes() throws IOException {
        return ByteString.wrap((byte[])this.readByteArray());
    }

    @Override
    public byte[] readByteArray() throws IOException {
        int length = this.readRawVarint32();
        if (length < 0) {
            throw ProtobufException.negativeSize();
        }
        if (this.offset + length > this.limit) {
            throw ProtobufException.misreportedSize();
        }
        byte[] copy = new byte[length];
        System.arraycopy(this.buffer, this.offset, copy, 0, length);
        this.offset += length;
        return copy;
    }

    @Override
    public <T> T mergeObject(T value, SchemaReader<T> schema) throws IOException {
        int length = this.readRawVarint32();
        if (length < 0) {
            throw ProtobufException.negativeSize();
        }
        int oldLimit = this.limit;
        this.limit = this.offset + length;
        if (value == null) {
            value = schema.newMessage();
        }
        schema.mergeFrom(this, value);
        this.checkLastTagWas(0);
        this.limit = oldLimit;
        return value;
    }

    public int readRawVarint32() throws IOException {
        byte tmp;
        if ((tmp = this.buffer[this.offset++]) >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        if ((tmp = this.buffer[this.offset++]) >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            if ((tmp = this.buffer[this.offset++]) >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                if ((tmp = this.buffer[this.offset++]) >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = this.buffer[this.offset++];
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (this.buffer[this.offset++] < 0) continue;
                            return result;
                        }
                        throw ProtobufException.malformedVarint();
                    }
                }
            }
        }
        return result;
    }

    public long readRawVarint64() throws IOException {
        byte[] buffer = this.buffer;
        int offset = this.offset;
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = buffer[offset++];
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            this.offset = offset;
            return result;
        }
        throw ProtobufException.malformedVarint();
    }

    public int readRawLittleEndian32() {
        byte[] buffer = this.buffer;
        int offset = this.offset;
        byte b1 = buffer[offset++];
        byte b2 = buffer[offset++];
        byte b3 = buffer[offset++];
        byte b4 = buffer[offset++];
        this.offset = offset;
        return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
    }

    public long readRawLittleEndian64() {
        byte[] buffer = this.buffer;
        int offset = this.offset;
        byte b1 = buffer[offset++];
        byte b2 = buffer[offset++];
        byte b3 = buffer[offset++];
        byte b4 = buffer[offset++];
        byte b5 = buffer[offset++];
        byte b6 = buffer[offset++];
        byte b7 = buffer[offset++];
        byte b8 = buffer[offset++];
        this.offset = offset;
        return (long)b1 & 0xFFL | ((long)b2 & 0xFFL) << 8 | ((long)b3 & 0xFFL) << 16 | ((long)b4 & 0xFFL) << 24 | ((long)b5 & 0xFFL) << 32 | ((long)b6 & 0xFFL) << 40 | ((long)b7 & 0xFFL) << 48 | ((long)b8 & 0xFFL) << 56;
    }

    @Override
    public ByteBuffer readByteBuffer() throws IOException {
        return ByteBuffer.wrap(this.readByteArray());
    }

    @Override
    public ArrayBuilders getArrayBuilders() {
        if (this.arrayBuilders == null) {
            this.arrayBuilders = new ArrayBuilders();
        }
        return this.arrayBuilders;
    }

    @Override
    public int readPackedInt32() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarint32();
    }

    @Override
    public int readPackedUInt32() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarint32();
    }

    @Override
    public int readPackedSInt32() throws IOException {
        this.checkIfPackedField();
        int n = this.readRawVarint32();
        return n >>> 1 ^ -(n & 1);
    }

    @Override
    public int readPackedFixed32() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian32();
    }

    @Override
    public int readPackedSFixed32() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian32();
    }

    @Override
    public long readPackedInt64() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarint64();
    }

    @Override
    public long readPackedUInt64() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarint64();
    }

    @Override
    public long readPackedSInt64() throws IOException {
        this.checkIfPackedField();
        long n = this.readRawVarint64();
        return n >>> 1 ^ -(n & 1L);
    }

    @Override
    public long readPackedFixed64() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian64();
    }

    @Override
    public long readPackedSFixed64() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian64();
    }

    @Override
    public float readPackedFloat() throws IOException {
        this.checkIfPackedField();
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    @Override
    public double readPackedDouble() throws IOException {
        this.checkIfPackedField();
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    @Override
    public boolean readPackedBool() throws IOException {
        this.checkIfPackedField();
        return this.buffer[this.offset++] != 0;
    }

    @Override
    public int readPackedEnum() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarint32();
    }
}

