/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon;

import com.netflix.client.config.ClientConfigFactory;
import com.netflix.ribbon.ClientOptions;
import com.netflix.ribbon.DefaultResourceFactory;
import com.netflix.ribbon.RibbonTransportFactory;
import com.netflix.ribbon.http.HttpResourceGroup;
import com.netflix.ribbon.proxy.RibbonDynamicProxy;
import com.netflix.ribbon.proxy.processor.AnnotationProcessorsProvider;

public abstract class RibbonResourceFactory {
    protected final ClientConfigFactory clientConfigFactory;
    protected final RibbonTransportFactory transportFactory;
    protected final AnnotationProcessorsProvider annotationProcessors;
    public static final RibbonResourceFactory DEFAULT = new DefaultResourceFactory(ClientConfigFactory.DEFAULT, RibbonTransportFactory.DEFAULT, AnnotationProcessorsProvider.DEFAULT);

    public RibbonResourceFactory(ClientConfigFactory configFactory, RibbonTransportFactory transportFactory, AnnotationProcessorsProvider processors) {
        this.clientConfigFactory = configFactory;
        this.transportFactory = transportFactory;
        this.annotationProcessors = processors;
    }

    public HttpResourceGroup.Builder createHttpResourceGroupBuilder(String name) {
        HttpResourceGroup.Builder builder = HttpResourceGroup.Builder.newBuilder(name, this.clientConfigFactory, this.transportFactory);
        return builder;
    }

    public HttpResourceGroup createHttpResourceGroup(String name) {
        HttpResourceGroup.Builder builder = this.createHttpResourceGroupBuilder(name);
        return builder.build();
    }

    public <T> T from(Class<T> classType) {
        return RibbonDynamicProxy.newInstance(classType, this, this.clientConfigFactory, this.transportFactory, this.annotationProcessors);
    }

    public HttpResourceGroup createHttpResourceGroup(String name, ClientOptions options) {
        HttpResourceGroup.Builder builder = this.createHttpResourceGroupBuilder(name);
        builder.withClientOptions(options);
        return builder.build();
    }

    public final RibbonTransportFactory getTransportFactory() {
        return this.transportFactory;
    }

    public final ClientConfigFactory getClientConfigFactory() {
        return this.clientConfigFactory;
    }
}

