/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.converter.property;

import java.util.Collection;

public enum SwaggerParamCollectionFormat {
    CSV("csv", ","),
    SSV("ssv", " "),
    TSV("tsv", "\t"),
    PIPES("pipes", "|"){

        @Override
        public String[] splitParam(String rawParam) {
            if (null == rawParam) {
                return new String[0];
            }
            return rawParam.split("\\|", -1);
        }
    }
    ,
    MULTI("multi", null){

        @Override
        public String[] splitParam(String rawParam) {
            if (null == rawParam) {
                return new String[0];
            }
            return new String[]{rawParam};
        }
    };

    private final String collectionFormat;
    private final String separator;

    private SwaggerParamCollectionFormat(String collectionFormat, String separator) {
        this.collectionFormat = collectionFormat;
        this.separator = separator;
    }

    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String[] splitParam(String rawParam) {
        if (null == rawParam) {
            return new String[0];
        }
        return rawParam.split(this.separator, -1);
    }

    public String joinParam(Collection<?> params) {
        if (null == params || params.isEmpty()) {
            return null;
        }
        StringBuilder paramBuilder = new StringBuilder();
        int nullCount = 0;
        for (Object param : params) {
            if (param == null) {
                ++nullCount;
                continue;
            }
            paramBuilder.append(param).append(this.separator);
        }
        if (nullCount == params.size()) {
            return null;
        }
        paramBuilder.setLength(paramBuilder.length() - 1);
        return paramBuilder.toString();
    }
}

