/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class UpdateStructureDataDetails extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 11297;
  }

  // Properties.
  protected final NodeId nodeId;
  protected final PerformUpdateType performInsertReplace;
  protected final List<DataValue> updateValues;

  public UpdateStructureDataDetails(
      NodeId nodeId, PerformUpdateType performInsertReplace, List<DataValue> updateValues) {
    super();
    this.nodeId = nodeId;
    this.performInsertReplace = performInsertReplace;
    this.updateValues = updateValues;
  }

  public NodeId getNodeId() {
    return nodeId;
  }

  public PerformUpdateType getPerformInsertReplace() {
    return performInsertReplace;
  }

  public List<DataValue> getUpdateValues() {
    return updateValues;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("UpdateStructureDataDetails");

    // Simple Field (nodeId)
    writeSimpleField("nodeId", nodeId, writeComplex(writeBuffer));

    // Simple Field (performInsertReplace)
    writeSimpleEnumField(
        "performInsertReplace",
        "PerformUpdateType",
        performInsertReplace,
        writeEnum(
            PerformUpdateType::getValue,
            PerformUpdateType::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Implicit Field (noOfUpdateValues) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfUpdateValues =
        (int) ((((getUpdateValues()) == (null)) ? -(1) : COUNT(getUpdateValues())));
    writeImplicitField("noOfUpdateValues", noOfUpdateValues, writeSignedInt(writeBuffer, 32));

    // Array Field (updateValues)
    writeComplexTypeArrayField("updateValues", updateValues, writeBuffer);

    writeBuffer.popContext("UpdateStructureDataDetails");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    UpdateStructureDataDetails _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (nodeId)
    lengthInBits += nodeId.getLengthInBits();

    // Simple field (performInsertReplace)
    lengthInBits += 32;

    // Implicit Field (noOfUpdateValues)
    lengthInBits += 32;

    // Array field
    if (updateValues != null) {
      int i = 0;
      for (DataValue element : updateValues) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= updateValues.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("UpdateStructureDataDetails");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    NodeId nodeId =
        readSimpleField("nodeId", readComplex(() -> NodeId.staticParse(readBuffer), readBuffer));

    PerformUpdateType performInsertReplace =
        readEnumField(
            "performInsertReplace",
            "PerformUpdateType",
            readEnum(PerformUpdateType::enumForValue, readUnsignedLong(readBuffer, 32)));

    int noOfUpdateValues = readImplicitField("noOfUpdateValues", readSignedInt(readBuffer, 32));

    List<DataValue> updateValues =
        readCountArrayField(
            "updateValues",
            readComplex(() -> DataValue.staticParse(readBuffer), readBuffer),
            noOfUpdateValues);

    readBuffer.closeContext("UpdateStructureDataDetails");
    // Create the instance
    return new UpdateStructureDataDetailsBuilderImpl(nodeId, performInsertReplace, updateValues);
  }

  public static class UpdateStructureDataDetailsBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final NodeId nodeId;
    private final PerformUpdateType performInsertReplace;
    private final List<DataValue> updateValues;

    public UpdateStructureDataDetailsBuilderImpl(
        NodeId nodeId, PerformUpdateType performInsertReplace, List<DataValue> updateValues) {
      this.nodeId = nodeId;
      this.performInsertReplace = performInsertReplace;
      this.updateValues = updateValues;
    }

    public UpdateStructureDataDetails build() {
      UpdateStructureDataDetails updateStructureDataDetails =
          new UpdateStructureDataDetails(nodeId, performInsertReplace, updateValues);
      return updateStructureDataDetails;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof UpdateStructureDataDetails)) {
      return false;
    }
    UpdateStructureDataDetails that = (UpdateStructureDataDetails) o;
    return (getNodeId() == that.getNodeId())
        && (getPerformInsertReplace() == that.getPerformInsertReplace())
        && (getUpdateValues() == that.getUpdateValues())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getNodeId(), getPerformInsertReplace(), getUpdateValues());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
