/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PortableNodeId extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 24108;
  }

  // Properties.
  protected final PascalString namespaceUri;
  protected final NodeId identifier;

  public PortableNodeId(PascalString namespaceUri, NodeId identifier) {
    super();
    this.namespaceUri = namespaceUri;
    this.identifier = identifier;
  }

  public PascalString getNamespaceUri() {
    return namespaceUri;
  }

  public NodeId getIdentifier() {
    return identifier;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PortableNodeId");

    // Simple Field (namespaceUri)
    writeSimpleField("namespaceUri", namespaceUri, writeComplex(writeBuffer));

    // Simple Field (identifier)
    writeSimpleField("identifier", identifier, writeComplex(writeBuffer));

    writeBuffer.popContext("PortableNodeId");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    PortableNodeId _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (namespaceUri)
    lengthInBits += namespaceUri.getLengthInBits();

    // Simple field (identifier)
    lengthInBits += identifier.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("PortableNodeId");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString namespaceUri =
        readSimpleField(
            "namespaceUri", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    NodeId identifier =
        readSimpleField(
            "identifier", readComplex(() -> NodeId.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("PortableNodeId");
    // Create the instance
    return new PortableNodeIdBuilderImpl(namespaceUri, identifier);
  }

  public static class PortableNodeIdBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString namespaceUri;
    private final NodeId identifier;

    public PortableNodeIdBuilderImpl(PascalString namespaceUri, NodeId identifier) {
      this.namespaceUri = namespaceUri;
      this.identifier = identifier;
    }

    public PortableNodeId build() {
      PortableNodeId portableNodeId = new PortableNodeId(namespaceUri, identifier);
      return portableNodeId;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PortableNodeId)) {
      return false;
    }
    PortableNodeId that = (PortableNodeId) o;
    return (getNamespaceUri() == that.getNamespaceUri())
        && (getIdentifier() == that.getIdentifier())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getNamespaceUri(), getIdentifier());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
