/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CIPAttributes implements Message {

  // Properties.
  protected final List<Integer> classId;
  protected final Integer numberAvailable;
  protected final Integer numberActive;
  protected final byte[] data;

  public CIPAttributes(
      List<Integer> classId, Integer numberAvailable, Integer numberActive, byte[] data) {
    super();
    this.classId = classId;
    this.numberAvailable = numberAvailable;
    this.numberActive = numberActive;
    this.data = data;
  }

  public List<Integer> getClassId() {
    return classId;
  }

  public Integer getNumberAvailable() {
    return numberAvailable;
  }

  public Integer getNumberActive() {
    return numberActive;
  }

  public byte[] getData() {
    return data;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CIPAttributes");

    // Implicit Field (numberOfClasses) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int numberOfClasses = (int) (COUNT(getClassId()));
    writeImplicitField("numberOfClasses", numberOfClasses, writeUnsignedInt(writeBuffer, 16));

    // Array Field (classId)
    writeSimpleTypeArrayField("classId", classId, writeUnsignedInt(writeBuffer, 16));

    // Optional Field (numberAvailable) (Can be skipped, if the value is null)
    writeOptionalField("numberAvailable", numberAvailable, writeUnsignedInt(writeBuffer, 16));

    // Optional Field (numberActive) (Can be skipped, if the value is null)
    writeOptionalField("numberActive", numberActive, writeUnsignedInt(writeBuffer, 16));

    // Array Field (data)
    writeByteArrayField("data", data, writeByteArray(writeBuffer, 8));

    writeBuffer.popContext("CIPAttributes");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    CIPAttributes _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (numberOfClasses)
    lengthInBits += 16;

    // Array field
    if (classId != null) {
      lengthInBits += 16 * classId.size();
    }

    // Optional Field (numberAvailable)
    if (numberAvailable != null) {
      lengthInBits += 16;
    }

    // Optional Field (numberActive)
    if (numberActive != null) {
      lengthInBits += 16;
    }

    // Array field
    if (data != null) {
      lengthInBits += 8 * data.length;
    }

    return lengthInBits;
  }

  public static CIPAttributes staticParse(ReadBuffer readBuffer, Integer packetLength)
      throws ParseException {
    readBuffer.pullContext("CIPAttributes");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int numberOfClasses = readImplicitField("numberOfClasses", readUnsignedInt(readBuffer, 16));

    List<Integer> classId =
        readCountArrayField("classId", readUnsignedInt(readBuffer, 16), numberOfClasses);

    Integer numberAvailable =
        readOptionalField(
            "numberAvailable",
            readUnsignedInt(readBuffer, 16),
            (packetLength) >= (((((numberOfClasses) * (2))) + (4))));

    Integer numberActive =
        readOptionalField(
            "numberActive",
            readUnsignedInt(readBuffer, 16),
            (packetLength) >= (((((numberOfClasses) * (2))) + (6))));

    byte[] data =
        readBuffer.readByteArray(
            "data",
            Math.toIntExact(
                ((((packetLength) > (((((numberOfClasses) * (2))) + (6)))))
                    ? (packetLength) - (((((numberOfClasses) * (2))) + (6)))
                    : 0)));

    readBuffer.closeContext("CIPAttributes");
    // Create the instance
    CIPAttributes _cIPAttributes;
    _cIPAttributes = new CIPAttributes(classId, numberAvailable, numberActive, data);
    return _cIPAttributes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CIPAttributes)) {
      return false;
    }
    CIPAttributes that = (CIPAttributes) o;
    return (getClassId() == that.getClassId())
        && (getNumberAvailable() == that.getNumberAvailable())
        && (getNumberActive() == that.getNumberActive())
        && (getData() == that.getData())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getClassId(), getNumberAvailable(), getNumberActive(), getData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
