/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * ctrlX CORE - Data Layer API
 * This is the base API for the ctrlX Data Layer access on ctrlX CORE devices <ul> <li>Click 'Authorize' to open the 'Available authorizations' dialog.</li> <li>Enter 'username' and 'password'. The 'Client credentials location' selector together with the 'client_id' and 'client_secret' fields as well as the 'Bearer' section can be ignored.</li> <li>Click 'Authorize' and then 'Close' to close the 'Available authorizations' dialog.</li> <li>Try out those GET, PUT, ... operations you're interested in.</li> </ul>
 *
 * The version of the OpenAPI document: 2.1.0
 * Contact: support@boschrexroth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

/**
 * ReflectionField
 */
@JsonPropertyOrder({
  ReflectionField.JSON_PROPERTY_NAME,
  ReflectionField.JSON_PROPERTY_TYPE,
  ReflectionField.JSON_PROPERTY_ID,
  ReflectionField.JSON_PROPERTY_OFFSET,
  ReflectionField.JSON_PROPERTY_DEFAULT_INTEGER,
  ReflectionField.JSON_PROPERTY_DEFAULT_REAL,
  ReflectionField.JSON_PROPERTY_DEPRECATED,
  ReflectionField.JSON_PROPERTY_REQUIRED,
  ReflectionField.JSON_PROPERTY_KEY,
  ReflectionField.JSON_PROPERTY_ATTRIBUTES,
  ReflectionField.JSON_PROPERTY_DOCUMENTATION
})
@JsonTypeName("reflection_Field")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-18T13:34:36.056861+01:00[Europe/Berlin]")
public class ReflectionField {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_TYPE = "type";
  private ReflectionType type;

  public static final String JSON_PROPERTY_ID = "id";
  private Integer id;

  public static final String JSON_PROPERTY_OFFSET = "offset";
  private Integer offset;

  public static final String JSON_PROPERTY_DEFAULT_INTEGER = "default_integer";
  private Integer defaultInteger;

  public static final String JSON_PROPERTY_DEFAULT_REAL = "default_real";
  private BigDecimal defaultReal;

  public static final String JSON_PROPERTY_DEPRECATED = "deprecated";
  private Boolean deprecated;

  public static final String JSON_PROPERTY_REQUIRED = "required";
  private Boolean required;

  public static final String JSON_PROPERTY_KEY = "key";
  private Boolean key;

  public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
  private List<ReflectionKeyValue> attributes = new ArrayList<>();

  public static final String JSON_PROPERTY_DOCUMENTATION = "documentation";
  private List<String> documentation = new ArrayList<>();

  public ReflectionField() {
  }

  public ReflectionField name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public ReflectionField type(ReflectionType type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ReflectionType getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(ReflectionType type) {
    this.type = type;
  }


  public ReflectionField id(Integer id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * minimum: 0
   * maximum: 65535
   * @return id
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(Integer id) {
    this.id = id;
  }


  public ReflectionField offset(Integer offset) {
    
    this.offset = offset;
    return this;
  }

   /**
   * Get offset
   * minimum: 0
   * maximum: 65535
   * @return offset
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getOffset() {
    return offset;
  }


  @JsonProperty(JSON_PROPERTY_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOffset(Integer offset) {
    this.offset = offset;
  }


  public ReflectionField defaultInteger(Integer defaultInteger) {
    
    this.defaultInteger = defaultInteger;
    return this;
  }

   /**
   * Get defaultInteger
   * minimum: 9223372036854775616
   * maximum: -9223372036854775616
   * @return defaultInteger
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEFAULT_INTEGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDefaultInteger() {
    return defaultInteger;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_INTEGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultInteger(Integer defaultInteger) {
    this.defaultInteger = defaultInteger;
  }


  public ReflectionField defaultReal(BigDecimal defaultReal) {
    
    this.defaultReal = defaultReal;
    return this;
  }

   /**
   * Get defaultReal
   * @return defaultReal
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEFAULT_REAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getDefaultReal() {
    return defaultReal;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_REAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultReal(BigDecimal defaultReal) {
    this.defaultReal = defaultReal;
  }


  public ReflectionField deprecated(Boolean deprecated) {
    
    this.deprecated = deprecated;
    return this;
  }

   /**
   * Get deprecated
   * @return deprecated
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEPRECATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDeprecated() {
    return deprecated;
  }


  @JsonProperty(JSON_PROPERTY_DEPRECATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeprecated(Boolean deprecated) {
    this.deprecated = deprecated;
  }


  public ReflectionField required(Boolean required) {
    
    this.required = required;
    return this;
  }

   /**
   * Get required
   * @return required
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRequired() {
    return required;
  }


  @JsonProperty(JSON_PROPERTY_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequired(Boolean required) {
    this.required = required;
  }


  public ReflectionField key(Boolean key) {
    
    this.key = key;
    return this;
  }

   /**
   * Get key
   * @return key
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getKey() {
    return key;
  }


  @JsonProperty(JSON_PROPERTY_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKey(Boolean key) {
    this.key = key;
  }


  public ReflectionField attributes(List<ReflectionKeyValue> attributes) {
    
    this.attributes = attributes;
    return this;
  }

  public ReflectionField addAttributesItem(ReflectionKeyValue attributesItem) {
    if (this.attributes == null) {
      this.attributes = new ArrayList<>();
    }
    this.attributes.add(attributesItem);
    return this;
  }

   /**
   * Get attributes
   * @return attributes
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ReflectionKeyValue> getAttributes() {
    return attributes;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributes(List<ReflectionKeyValue> attributes) {
    this.attributes = attributes;
  }


  public ReflectionField documentation(List<String> documentation) {
    
    this.documentation = documentation;
    return this;
  }

  public ReflectionField addDocumentationItem(String documentationItem) {
    if (this.documentation == null) {
      this.documentation = new ArrayList<>();
    }
    this.documentation.add(documentationItem);
    return this;
  }

   /**
   * Get documentation
   * @return documentation
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DOCUMENTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDocumentation() {
    return documentation;
  }


  @JsonProperty(JSON_PROPERTY_DOCUMENTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDocumentation(List<String> documentation) {
    this.documentation = documentation;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReflectionField reflectionField = (ReflectionField) o;
    return Objects.equals(this.name, reflectionField.name) &&
        Objects.equals(this.type, reflectionField.type) &&
        Objects.equals(this.id, reflectionField.id) &&
        Objects.equals(this.offset, reflectionField.offset) &&
        Objects.equals(this.defaultInteger, reflectionField.defaultInteger) &&
        Objects.equals(this.defaultReal, reflectionField.defaultReal) &&
        Objects.equals(this.deprecated, reflectionField.deprecated) &&
        Objects.equals(this.required, reflectionField.required) &&
        Objects.equals(this.key, reflectionField.key) &&
        Objects.equals(this.attributes, reflectionField.attributes) &&
        Objects.equals(this.documentation, reflectionField.documentation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, type, id, offset, defaultInteger, defaultReal, deprecated, required, key, attributes, documentation);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReflectionField {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    offset: ").append(toIndentedString(offset)).append("\n");
    sb.append("    defaultInteger: ").append(toIndentedString(defaultInteger)).append("\n");
    sb.append("    defaultReal: ").append(toIndentedString(defaultReal)).append("\n");
    sb.append("    deprecated: ").append(toIndentedString(deprecated)).append("\n");
    sb.append("    required: ").append(toIndentedString(required)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    documentation: ").append(toIndentedString(documentation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `type` to the URL query string
    if (getType() != null) {
      joiner.add(getType().toUrlQueryString(prefix + "type" + suffix));
    }

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `offset` to the URL query string
    if (getOffset() != null) {
      try {
        joiner.add(String.format("%soffset%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOffset()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `default_integer` to the URL query string
    if (getDefaultInteger() != null) {
      try {
        joiner.add(String.format("%sdefault_integer%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDefaultInteger()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `default_real` to the URL query string
    if (getDefaultReal() != null) {
      try {
        joiner.add(String.format("%sdefault_real%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDefaultReal()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deprecated` to the URL query string
    if (getDeprecated() != null) {
      try {
        joiner.add(String.format("%sdeprecated%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeprecated()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `required` to the URL query string
    if (getRequired() != null) {
      try {
        joiner.add(String.format("%srequired%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRequired()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `key` to the URL query string
    if (getKey() != null) {
      try {
        joiner.add(String.format("%skey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `attributes` to the URL query string
    if (getAttributes() != null) {
      for (int i = 0; i < getAttributes().size(); i++) {
        if (getAttributes().get(i) != null) {
          joiner.add(getAttributes().get(i).toUrlQueryString(String.format("%sattributes%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `documentation` to the URL query string
    if (getDocumentation() != null) {
      for (int i = 0; i < getDocumentation().size(); i++) {
        try {
          joiner.add(String.format("%sdocumentation%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getDocumentation().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    return joiner.toString();
  }

}

