/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// VariantNodeId is the corresponding interface of VariantNodeId
type VariantNodeId interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	Variant
	// GetArrayLength returns ArrayLength (property field)
	GetArrayLength() *int32
	// GetValue returns Value (property field)
	GetValue() []NodeId
	// IsVariantNodeId is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsVariantNodeId()
	// CreateBuilder creates a VariantNodeIdBuilder
	CreateVariantNodeIdBuilder() VariantNodeIdBuilder
}

// _VariantNodeId is the data-structure of this message
type _VariantNodeId struct {
	VariantContract
	ArrayLength *int32
	Value       []NodeId
}

var _ VariantNodeId = (*_VariantNodeId)(nil)
var _ VariantRequirements = (*_VariantNodeId)(nil)

// NewVariantNodeId factory function for _VariantNodeId
func NewVariantNodeId(arrayLengthSpecified bool, arrayDimensionsSpecified bool, noOfArrayDimensions *int32, arrayDimensions []bool, arrayLength *int32, value []NodeId) *_VariantNodeId {
	_result := &_VariantNodeId{
		VariantContract: NewVariant(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions),
		ArrayLength:     arrayLength,
		Value:           value,
	}
	_result.VariantContract.(*_Variant)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// VariantNodeIdBuilder is a builder for VariantNodeId
type VariantNodeIdBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(value []NodeId) VariantNodeIdBuilder
	// WithArrayLength adds ArrayLength (property field)
	WithOptionalArrayLength(int32) VariantNodeIdBuilder
	// WithValue adds Value (property field)
	WithValue(...NodeId) VariantNodeIdBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() VariantBuilder
	// Build builds the VariantNodeId or returns an error if something is wrong
	Build() (VariantNodeId, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() VariantNodeId
}

// NewVariantNodeIdBuilder() creates a VariantNodeIdBuilder
func NewVariantNodeIdBuilder() VariantNodeIdBuilder {
	return &_VariantNodeIdBuilder{_VariantNodeId: new(_VariantNodeId)}
}

type _VariantNodeIdBuilder struct {
	*_VariantNodeId

	parentBuilder *_VariantBuilder

	collectedErr []error
}

var _ (VariantNodeIdBuilder) = (*_VariantNodeIdBuilder)(nil)

func (b *_VariantNodeIdBuilder) setParent(contract VariantContract) {
	b.VariantContract = contract
	contract.(*_Variant)._SubType = b._VariantNodeId
}

func (b *_VariantNodeIdBuilder) WithMandatoryFields(value []NodeId) VariantNodeIdBuilder {
	return b.WithValue(value...)
}

func (b *_VariantNodeIdBuilder) WithOptionalArrayLength(arrayLength int32) VariantNodeIdBuilder {
	b.ArrayLength = &arrayLength
	return b
}

func (b *_VariantNodeIdBuilder) WithValue(value ...NodeId) VariantNodeIdBuilder {
	b.Value = value
	return b
}

func (b *_VariantNodeIdBuilder) Build() (VariantNodeId, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._VariantNodeId.deepCopy(), nil
}

func (b *_VariantNodeIdBuilder) MustBuild() VariantNodeId {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_VariantNodeIdBuilder) Done() VariantBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewVariantBuilder().(*_VariantBuilder)
	}
	return b.parentBuilder
}

func (b *_VariantNodeIdBuilder) buildForVariant() (Variant, error) {
	return b.Build()
}

func (b *_VariantNodeIdBuilder) DeepCopy() any {
	_copy := b.CreateVariantNodeIdBuilder().(*_VariantNodeIdBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateVariantNodeIdBuilder creates a VariantNodeIdBuilder
func (b *_VariantNodeId) CreateVariantNodeIdBuilder() VariantNodeIdBuilder {
	if b == nil {
		return NewVariantNodeIdBuilder()
	}
	return &_VariantNodeIdBuilder{_VariantNodeId: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_VariantNodeId) GetVariantType() uint8 {
	return uint8(17)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_VariantNodeId) GetParent() VariantContract {
	return m.VariantContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_VariantNodeId) GetArrayLength() *int32 {
	return m.ArrayLength
}

func (m *_VariantNodeId) GetValue() []NodeId {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastVariantNodeId(structType any) VariantNodeId {
	if casted, ok := structType.(VariantNodeId); ok {
		return casted
	}
	if casted, ok := structType.(*VariantNodeId); ok {
		return *casted
	}
	return nil
}

func (m *_VariantNodeId) GetTypeName() string {
	return "VariantNodeId"
}

func (m *_VariantNodeId) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.VariantContract.(*_Variant).getLengthInBits(ctx))

	// Optional Field (arrayLength)
	if m.ArrayLength != nil {
		lengthInBits += 32
	}

	// Array field
	if len(m.Value) > 0 {
		for _curItem, element := range m.Value {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.Value), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_VariantNodeId) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_VariantNodeId) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_Variant, arrayLengthSpecified bool) (__variantNodeId VariantNodeId, err error) {
	m.VariantContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("VariantNodeId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for VariantNodeId")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	var arrayLength *int32
	arrayLength, err = ReadOptionalField[int32](ctx, "arrayLength", ReadSignedInt(readBuffer, uint8(32)), arrayLengthSpecified)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'arrayLength' field"))
	}
	m.ArrayLength = arrayLength

	value, err := ReadCountArrayField[NodeId](ctx, "value", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer), uint64(utils.InlineIf(bool((arrayLength) == (nil)), func() any { return int32(int32(1)) }, func() any { return int32((*arrayLength)) }).(int32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("VariantNodeId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for VariantNodeId")
	}

	return m, nil
}

func (m *_VariantNodeId) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_VariantNodeId) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("VariantNodeId"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for VariantNodeId")
		}

		if err := WriteOptionalField[int32](ctx, "arrayLength", m.GetArrayLength(), WriteSignedInt(writeBuffer, 32), true); err != nil {
			return errors.Wrap(err, "Error serializing 'arrayLength' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "value", m.GetValue(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if popErr := writeBuffer.PopContext("VariantNodeId"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for VariantNodeId")
		}
		return nil
	}
	return m.VariantContract.(*_Variant).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_VariantNodeId) IsVariantNodeId() {}

func (m *_VariantNodeId) DeepCopy() any {
	return m.deepCopy()
}

func (m *_VariantNodeId) deepCopy() *_VariantNodeId {
	if m == nil {
		return nil
	}
	_VariantNodeIdCopy := &_VariantNodeId{
		m.VariantContract.(*_Variant).deepCopy(),
		utils.CopyPtr[int32](m.ArrayLength),
		utils.DeepCopySlice[NodeId, NodeId](m.Value),
	}
	_VariantNodeIdCopy.VariantContract.(*_Variant)._SubType = m
	return _VariantNodeIdCopy
}

func (m *_VariantNodeId) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
