/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// RsaEncryptedSecret is the corresponding interface of RsaEncryptedSecret
type RsaEncryptedSecret interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsRsaEncryptedSecret is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsRsaEncryptedSecret()
	// CreateBuilder creates a RsaEncryptedSecretBuilder
	CreateRsaEncryptedSecretBuilder() RsaEncryptedSecretBuilder
}

// _RsaEncryptedSecret is the data-structure of this message
type _RsaEncryptedSecret struct {
}

var _ RsaEncryptedSecret = (*_RsaEncryptedSecret)(nil)

// NewRsaEncryptedSecret factory function for _RsaEncryptedSecret
func NewRsaEncryptedSecret() *_RsaEncryptedSecret {
	return &_RsaEncryptedSecret{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// RsaEncryptedSecretBuilder is a builder for RsaEncryptedSecret
type RsaEncryptedSecretBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() RsaEncryptedSecretBuilder
	// Build builds the RsaEncryptedSecret or returns an error if something is wrong
	Build() (RsaEncryptedSecret, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() RsaEncryptedSecret
}

// NewRsaEncryptedSecretBuilder() creates a RsaEncryptedSecretBuilder
func NewRsaEncryptedSecretBuilder() RsaEncryptedSecretBuilder {
	return &_RsaEncryptedSecretBuilder{_RsaEncryptedSecret: new(_RsaEncryptedSecret)}
}

type _RsaEncryptedSecretBuilder struct {
	*_RsaEncryptedSecret

	collectedErr []error
}

var _ (RsaEncryptedSecretBuilder) = (*_RsaEncryptedSecretBuilder)(nil)

func (b *_RsaEncryptedSecretBuilder) WithMandatoryFields() RsaEncryptedSecretBuilder {
	return b
}

func (b *_RsaEncryptedSecretBuilder) Build() (RsaEncryptedSecret, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._RsaEncryptedSecret.deepCopy(), nil
}

func (b *_RsaEncryptedSecretBuilder) MustBuild() RsaEncryptedSecret {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_RsaEncryptedSecretBuilder) DeepCopy() any {
	_copy := b.CreateRsaEncryptedSecretBuilder().(*_RsaEncryptedSecretBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateRsaEncryptedSecretBuilder creates a RsaEncryptedSecretBuilder
func (b *_RsaEncryptedSecret) CreateRsaEncryptedSecretBuilder() RsaEncryptedSecretBuilder {
	if b == nil {
		return NewRsaEncryptedSecretBuilder()
	}
	return &_RsaEncryptedSecretBuilder{_RsaEncryptedSecret: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastRsaEncryptedSecret(structType any) RsaEncryptedSecret {
	if casted, ok := structType.(RsaEncryptedSecret); ok {
		return casted
	}
	if casted, ok := structType.(*RsaEncryptedSecret); ok {
		return *casted
	}
	return nil
}

func (m *_RsaEncryptedSecret) GetTypeName() string {
	return "RsaEncryptedSecret"
}

func (m *_RsaEncryptedSecret) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_RsaEncryptedSecret) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func RsaEncryptedSecretParse(ctx context.Context, theBytes []byte) (RsaEncryptedSecret, error) {
	return RsaEncryptedSecretParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func RsaEncryptedSecretParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (RsaEncryptedSecret, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (RsaEncryptedSecret, error) {
		return RsaEncryptedSecretParseWithBuffer(ctx, readBuffer)
	}
}

func RsaEncryptedSecretParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (RsaEncryptedSecret, error) {
	v, err := (&_RsaEncryptedSecret{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_RsaEncryptedSecret) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__rsaEncryptedSecret RsaEncryptedSecret, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("RsaEncryptedSecret"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for RsaEncryptedSecret")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("RsaEncryptedSecret"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for RsaEncryptedSecret")
	}

	return m, nil
}

func (m *_RsaEncryptedSecret) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_RsaEncryptedSecret) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("RsaEncryptedSecret"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for RsaEncryptedSecret")
	}

	if popErr := writeBuffer.PopContext("RsaEncryptedSecret"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for RsaEncryptedSecret")
	}
	return nil
}

func (m *_RsaEncryptedSecret) IsRsaEncryptedSecret() {}

func (m *_RsaEncryptedSecret) DeepCopy() any {
	return m.deepCopy()
}

func (m *_RsaEncryptedSecret) deepCopy() *_RsaEncryptedSecret {
	if m == nil {
		return nil
	}
	_RsaEncryptedSecretCopy := &_RsaEncryptedSecret{}
	return _RsaEncryptedSecretCopy
}

func (m *_RsaEncryptedSecret) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
