/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// MeteringData is the corresponding interface of MeteringData
type MeteringData interface {
	MeteringDataContract
	MeteringDataRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsMeteringData is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsMeteringData()
	// CreateBuilder creates a MeteringDataBuilder
	CreateMeteringDataBuilder() MeteringDataBuilder
}

// MeteringDataContract provides a set of functions which can be overwritten by a sub struct
type MeteringDataContract interface {
	// GetCommandTypeContainer returns CommandTypeContainer (property field)
	GetCommandTypeContainer() MeteringCommandTypeContainer
	// GetArgument returns Argument (property field)
	GetArgument() byte
	// GetCommandType returns CommandType (virtual field)
	GetCommandType() MeteringCommandType
	// IsMeteringData is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsMeteringData()
	// CreateBuilder creates a MeteringDataBuilder
	CreateMeteringDataBuilder() MeteringDataBuilder
}

// MeteringDataRequirements provides a set of functions which need to be implemented by a sub struct
type MeteringDataRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetArgument returns Argument (discriminator field)
	GetArgument() byte
	// GetCommandType returns CommandType (discriminator field)
	GetCommandType() MeteringCommandType
}

// _MeteringData is the data-structure of this message
type _MeteringData struct {
	_SubType interface {
		MeteringDataContract
		MeteringDataRequirements
	}
	CommandTypeContainer MeteringCommandTypeContainer
	Argument             byte
}

var _ MeteringDataContract = (*_MeteringData)(nil)

// NewMeteringData factory function for _MeteringData
func NewMeteringData(commandTypeContainer MeteringCommandTypeContainer, argument byte) *_MeteringData {
	return &_MeteringData{CommandTypeContainer: commandTypeContainer, Argument: argument}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// MeteringDataBuilder is a builder for MeteringData
type MeteringDataBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(commandTypeContainer MeteringCommandTypeContainer, argument byte) MeteringDataBuilder
	// WithCommandTypeContainer adds CommandTypeContainer (property field)
	WithCommandTypeContainer(MeteringCommandTypeContainer) MeteringDataBuilder
	// WithArgument adds Argument (property field)
	WithArgument(byte) MeteringDataBuilder
	// AsMeteringDataMeasureElectricity converts this build to a subType of MeteringData. It is always possible to return to current builder using Done()
	AsMeteringDataMeasureElectricity() MeteringDataMeasureElectricityBuilder
	// AsMeteringDataMeasureGas converts this build to a subType of MeteringData. It is always possible to return to current builder using Done()
	AsMeteringDataMeasureGas() MeteringDataMeasureGasBuilder
	// AsMeteringDataMeasureDrinkingWater converts this build to a subType of MeteringData. It is always possible to return to current builder using Done()
	AsMeteringDataMeasureDrinkingWater() MeteringDataMeasureDrinkingWaterBuilder
	// AsMeteringDataMeasureOtherWater converts this build to a subType of MeteringData. It is always possible to return to current builder using Done()
	AsMeteringDataMeasureOtherWater() MeteringDataMeasureOtherWaterBuilder
	// AsMeteringDataMeasureOil converts this build to a subType of MeteringData. It is always possible to return to current builder using Done()
	AsMeteringDataMeasureOil() MeteringDataMeasureOilBuilder
	// AsMeteringDataElectricityConsumption converts this build to a subType of MeteringData. It is always possible to return to current builder using Done()
	AsMeteringDataElectricityConsumption() MeteringDataElectricityConsumptionBuilder
	// AsMeteringDataGasConsumption converts this build to a subType of MeteringData. It is always possible to return to current builder using Done()
	AsMeteringDataGasConsumption() MeteringDataGasConsumptionBuilder
	// AsMeteringDataDrinkingWaterConsumption converts this build to a subType of MeteringData. It is always possible to return to current builder using Done()
	AsMeteringDataDrinkingWaterConsumption() MeteringDataDrinkingWaterConsumptionBuilder
	// AsMeteringDataOtherWaterConsumption converts this build to a subType of MeteringData. It is always possible to return to current builder using Done()
	AsMeteringDataOtherWaterConsumption() MeteringDataOtherWaterConsumptionBuilder
	// AsMeteringDataOilConsumption converts this build to a subType of MeteringData. It is always possible to return to current builder using Done()
	AsMeteringDataOilConsumption() MeteringDataOilConsumptionBuilder
	// Build builds the MeteringData or returns an error if something is wrong
	PartialBuild() (MeteringDataContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() MeteringDataContract
	// Build builds the MeteringData or returns an error if something is wrong
	Build() (MeteringData, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() MeteringData
}

// NewMeteringDataBuilder() creates a MeteringDataBuilder
func NewMeteringDataBuilder() MeteringDataBuilder {
	return &_MeteringDataBuilder{_MeteringData: new(_MeteringData)}
}

type _MeteringDataChildBuilder interface {
	utils.Copyable
	setParent(MeteringDataContract)
	buildForMeteringData() (MeteringData, error)
}

type _MeteringDataBuilder struct {
	*_MeteringData

	childBuilder _MeteringDataChildBuilder

	collectedErr []error
}

var _ (MeteringDataBuilder) = (*_MeteringDataBuilder)(nil)

func (b *_MeteringDataBuilder) WithMandatoryFields(commandTypeContainer MeteringCommandTypeContainer, argument byte) MeteringDataBuilder {
	return b.WithCommandTypeContainer(commandTypeContainer).WithArgument(argument)
}

func (b *_MeteringDataBuilder) WithCommandTypeContainer(commandTypeContainer MeteringCommandTypeContainer) MeteringDataBuilder {
	b.CommandTypeContainer = commandTypeContainer
	return b
}

func (b *_MeteringDataBuilder) WithArgument(argument byte) MeteringDataBuilder {
	b.Argument = argument
	return b
}

func (b *_MeteringDataBuilder) PartialBuild() (MeteringDataContract, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._MeteringData.deepCopy(), nil
}

func (b *_MeteringDataBuilder) PartialMustBuild() MeteringDataContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_MeteringDataBuilder) AsMeteringDataMeasureElectricity() MeteringDataMeasureElectricityBuilder {
	if cb, ok := b.childBuilder.(MeteringDataMeasureElectricityBuilder); ok {
		return cb
	}
	cb := NewMeteringDataMeasureElectricityBuilder().(*_MeteringDataMeasureElectricityBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_MeteringDataBuilder) AsMeteringDataMeasureGas() MeteringDataMeasureGasBuilder {
	if cb, ok := b.childBuilder.(MeteringDataMeasureGasBuilder); ok {
		return cb
	}
	cb := NewMeteringDataMeasureGasBuilder().(*_MeteringDataMeasureGasBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_MeteringDataBuilder) AsMeteringDataMeasureDrinkingWater() MeteringDataMeasureDrinkingWaterBuilder {
	if cb, ok := b.childBuilder.(MeteringDataMeasureDrinkingWaterBuilder); ok {
		return cb
	}
	cb := NewMeteringDataMeasureDrinkingWaterBuilder().(*_MeteringDataMeasureDrinkingWaterBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_MeteringDataBuilder) AsMeteringDataMeasureOtherWater() MeteringDataMeasureOtherWaterBuilder {
	if cb, ok := b.childBuilder.(MeteringDataMeasureOtherWaterBuilder); ok {
		return cb
	}
	cb := NewMeteringDataMeasureOtherWaterBuilder().(*_MeteringDataMeasureOtherWaterBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_MeteringDataBuilder) AsMeteringDataMeasureOil() MeteringDataMeasureOilBuilder {
	if cb, ok := b.childBuilder.(MeteringDataMeasureOilBuilder); ok {
		return cb
	}
	cb := NewMeteringDataMeasureOilBuilder().(*_MeteringDataMeasureOilBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_MeteringDataBuilder) AsMeteringDataElectricityConsumption() MeteringDataElectricityConsumptionBuilder {
	if cb, ok := b.childBuilder.(MeteringDataElectricityConsumptionBuilder); ok {
		return cb
	}
	cb := NewMeteringDataElectricityConsumptionBuilder().(*_MeteringDataElectricityConsumptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_MeteringDataBuilder) AsMeteringDataGasConsumption() MeteringDataGasConsumptionBuilder {
	if cb, ok := b.childBuilder.(MeteringDataGasConsumptionBuilder); ok {
		return cb
	}
	cb := NewMeteringDataGasConsumptionBuilder().(*_MeteringDataGasConsumptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_MeteringDataBuilder) AsMeteringDataDrinkingWaterConsumption() MeteringDataDrinkingWaterConsumptionBuilder {
	if cb, ok := b.childBuilder.(MeteringDataDrinkingWaterConsumptionBuilder); ok {
		return cb
	}
	cb := NewMeteringDataDrinkingWaterConsumptionBuilder().(*_MeteringDataDrinkingWaterConsumptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_MeteringDataBuilder) AsMeteringDataOtherWaterConsumption() MeteringDataOtherWaterConsumptionBuilder {
	if cb, ok := b.childBuilder.(MeteringDataOtherWaterConsumptionBuilder); ok {
		return cb
	}
	cb := NewMeteringDataOtherWaterConsumptionBuilder().(*_MeteringDataOtherWaterConsumptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_MeteringDataBuilder) AsMeteringDataOilConsumption() MeteringDataOilConsumptionBuilder {
	if cb, ok := b.childBuilder.(MeteringDataOilConsumptionBuilder); ok {
		return cb
	}
	cb := NewMeteringDataOilConsumptionBuilder().(*_MeteringDataOilConsumptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_MeteringDataBuilder) Build() (MeteringData, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForMeteringData()
}

func (b *_MeteringDataBuilder) MustBuild() MeteringData {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_MeteringDataBuilder) DeepCopy() any {
	_copy := b.CreateMeteringDataBuilder().(*_MeteringDataBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_MeteringDataChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateMeteringDataBuilder creates a MeteringDataBuilder
func (b *_MeteringData) CreateMeteringDataBuilder() MeteringDataBuilder {
	if b == nil {
		return NewMeteringDataBuilder()
	}
	return &_MeteringDataBuilder{_MeteringData: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_MeteringData) GetCommandTypeContainer() MeteringCommandTypeContainer {
	return m.CommandTypeContainer
}

func (m *_MeteringData) GetArgument() byte {
	return m.Argument
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_MeteringData) GetCommandType() MeteringCommandType {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return CastMeteringCommandType(m.GetCommandTypeContainer().CommandType())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastMeteringData(structType any) MeteringData {
	if casted, ok := structType.(MeteringData); ok {
		return casted
	}
	if casted, ok := structType.(*MeteringData); ok {
		return *casted
	}
	return nil
}

func (m *_MeteringData) GetTypeName() string {
	return "MeteringData"
}

func (m *_MeteringData) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (commandTypeContainer)
	lengthInBits += 8

	// A virtual field doesn't have any in- or output.

	// Simple field (argument)
	lengthInBits += 8

	return lengthInBits
}

func (m *_MeteringData) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_MeteringData) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func MeteringDataParse[T MeteringData](ctx context.Context, theBytes []byte) (T, error) {
	return MeteringDataParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes))
}

func MeteringDataParseWithBufferProducer[T MeteringData]() func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := MeteringDataParseWithBuffer[T](ctx, readBuffer)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func MeteringDataParseWithBuffer[T MeteringData](ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	v, err := (&_MeteringData{}).parse(ctx, readBuffer)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_MeteringData) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__meteringData MeteringData, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("MeteringData"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for MeteringData")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(KnowsMeteringCommandTypeContainer(ctx, readBuffer)) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "no command type could be found"})
	}

	commandTypeContainer, err := ReadEnumField[MeteringCommandTypeContainer](ctx, "commandTypeContainer", "MeteringCommandTypeContainer", ReadEnum(MeteringCommandTypeContainerByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'commandTypeContainer' field"))
	}
	m.CommandTypeContainer = commandTypeContainer

	commandType, err := ReadVirtualField[MeteringCommandType](ctx, "commandType", (*MeteringCommandType)(nil), commandTypeContainer.CommandType())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'commandType' field"))
	}
	_ = commandType

	argument, err := ReadSimpleField(ctx, "argument", ReadByte(readBuffer, 8))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'argument' field"))
	}
	m.Argument = argument

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child MeteringData
	switch {
	case commandType == MeteringCommandType_EVENT && argument == 0x01: // MeteringDataMeasureElectricity
		if _child, err = new(_MeteringDataMeasureElectricity).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MeteringDataMeasureElectricity for type-switch of MeteringData")
		}
	case commandType == MeteringCommandType_EVENT && argument == 0x02: // MeteringDataMeasureGas
		if _child, err = new(_MeteringDataMeasureGas).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MeteringDataMeasureGas for type-switch of MeteringData")
		}
	case commandType == MeteringCommandType_EVENT && argument == 0x03: // MeteringDataMeasureDrinkingWater
		if _child, err = new(_MeteringDataMeasureDrinkingWater).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MeteringDataMeasureDrinkingWater for type-switch of MeteringData")
		}
	case commandType == MeteringCommandType_EVENT && argument == 0x04: // MeteringDataMeasureOtherWater
		if _child, err = new(_MeteringDataMeasureOtherWater).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MeteringDataMeasureOtherWater for type-switch of MeteringData")
		}
	case commandType == MeteringCommandType_EVENT && argument == 0x05: // MeteringDataMeasureOil
		if _child, err = new(_MeteringDataMeasureOil).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MeteringDataMeasureOil for type-switch of MeteringData")
		}
	case commandType == MeteringCommandType_EVENT && argument == 0x81: // MeteringDataElectricityConsumption
		if _child, err = new(_MeteringDataElectricityConsumption).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MeteringDataElectricityConsumption for type-switch of MeteringData")
		}
	case commandType == MeteringCommandType_EVENT && argument == 0x82: // MeteringDataGasConsumption
		if _child, err = new(_MeteringDataGasConsumption).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MeteringDataGasConsumption for type-switch of MeteringData")
		}
	case commandType == MeteringCommandType_EVENT && argument == 0x83: // MeteringDataDrinkingWaterConsumption
		if _child, err = new(_MeteringDataDrinkingWaterConsumption).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MeteringDataDrinkingWaterConsumption for type-switch of MeteringData")
		}
	case commandType == MeteringCommandType_EVENT && argument == 0x84: // MeteringDataOtherWaterConsumption
		if _child, err = new(_MeteringDataOtherWaterConsumption).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MeteringDataOtherWaterConsumption for type-switch of MeteringData")
		}
	case commandType == MeteringCommandType_EVENT && argument == 0x85: // MeteringDataOilConsumption
		if _child, err = new(_MeteringDataOilConsumption).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MeteringDataOilConsumption for type-switch of MeteringData")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [commandType=%v, argument=%v]", commandType, argument)
	}

	if closeErr := readBuffer.CloseContext("MeteringData"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for MeteringData")
	}

	return _child, nil
}

func (pm *_MeteringData) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child MeteringData, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("MeteringData"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for MeteringData")
	}

	if err := WriteSimpleEnumField[MeteringCommandTypeContainer](ctx, "commandTypeContainer", "MeteringCommandTypeContainer", m.GetCommandTypeContainer(), WriteEnum[MeteringCommandTypeContainer, uint8](MeteringCommandTypeContainer.GetValue, MeteringCommandTypeContainer.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
		return errors.Wrap(err, "Error serializing 'commandTypeContainer' field")
	}
	// Virtual field
	commandType := m.GetCommandType()
	_ = commandType
	if _commandTypeErr := writeBuffer.WriteVirtual(ctx, "commandType", m.GetCommandType()); _commandTypeErr != nil {
		return errors.Wrap(_commandTypeErr, "Error serializing 'commandType' field")
	}

	if err := WriteSimpleField[byte](ctx, "argument", m.GetArgument(), WriteByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'argument' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("MeteringData"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for MeteringData")
	}
	return nil
}

func (m *_MeteringData) IsMeteringData() {}

func (m *_MeteringData) DeepCopy() any {
	return m.deepCopy()
}

func (m *_MeteringData) deepCopy() *_MeteringData {
	if m == nil {
		return nil
	}
	_MeteringDataCopy := &_MeteringData{
		nil, // will be set by child
		m.CommandTypeContainer,
		m.Argument,
	}
	return _MeteringDataCopy
}
