/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataIPSubnetMask is the corresponding interface of BACnetConstructedDataIPSubnetMask
type BACnetConstructedDataIPSubnetMask interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetIpSubnetMask returns IpSubnetMask (property field)
	GetIpSubnetMask() BACnetApplicationTagOctetString
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagOctetString
	// IsBACnetConstructedDataIPSubnetMask is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataIPSubnetMask()
	// CreateBuilder creates a BACnetConstructedDataIPSubnetMaskBuilder
	CreateBACnetConstructedDataIPSubnetMaskBuilder() BACnetConstructedDataIPSubnetMaskBuilder
}

// _BACnetConstructedDataIPSubnetMask is the data-structure of this message
type _BACnetConstructedDataIPSubnetMask struct {
	BACnetConstructedDataContract
	IpSubnetMask BACnetApplicationTagOctetString
}

var _ BACnetConstructedDataIPSubnetMask = (*_BACnetConstructedDataIPSubnetMask)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataIPSubnetMask)(nil)

// NewBACnetConstructedDataIPSubnetMask factory function for _BACnetConstructedDataIPSubnetMask
func NewBACnetConstructedDataIPSubnetMask(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, ipSubnetMask BACnetApplicationTagOctetString, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataIPSubnetMask {
	if ipSubnetMask == nil {
		panic("ipSubnetMask of type BACnetApplicationTagOctetString for BACnetConstructedDataIPSubnetMask must not be nil")
	}
	_result := &_BACnetConstructedDataIPSubnetMask{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		IpSubnetMask:                  ipSubnetMask,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataIPSubnetMaskBuilder is a builder for BACnetConstructedDataIPSubnetMask
type BACnetConstructedDataIPSubnetMaskBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(ipSubnetMask BACnetApplicationTagOctetString) BACnetConstructedDataIPSubnetMaskBuilder
	// WithIpSubnetMask adds IpSubnetMask (property field)
	WithIpSubnetMask(BACnetApplicationTagOctetString) BACnetConstructedDataIPSubnetMaskBuilder
	// WithIpSubnetMaskBuilder adds IpSubnetMask (property field) which is build by the builder
	WithIpSubnetMaskBuilder(func(BACnetApplicationTagOctetStringBuilder) BACnetApplicationTagOctetStringBuilder) BACnetConstructedDataIPSubnetMaskBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataIPSubnetMask or returns an error if something is wrong
	Build() (BACnetConstructedDataIPSubnetMask, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataIPSubnetMask
}

// NewBACnetConstructedDataIPSubnetMaskBuilder() creates a BACnetConstructedDataIPSubnetMaskBuilder
func NewBACnetConstructedDataIPSubnetMaskBuilder() BACnetConstructedDataIPSubnetMaskBuilder {
	return &_BACnetConstructedDataIPSubnetMaskBuilder{_BACnetConstructedDataIPSubnetMask: new(_BACnetConstructedDataIPSubnetMask)}
}

type _BACnetConstructedDataIPSubnetMaskBuilder struct {
	*_BACnetConstructedDataIPSubnetMask

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataIPSubnetMaskBuilder) = (*_BACnetConstructedDataIPSubnetMaskBuilder)(nil)

func (b *_BACnetConstructedDataIPSubnetMaskBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataIPSubnetMask
}

func (b *_BACnetConstructedDataIPSubnetMaskBuilder) WithMandatoryFields(ipSubnetMask BACnetApplicationTagOctetString) BACnetConstructedDataIPSubnetMaskBuilder {
	return b.WithIpSubnetMask(ipSubnetMask)
}

func (b *_BACnetConstructedDataIPSubnetMaskBuilder) WithIpSubnetMask(ipSubnetMask BACnetApplicationTagOctetString) BACnetConstructedDataIPSubnetMaskBuilder {
	b.IpSubnetMask = ipSubnetMask
	return b
}

func (b *_BACnetConstructedDataIPSubnetMaskBuilder) WithIpSubnetMaskBuilder(builderSupplier func(BACnetApplicationTagOctetStringBuilder) BACnetApplicationTagOctetStringBuilder) BACnetConstructedDataIPSubnetMaskBuilder {
	builder := builderSupplier(b.IpSubnetMask.CreateBACnetApplicationTagOctetStringBuilder())
	var err error
	b.IpSubnetMask, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagOctetStringBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataIPSubnetMaskBuilder) Build() (BACnetConstructedDataIPSubnetMask, error) {
	if b.IpSubnetMask == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'ipSubnetMask' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataIPSubnetMask.deepCopy(), nil
}

func (b *_BACnetConstructedDataIPSubnetMaskBuilder) MustBuild() BACnetConstructedDataIPSubnetMask {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataIPSubnetMaskBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataIPSubnetMaskBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataIPSubnetMaskBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataIPSubnetMaskBuilder().(*_BACnetConstructedDataIPSubnetMaskBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataIPSubnetMaskBuilder creates a BACnetConstructedDataIPSubnetMaskBuilder
func (b *_BACnetConstructedDataIPSubnetMask) CreateBACnetConstructedDataIPSubnetMaskBuilder() BACnetConstructedDataIPSubnetMaskBuilder {
	if b == nil {
		return NewBACnetConstructedDataIPSubnetMaskBuilder()
	}
	return &_BACnetConstructedDataIPSubnetMaskBuilder{_BACnetConstructedDataIPSubnetMask: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataIPSubnetMask) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataIPSubnetMask) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_IP_SUBNET_MASK
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataIPSubnetMask) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataIPSubnetMask) GetIpSubnetMask() BACnetApplicationTagOctetString {
	return m.IpSubnetMask
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataIPSubnetMask) GetActualValue() BACnetApplicationTagOctetString {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagOctetString(m.GetIpSubnetMask())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataIPSubnetMask(structType any) BACnetConstructedDataIPSubnetMask {
	if casted, ok := structType.(BACnetConstructedDataIPSubnetMask); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataIPSubnetMask); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataIPSubnetMask) GetTypeName() string {
	return "BACnetConstructedDataIPSubnetMask"
}

func (m *_BACnetConstructedDataIPSubnetMask) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (ipSubnetMask)
	lengthInBits += m.IpSubnetMask.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataIPSubnetMask) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataIPSubnetMask) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataIPSubnetMask BACnetConstructedDataIPSubnetMask, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataIPSubnetMask"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataIPSubnetMask")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	ipSubnetMask, err := ReadSimpleField[BACnetApplicationTagOctetString](ctx, "ipSubnetMask", ReadComplex[BACnetApplicationTagOctetString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagOctetString](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'ipSubnetMask' field"))
	}
	m.IpSubnetMask = ipSubnetMask

	actualValue, err := ReadVirtualField[BACnetApplicationTagOctetString](ctx, "actualValue", (*BACnetApplicationTagOctetString)(nil), ipSubnetMask)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataIPSubnetMask"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataIPSubnetMask")
	}

	return m, nil
}

func (m *_BACnetConstructedDataIPSubnetMask) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataIPSubnetMask) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataIPSubnetMask"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataIPSubnetMask")
		}

		if err := WriteSimpleField[BACnetApplicationTagOctetString](ctx, "ipSubnetMask", m.GetIpSubnetMask(), WriteComplex[BACnetApplicationTagOctetString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'ipSubnetMask' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataIPSubnetMask"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataIPSubnetMask")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataIPSubnetMask) IsBACnetConstructedDataIPSubnetMask() {}

func (m *_BACnetConstructedDataIPSubnetMask) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataIPSubnetMask) deepCopy() *_BACnetConstructedDataIPSubnetMask {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataIPSubnetMaskCopy := &_BACnetConstructedDataIPSubnetMask{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagOctetString](m.IpSubnetMask),
	}
	_BACnetConstructedDataIPSubnetMaskCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataIPSubnetMaskCopy
}

func (m *_BACnetConstructedDataIPSubnetMask) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
