/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataFailedAttemptsTime is the corresponding interface of BACnetConstructedDataFailedAttemptsTime
type BACnetConstructedDataFailedAttemptsTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetFailedAttemptsTime returns FailedAttemptsTime (property field)
	GetFailedAttemptsTime() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataFailedAttemptsTime is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataFailedAttemptsTime()
	// CreateBuilder creates a BACnetConstructedDataFailedAttemptsTimeBuilder
	CreateBACnetConstructedDataFailedAttemptsTimeBuilder() BACnetConstructedDataFailedAttemptsTimeBuilder
}

// _BACnetConstructedDataFailedAttemptsTime is the data-structure of this message
type _BACnetConstructedDataFailedAttemptsTime struct {
	BACnetConstructedDataContract
	FailedAttemptsTime BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataFailedAttemptsTime = (*_BACnetConstructedDataFailedAttemptsTime)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataFailedAttemptsTime)(nil)

// NewBACnetConstructedDataFailedAttemptsTime factory function for _BACnetConstructedDataFailedAttemptsTime
func NewBACnetConstructedDataFailedAttemptsTime(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, failedAttemptsTime BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataFailedAttemptsTime {
	if failedAttemptsTime == nil {
		panic("failedAttemptsTime of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataFailedAttemptsTime must not be nil")
	}
	_result := &_BACnetConstructedDataFailedAttemptsTime{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		FailedAttemptsTime:            failedAttemptsTime,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataFailedAttemptsTimeBuilder is a builder for BACnetConstructedDataFailedAttemptsTime
type BACnetConstructedDataFailedAttemptsTimeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(failedAttemptsTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataFailedAttemptsTimeBuilder
	// WithFailedAttemptsTime adds FailedAttemptsTime (property field)
	WithFailedAttemptsTime(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataFailedAttemptsTimeBuilder
	// WithFailedAttemptsTimeBuilder adds FailedAttemptsTime (property field) which is build by the builder
	WithFailedAttemptsTimeBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataFailedAttemptsTimeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataFailedAttemptsTime or returns an error if something is wrong
	Build() (BACnetConstructedDataFailedAttemptsTime, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataFailedAttemptsTime
}

// NewBACnetConstructedDataFailedAttemptsTimeBuilder() creates a BACnetConstructedDataFailedAttemptsTimeBuilder
func NewBACnetConstructedDataFailedAttemptsTimeBuilder() BACnetConstructedDataFailedAttemptsTimeBuilder {
	return &_BACnetConstructedDataFailedAttemptsTimeBuilder{_BACnetConstructedDataFailedAttemptsTime: new(_BACnetConstructedDataFailedAttemptsTime)}
}

type _BACnetConstructedDataFailedAttemptsTimeBuilder struct {
	*_BACnetConstructedDataFailedAttemptsTime

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataFailedAttemptsTimeBuilder) = (*_BACnetConstructedDataFailedAttemptsTimeBuilder)(nil)

func (b *_BACnetConstructedDataFailedAttemptsTimeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataFailedAttemptsTime
}

func (b *_BACnetConstructedDataFailedAttemptsTimeBuilder) WithMandatoryFields(failedAttemptsTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataFailedAttemptsTimeBuilder {
	return b.WithFailedAttemptsTime(failedAttemptsTime)
}

func (b *_BACnetConstructedDataFailedAttemptsTimeBuilder) WithFailedAttemptsTime(failedAttemptsTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataFailedAttemptsTimeBuilder {
	b.FailedAttemptsTime = failedAttemptsTime
	return b
}

func (b *_BACnetConstructedDataFailedAttemptsTimeBuilder) WithFailedAttemptsTimeBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataFailedAttemptsTimeBuilder {
	builder := builderSupplier(b.FailedAttemptsTime.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.FailedAttemptsTime, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataFailedAttemptsTimeBuilder) Build() (BACnetConstructedDataFailedAttemptsTime, error) {
	if b.FailedAttemptsTime == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'failedAttemptsTime' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataFailedAttemptsTime.deepCopy(), nil
}

func (b *_BACnetConstructedDataFailedAttemptsTimeBuilder) MustBuild() BACnetConstructedDataFailedAttemptsTime {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataFailedAttemptsTimeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataFailedAttemptsTimeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataFailedAttemptsTimeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataFailedAttemptsTimeBuilder().(*_BACnetConstructedDataFailedAttemptsTimeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataFailedAttemptsTimeBuilder creates a BACnetConstructedDataFailedAttemptsTimeBuilder
func (b *_BACnetConstructedDataFailedAttemptsTime) CreateBACnetConstructedDataFailedAttemptsTimeBuilder() BACnetConstructedDataFailedAttemptsTimeBuilder {
	if b == nil {
		return NewBACnetConstructedDataFailedAttemptsTimeBuilder()
	}
	return &_BACnetConstructedDataFailedAttemptsTimeBuilder{_BACnetConstructedDataFailedAttemptsTime: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataFailedAttemptsTime) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataFailedAttemptsTime) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_FAILED_ATTEMPTS_TIME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataFailedAttemptsTime) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataFailedAttemptsTime) GetFailedAttemptsTime() BACnetApplicationTagUnsignedInteger {
	return m.FailedAttemptsTime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataFailedAttemptsTime) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetFailedAttemptsTime())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataFailedAttemptsTime(structType any) BACnetConstructedDataFailedAttemptsTime {
	if casted, ok := structType.(BACnetConstructedDataFailedAttemptsTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataFailedAttemptsTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataFailedAttemptsTime) GetTypeName() string {
	return "BACnetConstructedDataFailedAttemptsTime"
}

func (m *_BACnetConstructedDataFailedAttemptsTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (failedAttemptsTime)
	lengthInBits += m.FailedAttemptsTime.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataFailedAttemptsTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataFailedAttemptsTime) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataFailedAttemptsTime BACnetConstructedDataFailedAttemptsTime, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataFailedAttemptsTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataFailedAttemptsTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	failedAttemptsTime, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "failedAttemptsTime", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'failedAttemptsTime' field"))
	}
	m.FailedAttemptsTime = failedAttemptsTime

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), failedAttemptsTime)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataFailedAttemptsTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataFailedAttemptsTime")
	}

	return m, nil
}

func (m *_BACnetConstructedDataFailedAttemptsTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataFailedAttemptsTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataFailedAttemptsTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataFailedAttemptsTime")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "failedAttemptsTime", m.GetFailedAttemptsTime(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'failedAttemptsTime' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataFailedAttemptsTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataFailedAttemptsTime")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataFailedAttemptsTime) IsBACnetConstructedDataFailedAttemptsTime() {}

func (m *_BACnetConstructedDataFailedAttemptsTime) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataFailedAttemptsTime) deepCopy() *_BACnetConstructedDataFailedAttemptsTime {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataFailedAttemptsTimeCopy := &_BACnetConstructedDataFailedAttemptsTime{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.FailedAttemptsTime),
	}
	_BACnetConstructedDataFailedAttemptsTimeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataFailedAttemptsTimeCopy
}

func (m *_BACnetConstructedDataFailedAttemptsTime) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
