/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataDoorPulseTime is the corresponding interface of BACnetConstructedDataDoorPulseTime
type BACnetConstructedDataDoorPulseTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetDoorPulseTime returns DoorPulseTime (property field)
	GetDoorPulseTime() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataDoorPulseTime is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataDoorPulseTime()
	// CreateBuilder creates a BACnetConstructedDataDoorPulseTimeBuilder
	CreateBACnetConstructedDataDoorPulseTimeBuilder() BACnetConstructedDataDoorPulseTimeBuilder
}

// _BACnetConstructedDataDoorPulseTime is the data-structure of this message
type _BACnetConstructedDataDoorPulseTime struct {
	BACnetConstructedDataContract
	DoorPulseTime BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataDoorPulseTime = (*_BACnetConstructedDataDoorPulseTime)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataDoorPulseTime)(nil)

// NewBACnetConstructedDataDoorPulseTime factory function for _BACnetConstructedDataDoorPulseTime
func NewBACnetConstructedDataDoorPulseTime(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, doorPulseTime BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataDoorPulseTime {
	if doorPulseTime == nil {
		panic("doorPulseTime of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataDoorPulseTime must not be nil")
	}
	_result := &_BACnetConstructedDataDoorPulseTime{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		DoorPulseTime:                 doorPulseTime,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataDoorPulseTimeBuilder is a builder for BACnetConstructedDataDoorPulseTime
type BACnetConstructedDataDoorPulseTimeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(doorPulseTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDoorPulseTimeBuilder
	// WithDoorPulseTime adds DoorPulseTime (property field)
	WithDoorPulseTime(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDoorPulseTimeBuilder
	// WithDoorPulseTimeBuilder adds DoorPulseTime (property field) which is build by the builder
	WithDoorPulseTimeBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataDoorPulseTimeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataDoorPulseTime or returns an error if something is wrong
	Build() (BACnetConstructedDataDoorPulseTime, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataDoorPulseTime
}

// NewBACnetConstructedDataDoorPulseTimeBuilder() creates a BACnetConstructedDataDoorPulseTimeBuilder
func NewBACnetConstructedDataDoorPulseTimeBuilder() BACnetConstructedDataDoorPulseTimeBuilder {
	return &_BACnetConstructedDataDoorPulseTimeBuilder{_BACnetConstructedDataDoorPulseTime: new(_BACnetConstructedDataDoorPulseTime)}
}

type _BACnetConstructedDataDoorPulseTimeBuilder struct {
	*_BACnetConstructedDataDoorPulseTime

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataDoorPulseTimeBuilder) = (*_BACnetConstructedDataDoorPulseTimeBuilder)(nil)

func (b *_BACnetConstructedDataDoorPulseTimeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataDoorPulseTime
}

func (b *_BACnetConstructedDataDoorPulseTimeBuilder) WithMandatoryFields(doorPulseTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDoorPulseTimeBuilder {
	return b.WithDoorPulseTime(doorPulseTime)
}

func (b *_BACnetConstructedDataDoorPulseTimeBuilder) WithDoorPulseTime(doorPulseTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDoorPulseTimeBuilder {
	b.DoorPulseTime = doorPulseTime
	return b
}

func (b *_BACnetConstructedDataDoorPulseTimeBuilder) WithDoorPulseTimeBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataDoorPulseTimeBuilder {
	builder := builderSupplier(b.DoorPulseTime.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.DoorPulseTime, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataDoorPulseTimeBuilder) Build() (BACnetConstructedDataDoorPulseTime, error) {
	if b.DoorPulseTime == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'doorPulseTime' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataDoorPulseTime.deepCopy(), nil
}

func (b *_BACnetConstructedDataDoorPulseTimeBuilder) MustBuild() BACnetConstructedDataDoorPulseTime {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataDoorPulseTimeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataDoorPulseTimeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataDoorPulseTimeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataDoorPulseTimeBuilder().(*_BACnetConstructedDataDoorPulseTimeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataDoorPulseTimeBuilder creates a BACnetConstructedDataDoorPulseTimeBuilder
func (b *_BACnetConstructedDataDoorPulseTime) CreateBACnetConstructedDataDoorPulseTimeBuilder() BACnetConstructedDataDoorPulseTimeBuilder {
	if b == nil {
		return NewBACnetConstructedDataDoorPulseTimeBuilder()
	}
	return &_BACnetConstructedDataDoorPulseTimeBuilder{_BACnetConstructedDataDoorPulseTime: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataDoorPulseTime) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataDoorPulseTime) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_DOOR_PULSE_TIME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataDoorPulseTime) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataDoorPulseTime) GetDoorPulseTime() BACnetApplicationTagUnsignedInteger {
	return m.DoorPulseTime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataDoorPulseTime) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetDoorPulseTime())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataDoorPulseTime(structType any) BACnetConstructedDataDoorPulseTime {
	if casted, ok := structType.(BACnetConstructedDataDoorPulseTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataDoorPulseTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataDoorPulseTime) GetTypeName() string {
	return "BACnetConstructedDataDoorPulseTime"
}

func (m *_BACnetConstructedDataDoorPulseTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (doorPulseTime)
	lengthInBits += m.DoorPulseTime.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataDoorPulseTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataDoorPulseTime) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataDoorPulseTime BACnetConstructedDataDoorPulseTime, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataDoorPulseTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataDoorPulseTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	doorPulseTime, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "doorPulseTime", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'doorPulseTime' field"))
	}
	m.DoorPulseTime = doorPulseTime

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), doorPulseTime)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataDoorPulseTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataDoorPulseTime")
	}

	return m, nil
}

func (m *_BACnetConstructedDataDoorPulseTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataDoorPulseTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataDoorPulseTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataDoorPulseTime")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "doorPulseTime", m.GetDoorPulseTime(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'doorPulseTime' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataDoorPulseTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataDoorPulseTime")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataDoorPulseTime) IsBACnetConstructedDataDoorPulseTime() {}

func (m *_BACnetConstructedDataDoorPulseTime) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataDoorPulseTime) deepCopy() *_BACnetConstructedDataDoorPulseTime {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataDoorPulseTimeCopy := &_BACnetConstructedDataDoorPulseTime{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.DoorPulseTime),
	}
	_BACnetConstructedDataDoorPulseTimeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataDoorPulseTimeCopy
}

func (m *_BACnetConstructedDataDoorPulseTime) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
