/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.flagbitspane;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.debugger.flagbitspane.Flag;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;

public class FontFlag
extends Flag {
    private final COSDictionary fontDescriptor;

    FontFlag(COSDictionary fontDescDictionary) {
        this.fontDescriptor = fontDescDictionary;
    }

    @Override
    String getFlagType() {
        return "Font flag";
    }

    @Override
    String getFlagValue() {
        return "Flag value:" + this.fontDescriptor.getInt(COSName.FLAGS);
    }

    @Override
    Object[][] getFlagBits() {
        PDFontDescriptor fontDesc = new PDFontDescriptor(this.fontDescriptor);
        return new Object[][]{{1, "FixedPitch", fontDesc.isFixedPitch()}, {2, "Serif", fontDesc.isSerif()}, {3, "Symbolic", fontDesc.isSymbolic()}, {4, "Script", fontDesc.isScript()}, {6, "NonSymbolic", fontDesc.isNonSymbolic()}, {7, "Italic", fontDesc.isItalic()}, {17, "AllCap", fontDesc.isAllCap()}, {18, "SmallCap", fontDesc.isSmallCap()}, {19, "ForceBold", fontDesc.isForceBold()}};
    }
}

