/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.scanner;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.webbeans.corespi.scanner.AbstractMetaDataDiscovery;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.xbean.finder.AnnotationFinder;

public class WebScannerService
extends AbstractMetaDataDiscovery {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(WebScannerService.class);
    protected ServletContext servletContext = null;

    /*
     * Exception decompiling
     */
    protected AnnotationFinder initFinder() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void init(Object context) {
        super.init(context);
        this.servletContext = (ServletContext)context;
    }

    protected void configure() {
    }

    private Set<String> getArchives() throws Exception {
        Set<String> lists = this.createURLFromMarkerFile();
        String warUrlPath = this.createURLFromWARFile();
        if (warUrlPath != null) {
            lists.add(warUrlPath);
        }
        return lists;
    }

    protected Set<String> createURLFromMarkerFile() throws Exception {
        HashSet<String> listURL = new HashSet<String>();
        String[] urls = this.findBeansXmlBases("META-INF/beans.xml", WebBeansUtil.getCurrentClassLoader());
        if (urls != null) {
            for (String url : urls) {
                String addPath;
                String fileDir = new URL(url).getFile();
                if (fileDir.endsWith(".jar!/")) {
                    if (!(fileDir = fileDir.substring(0, fileDir.lastIndexOf("/") + 1) + "META-INF/beans.xml").startsWith("file:/")) {
                        fileDir = "file:/" + fileDir;
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "OpenWebBeans found the following url while doing web scanning: " + fileDir);
                    }
                    addPath = "jar:" + fileDir;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "OpenWebBeans added the following jar based path while doing web scanning: " + addPath);
                    }
                } else {
                    addPath = !url.startsWith("file:/") && !url.contains("://") ? "file:/" + url : url;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "OpenWebBeans added the following file based path while doing web scanning: " + addPath);
                    }
                }
                listURL.add(addPath);
            }
        }
        return listURL;
    }

    protected String createURLFromWARFile() throws Exception {
        if (this.servletContext == null) {
            return null;
        }
        URL url = this.servletContext.getResource("/WEB-INF/beans.xml");
        if (url != null) {
            File fp;
            this.addWebBeansXmlLocation(url);
            URL resourceUrl = null;
            String path = this.servletContext.getRealPath("/WEB-INF/classes");
            if (path != null && (fp = new File(path)).exists()) {
                resourceUrl = fp.toURI().toURL();
            }
            if (resourceUrl == null) {
                return null;
            }
            return resourceUrl.toExternalForm();
        }
        return null;
    }
}

