/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bval.jsr.groups.GroupConversion;
import org.apache.bval.jsr.metadata.ContainerElementKey;
import org.apache.bval.jsr.metadata.HasAnnotationBehavior;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.jsr.metadata.Signature;

public final class MetadataBuilder {
    private MetadataBuilder() {
    }

    public static interface ForExecutable<E extends Executable>
    extends HasAnnotationBehavior {
        public ForContainer<E> getReturnValue(Meta<E> var1);

        public ForElement<E> getCrossParameter(Meta<E> var1);

        public List<ForContainer<Parameter>> getParameters(Meta<E> var1);
    }

    public static interface ForContainer<E extends AnnotatedElement>
    extends ForElement<E> {
        public boolean isCascade(Meta<E> var1);

        public Set<GroupConversion> getGroupConversions(Meta<E> var1);

        public Map<ContainerElementKey, ForContainer<AnnotatedType>> getContainerElementTypes(Meta<E> var1);
    }

    public static interface ForClass<T>
    extends ForElement<Class<T>> {
        public List<Class<?>> getGroupSequence(Meta<Class<T>> var1);
    }

    public static interface ForElement<E extends AnnotatedElement>
    extends HasAnnotationBehavior {
        public Annotation[] getDeclaredConstraints(Meta<E> var1);

        default public Map<Meta<E>, Annotation[]> getConstraintDeclarationMap(Meta<E> meta) {
            return Collections.singletonMap(meta, this.getDeclaredConstraints(meta));
        }
    }

    public static interface ForBean<T>
    extends HasAnnotationBehavior {
        public ForClass<T> getClass(Meta<Class<T>> var1);

        public Map<String, ForContainer<Field>> getFields(Meta<Class<T>> var1);

        public Map<String, ForContainer<Method>> getGetters(Meta<Class<T>> var1);

        public Map<Signature, ForExecutable<Constructor<? extends T>>> getConstructors(Meta<Class<T>> var1);

        public Map<Signature, ForExecutable<Method>> getMethods(Meta<Class<T>> var1);

        default public boolean isEmpty() {
            return false;
        }
    }
}

