/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.ClassStrategy;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.DiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.FieldStrategy;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.Strategy;
import org.apache.openjpa.jdbc.meta.StrategyInstaller;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.meta.VersionStrategy;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.MetaDataException;

public class RefreshStrategyInstaller
extends StrategyInstaller {
    private static final long serialVersionUID = 1L;
    private static final Localizer _loc = Localizer.forPackage(RefreshStrategyInstaller.class);

    public RefreshStrategyInstaller(MappingRepository repos) {
        super(repos);
    }

    @Override
    public boolean isAdapting() {
        return true;
    }

    @Override
    public void installStrategy(ClassMapping cls) {
        ClassStrategy strat = this.repos.namedStrategy(cls);
        if (strat == null) {
            strat = this.repos.defaultStrategy(cls, true);
        }
        try {
            cls.setStrategy(strat, Boolean.TRUE);
        }
        catch (MetaDataException mde) {
            if (RefreshStrategyInstaller.isCustomStrategy(strat)) {
                throw mde;
            }
            this.repos.getLog().warn(_loc.get("fatal-change", cls, mde.getMessage()));
            cls.clearMapping();
            cls.setStrategy(this.repos.defaultStrategy(cls, true), Boolean.TRUE);
        }
        cls.setSourceMode(2, true);
    }

    @Override
    public void installStrategy(FieldMapping field) {
        FieldStrategy strategy = this.repos.namedStrategy(field, true);
        if (strategy == null) {
            strategy = this.repos.defaultStrategy(field, true, true);
        }
        try {
            field.setStrategy(strategy, Boolean.TRUE);
        }
        catch (MetaDataException mde) {
            if (RefreshStrategyInstaller.isCustomStrategy(strategy)) {
                throw mde;
            }
            this.repos.getLog().warn(_loc.get("fatal-change", field, mde.getMessage()));
            field.clearMapping();
            field.setHandler(null);
            field.getKeyMapping().setHandler(null);
            field.getElementMapping().setHandler(null);
            field.setStrategy(this.repos.defaultStrategy(field, true, true), Boolean.TRUE);
        }
    }

    @Override
    public void installStrategy(Version version) {
        VersionStrategy strat = this.repos.namedStrategy(version);
        if (strat == null) {
            strat = this.repos.defaultStrategy(version, true);
        }
        try {
            version.setStrategy(strat, Boolean.TRUE);
        }
        catch (MetaDataException mde) {
            if (RefreshStrategyInstaller.isCustomStrategy(strat)) {
                throw mde;
            }
            this.repos.getLog().warn(_loc.get("fatal-change", version, mde.getMessage()));
            version.clearMapping();
            version.setStrategy(this.repos.defaultStrategy(version, true), Boolean.TRUE);
        }
    }

    @Override
    public void installStrategy(Discriminator discrim) {
        DiscriminatorStrategy strat = this.repos.namedStrategy(discrim);
        if (strat == null) {
            strat = this.repos.defaultStrategy(discrim, true);
        }
        try {
            discrim.setStrategy(strat, Boolean.TRUE);
        }
        catch (MetaDataException mde) {
            if (RefreshStrategyInstaller.isCustomStrategy(strat)) {
                throw mde;
            }
            this.repos.getLog().warn(_loc.get("fatal-change", discrim, mde.getMessage()));
            String val = discrim.getMappingInfo().getValue();
            discrim.clearMapping();
            discrim.getMappingInfo().setValue(val);
            discrim.setStrategy(this.repos.defaultStrategy(discrim, true), Boolean.TRUE);
        }
    }

    private static boolean isCustomStrategy(Strategy strat) {
        return !strat.getClass().getName().startsWith("org.apache.openjpa.");
    }
}

