/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser;

import java.util.Collection;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.uri.queryoption.AliasQueryOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.core.uri.parser.ExpressionParser;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriTokenizer;
import org.apache.olingo.server.core.uri.queryoption.FilterOptionImpl;
import org.apache.olingo.server.core.uri.validator.UriValidationException;

public class FilterParser {
    private final Edm edm;
    private final OData odata;

    public FilterParser(Edm edm, OData odata) {
        this.edm = edm;
        this.odata = odata;
    }

    public FilterOption parse(UriTokenizer tokenizer, EdmType referencedType, Collection<String> crossjoinEntitySetNames, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        Expression filterExpression = new ExpressionParser(this.edm, this.odata).parse(tokenizer, referencedType, crossjoinEntitySetNames, aliases);
        EdmType type = ExpressionParser.getType(filterExpression);
        if (type == null || type.equals(this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Boolean))) {
            return new FilterOptionImpl().setExpression(filterExpression);
        }
        throw new UriParserSemanticException("Filter expressions must be boolean.", UriParserSemanticException.MessageKeys.TYPES_NOT_COMPATIBLE, "Edm.Boolean", type.getFullQualifiedName().getFullQualifiedNameAsString());
    }
}

