/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Constructor;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.util.Preconditions;

public class ClassBasedNavigableListAssert<SELF extends ClassBasedNavigableListAssert<SELF, ACTUAL, ELEMENT, ELEMENT_ASSERT>, ACTUAL extends List<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>>
extends AbstractListAssert<SELF, ACTUAL, ELEMENT, ELEMENT_ASSERT> {
    private Class<ELEMENT_ASSERT> assertClass;

    public static <ELEMENT, ACTUAL extends List<? extends ELEMENT>, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> ClassBasedNavigableListAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(List<? extends ELEMENT> actual, Class<ELEMENT_ASSERT> assertClass) {
        return new ClassBasedNavigableListAssert(actual, assertClass);
    }

    public ClassBasedNavigableListAssert(ACTUAL actual, Class<ELEMENT_ASSERT> assertClass) {
        super(actual, ClassBasedNavigableListAssert.class);
        this.assertClass = assertClass;
    }

    @Override
    public ELEMENT_ASSERT toAssert(ELEMENT value, String description) {
        return this.buildAssert(value, description, value.getClass());
    }

    private <V> ELEMENT_ASSERT buildAssert(V value, String description, Class<?> clazz) {
        try {
            Constructor<?>[] declaredConstructors;
            for (Constructor<?> constructor : declaredConstructors = this.assertClass.getDeclaredConstructors()) {
                if (constructor.getParameterCount() != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(clazz)) continue;
                AbstractAssert newAssert = (AbstractAssert)constructor.newInstance(value);
                return (ELEMENT_ASSERT)((AbstractAssert)newAssert.as(description, new Object[0]));
            }
            throw new RuntimeException("Failed to find a constructor matching " + value + " class to build the expected Assert class");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build an assert object with " + value + ": " + e.getMessage(), e);
        }
    }

    @Override
    protected SELF newAbstractIterableAssert(Iterable<? extends ELEMENT> iterable) {
        Preconditions.checkArgument(iterable instanceof List, "Expecting %s to be a List", iterable);
        return (SELF)new ClassBasedNavigableListAssert<SELF, List, ELEMENT, ELEMENT_ASSERT>((List)iterable, this.assertClass);
    }
}

