/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.CheckedArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.resources.Errors;

final class MultiValuedAttribute<V>
extends AbstractAttribute<V>
implements Cloneable {
    private static final long serialVersionUID = -7824265855672575215L;
    private CheckedArrayList<V> values;

    public MultiValuedAttribute(DefaultAttributeType<V> defaultAttributeType) {
        super(defaultAttributeType);
        this.values = new CheckedArrayList<V>(defaultAttributeType.getValueClass());
        V v = defaultAttributeType.getDefaultValue();
        if (v != null) {
            this.values.add(v);
        }
    }

    MultiValuedAttribute(DefaultAttributeType<V> defaultAttributeType, Object object) {
        super(defaultAttributeType);
        Class<V> clazz = defaultAttributeType.getValueClass();
        if (object == null) {
            this.values = new CheckedArrayList<V>(clazz);
        } else {
            Class clazz2 = ((CheckedContainer)object).getElementType();
            if (clazz2 == clazz) {
                this.values = (CheckedArrayList)object;
            } else {
                throw new ClassCastException(Errors.format((short)43, "values", clazz, clazz2));
            }
        }
    }

    @Override
    public V getValue() {
        switch (this.values.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (V)this.values.get(0);
            }
        }
        throw new IllegalStateException(Resources.format((short)53, this.getName()));
    }

    @Override
    public Collection<V> getValues() {
        return this.values;
    }

    @Override
    public void setValue(V v) {
        this.values.clear();
        if (v != null) {
            this.values.add(v);
        }
    }

    @Override
    public void setValues(Collection<? extends V> collection) {
        if (collection != this.values) {
            ArgumentChecks.ensureNonNull("values", collection);
            this.values.clear();
            this.values.addAll(collection);
        }
    }

    @Override
    public AbstractAttribute<V> clone() throws CloneNotSupportedException {
        MultiValuedAttribute multiValuedAttribute = (MultiValuedAttribute)super.clone();
        multiValuedAttribute.values = (CheckedArrayList)multiValuedAttribute.values.clone();
        return multiValuedAttribute;
    }

    public int hashCode() {
        return this.type.hashCode() + this.values.hashCode() + this.characteristicsReadOnly().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MultiValuedAttribute) {
            MultiValuedAttribute multiValuedAttribute = (MultiValuedAttribute)object;
            return this.type.equals(multiValuedAttribute.type) && this.values.equals(multiValuedAttribute.values) && this.characteristicsReadOnly().equals(multiValuedAttribute.characteristicsReadOnly());
        }
        return false;
    }
}

