/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import ucar.ma2.Index;

public class Index2D
extends Index {
    private int curr0;
    private int curr1;
    private int stride0;
    private int stride1;
    private int shape0;
    private int shape1;

    Index2D() {
        super(2);
    }

    public Index2D(int[] shape) {
        super(shape);
        this.precalc();
    }

    @Override
    protected void precalc() {
        this.shape0 = this.shape[0];
        this.shape1 = this.shape[1];
        this.stride0 = this.stride[0];
        this.stride1 = this.stride[1];
        this.curr0 = this.current[0];
        this.curr1 = this.current[1];
    }

    @Override
    public int[] getCurrentCounter() {
        this.current[0] = this.curr0;
        this.current[1] = this.curr1;
        return (int[])this.current.clone();
    }

    @Override
    public String toString() {
        return this.curr0 + "," + this.curr1;
    }

    @Override
    public int currentElement() {
        return this.offset + this.curr0 * this.stride0 + this.curr1 * this.stride1;
    }

    @Override
    public int incr() {
        if (++this.curr1 >= this.shape1) {
            this.curr1 = 0;
            if (++this.curr0 >= this.shape0) {
                this.curr0 = 0;
            }
        }
        return this.offset + this.curr0 * this.stride0 + this.curr1 * this.stride1;
    }

    @Override
    public void setDim(int dim, int value) {
        if (value < 0 || value >= this.shape[dim]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (dim == 1) {
            this.curr1 = value;
        } else {
            this.curr0 = value;
        }
    }

    @Override
    public Index set(int[] index) {
        if (index.length != this.rank) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.set0(index[0]);
        this.set1(index[1]);
        return this;
    }

    @Override
    public Index set0(int v) {
        if (v < 0 || v >= this.shape0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.curr0 = v;
        return this;
    }

    @Override
    public Index set1(int v) {
        if (v < 0 || v >= this.shape1) {
            throw new ArrayIndexOutOfBoundsException("index=" + v + " shape=" + this.shape1);
        }
        this.curr1 = v;
        return this;
    }

    @Override
    public Index set(int v0, int v1) {
        this.set0(v0);
        this.set1(v1);
        return this;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    int setDirect(int v0, int v1) {
        if (v0 < 0 || v0 >= this.shape0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (v1 < 0 || v1 >= this.shape1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.offset + v0 * this.stride0 + v1 * this.stride1;
    }
}

