/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.system;

import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectionManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectorManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectorPoolFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorityGroupManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationDomainManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectionManager;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectorManager;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityGroupManager;
import org.apache.manifoldcf.authorities.interfaces.IAuthorizationDomainManager;
import org.apache.manifoldcf.authorities.interfaces.IMappingConnectionManager;
import org.apache.manifoldcf.authorities.interfaces.IMappingConnectorManager;
import org.apache.manifoldcf.authorities.interfaces.MappingConnectionManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.MappingConnectorManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.MappingConnectorPoolFactory;
import org.apache.manifoldcf.authorities.system.AuthCheckThread;
import org.apache.manifoldcf.authorities.system.AuthRequest;
import org.apache.manifoldcf.authorities.system.IdleCleanupThread;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.authorities.system.MappingRequest;
import org.apache.manifoldcf.authorities.system.MappingThread;
import org.apache.manifoldcf.authorities.system.RequestQueue;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class ManifoldCF
extends org.apache.manifoldcf.core.system.ManifoldCF {
    protected static boolean authoritiesInitialized = false;
    protected static IdleCleanupThread idleCleanupThread = null;
    protected static AuthCheckThread[] authCheckThreads = null;
    protected static MappingThread[] mappingThreads = null;
    protected static int numAuthCheckThreads = 0;
    protected static int numMappingThreads = 0;
    protected static final String authCheckThreadCountProperty = "org.apache.manifoldcf.authorityservice.threads";
    protected static final String mappingThreadCountProperty = "org.apache.manifoldcf.authorityservice.mappingthreads";
    protected static RequestQueue<AuthRequest> requestQueue = null;
    protected static RequestQueue<MappingRequest> mappingRequestQueue = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeEnvironment(IThreadContext tc) throws ManifoldCFException {
        Integer n = initializeFlagLock;
        synchronized (n) {
            org.apache.manifoldcf.core.system.ManifoldCF.initializeEnvironment((IThreadContext)tc);
            ManifoldCF.localInitialize(tc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpEnvironment(IThreadContext tc) {
        Integer n = initializeFlagLock;
        synchronized (n) {
            ManifoldCF.localCleanup(tc);
            org.apache.manifoldcf.core.system.ManifoldCF.cleanUpEnvironment((IThreadContext)tc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void localInitialize(IThreadContext tc) throws ManifoldCFException {
        Integer n = initializeFlagLock;
        synchronized (n) {
            if (authoritiesInitialized) {
                return;
            }
            Logging.initializeLoggers();
            Logging.setLogLevels((IThreadContext)tc);
            authoritiesInitialized = true;
        }
    }

    public static void localCleanup(IThreadContext tc) {
        block5: {
            block4: {
                try {
                    AuthorityConnectorPoolFactory.make(tc).closeAllConnectors();
                }
                catch (ManifoldCFException e) {
                    if (Logging.authorityService == null) break block4;
                    Logging.authorityService.warn((Object)("Exception closing authority connection pool: " + e.getMessage()), (Throwable)e);
                }
            }
            try {
                MappingConnectorPoolFactory.make(tc).closeAllConnectors();
            }
            catch (ManifoldCFException e) {
                if (Logging.authorityService == null) break block5;
                Logging.authorityService.warn((Object)("Exception closing mapping connection pool: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static void installSystemTables(IThreadContext threadcontext) throws ManifoldCFException {
        IAuthorizationDomainManager domainMgr = AuthorizationDomainManagerFactory.make(threadcontext);
        IAuthorityGroupManager groupMgr = AuthorityGroupManagerFactory.make(threadcontext);
        IAuthorityConnectorManager connMgr = AuthorityConnectorManagerFactory.make(threadcontext);
        IAuthorityConnectionManager authConnMgr = AuthorityConnectionManagerFactory.make(threadcontext);
        IMappingConnectorManager mappingConnectorMgr = MappingConnectorManagerFactory.make(threadcontext);
        IMappingConnectionManager mappingConnectionMgr = MappingConnectionManagerFactory.make(threadcontext);
        domainMgr.install();
        connMgr.install();
        mappingConnectorMgr.install();
        groupMgr.install();
        authConnMgr.install();
        mappingConnectionMgr.install();
    }

    public static void deinstallSystemTables(IThreadContext threadcontext) throws ManifoldCFException {
        IAuthorizationDomainManager domainMgr = AuthorizationDomainManagerFactory.make(threadcontext);
        IAuthorityConnectorManager connMgr = AuthorityConnectorManagerFactory.make(threadcontext);
        IAuthorityGroupManager groupMgr = AuthorityGroupManagerFactory.make(threadcontext);
        IAuthorityConnectionManager authConnMgr = AuthorityConnectionManagerFactory.make(threadcontext);
        IMappingConnectorManager mappingConnectorMgr = MappingConnectorManagerFactory.make(threadcontext);
        IMappingConnectionManager mappingConnectionMgr = MappingConnectionManagerFactory.make(threadcontext);
        mappingConnectionMgr.deinstall();
        authConnMgr.deinstall();
        groupMgr.deinstall();
        mappingConnectorMgr.deinstall();
        connMgr.deinstall();
        domainMgr.deinstall();
    }

    public static void startSystem(IThreadContext threadContext) throws ManifoldCFException {
        int i;
        numAuthCheckThreads = LockManagerFactory.getIntProperty((IThreadContext)threadContext, (String)authCheckThreadCountProperty, (int)10);
        if (numAuthCheckThreads < 1 || numAuthCheckThreads > 100) {
            throw new ManifoldCFException("Illegal value for the number of auth check threads");
        }
        numMappingThreads = LockManagerFactory.getIntProperty((IThreadContext)threadContext, (String)mappingThreadCountProperty, (int)10);
        if (numMappingThreads < 1 || numMappingThreads > 100) {
            throw new ManifoldCFException("Illegal value for the number of mapping threads");
        }
        idleCleanupThread = new IdleCleanupThread();
        idleCleanupThread.start();
        requestQueue = new RequestQueue();
        mappingRequestQueue = new RequestQueue();
        authCheckThreads = new AuthCheckThread[numAuthCheckThreads];
        for (i = 0; i < numAuthCheckThreads; ++i) {
            ManifoldCF.authCheckThreads[i] = new AuthCheckThread(Integer.toString(i), requestQueue);
            authCheckThreads[i].start();
        }
        mappingThreads = new MappingThread[numMappingThreads];
        for (i = 0; i < numMappingThreads; ++i) {
            ManifoldCF.mappingThreads[i] = new MappingThread(Integer.toString(i), mappingRequestQueue);
            mappingThreads[i].start();
        }
    }

    public static void stopSystem(IThreadContext threadContext) throws ManifoldCFException {
        while (idleCleanupThread != null || authCheckThreads != null || mappingThreads != null) {
            boolean isAlive;
            int i;
            if (idleCleanupThread != null) {
                idleCleanupThread.interrupt();
            }
            if (authCheckThreads != null) {
                for (i = 0; i < authCheckThreads.length; ++i) {
                    AuthCheckThread authCheckThread = authCheckThreads[i];
                    if (authCheckThread == null) continue;
                    authCheckThread.interrupt();
                }
            }
            if (mappingThreads != null) {
                for (i = 0; i < mappingThreads.length; ++i) {
                    MappingThread mappingThread = mappingThreads[i];
                    if (mappingThread == null) continue;
                    mappingThread.interrupt();
                }
            }
            if (idleCleanupThread != null && !idleCleanupThread.isAlive()) {
                idleCleanupThread = null;
            }
            if (authCheckThreads != null) {
                isAlive = false;
                for (int i2 = 0; i2 < authCheckThreads.length; ++i2) {
                    AuthCheckThread authCheckThread = authCheckThreads[i2];
                    if (authCheckThread != null) {
                        if (!authCheckThread.isAlive()) {
                            ManifoldCF.authCheckThreads[i2] = null;
                        } else {
                            isAlive = true;
                        }
                    }
                    ++i2;
                }
                if (!isAlive) {
                    authCheckThreads = null;
                }
            }
            if (mappingThreads != null) {
                isAlive = false;
                for (int i3 = 0; i3 < mappingThreads.length; ++i3) {
                    MappingThread mappingThread = mappingThreads[i3];
                    if (mappingThread != null) {
                        if (!mappingThread.isAlive()) {
                            ManifoldCF.mappingThreads[i3] = null;
                        } else {
                            isAlive = true;
                        }
                    }
                    ++i3;
                }
                if (!isAlive) {
                    mappingThreads = null;
                }
            }
            try {
                ManifoldCF.sleep((long)1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        AuthorityConnectorPoolFactory.make(threadContext).flushUnusedConnectors();
        numAuthCheckThreads = 0;
        requestQueue = null;
        MappingConnectorPoolFactory.make(threadContext).flushUnusedConnectors();
        numMappingThreads = 0;
        mappingRequestQueue = null;
    }

    public static RequestQueue<AuthRequest> getRequestQueue() {
        return requestQueue;
    }

    public static RequestQueue<MappingRequest> getMappingRequestQueue() {
        return mappingRequestQueue;
    }
}

