/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockIdManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Private
public class CorruptReplicasMap {
    private final Map<Block, Map<DatanodeDescriptor, Reason>> corruptReplicasMap = new HashMap<Block, Map<DatanodeDescriptor, Reason>>();
    private final LongAdder totalCorruptBlocks = new LongAdder();
    private final LongAdder totalCorruptECBlockGroups = new LongAdder();

    void addToCorruptReplicasMap(Block blk, DatanodeDescriptor dn, String reason, Reason reasonCode, boolean isStriped) {
        Map<DatanodeDescriptor, Reason> nodes = this.corruptReplicasMap.get(blk);
        if (nodes == null) {
            nodes = new HashMap<DatanodeDescriptor, Reason>();
            this.corruptReplicasMap.put(blk, nodes);
            this.incrementBlockStat(isStriped);
        }
        String reasonText = reason != null ? " because " + reason : "";
        if (!nodes.keySet().contains((Object)dn)) {
            NameNode.blockStateChangeLog.debug("BLOCK NameSystem.addToCorruptReplicasMap: {} added as corrupt on {} by {} {}", new Object[]{blk, dn, Server.getRemoteIp(), reasonText});
        } else {
            NameNode.blockStateChangeLog.debug("BLOCK NameSystem.addToCorruptReplicasMap: duplicate requested for {} to add as corrupt on {} by {} {}", new Object[]{blk, dn, Server.getRemoteIp(), reasonText});
        }
        nodes.put(dn, reasonCode);
    }

    void removeFromCorruptReplicasMap(BlockInfo blk) {
        Map<DatanodeDescriptor, Reason> value;
        if (this.corruptReplicasMap != null && (value = this.corruptReplicasMap.remove((Object)blk)) != null) {
            this.decrementBlockStat(blk.isStriped());
        }
    }

    boolean removeFromCorruptReplicasMap(BlockInfo blk, DatanodeDescriptor datanode) {
        return this.removeFromCorruptReplicasMap(blk, datanode, Reason.ANY);
    }

    boolean removeFromCorruptReplicasMap(BlockInfo blk, DatanodeDescriptor datanode, Reason reason) {
        Map<DatanodeDescriptor, Reason> datanodes = this.corruptReplicasMap.get((Object)blk);
        if (datanodes == null) {
            return false;
        }
        Reason storedReason = datanodes.get((Object)datanode);
        if (reason != Reason.ANY && storedReason != null && reason != storedReason) {
            return false;
        }
        if (datanodes.remove((Object)datanode) != null) {
            if (datanodes.isEmpty()) {
                this.corruptReplicasMap.remove((Object)blk);
                this.decrementBlockStat(blk.isStriped());
            }
            return true;
        }
        return false;
    }

    private void incrementBlockStat(boolean isStriped) {
        if (isStriped) {
            this.totalCorruptECBlockGroups.increment();
        } else {
            this.totalCorruptBlocks.increment();
        }
    }

    private void decrementBlockStat(boolean isStriped) {
        if (isStriped) {
            this.totalCorruptECBlockGroups.decrement();
        } else {
            this.totalCorruptBlocks.decrement();
        }
    }

    Collection<DatanodeDescriptor> getNodes(Block blk) {
        Map<DatanodeDescriptor, Reason> nodes = this.corruptReplicasMap.get(blk);
        if (nodes == null) {
            return null;
        }
        return nodes.keySet();
    }

    boolean isReplicaCorrupt(Block blk, DatanodeDescriptor node) {
        Collection<DatanodeDescriptor> nodes = this.getNodes(blk);
        return nodes != null && nodes.contains((Object)node);
    }

    int numCorruptReplicas(Block blk) {
        Collection<DatanodeDescriptor> nodes = this.getNodes(blk);
        return nodes == null ? 0 : nodes.size();
    }

    int size() {
        return this.corruptReplicasMap.size();
    }

    @VisibleForTesting
    long[] getCorruptBlockIdsForTesting(BlockIdManager bim, BlockType blockType, int numExpectedBlocks, Long startingBlockId) {
        if (numExpectedBlocks < 0 || numExpectedBlocks > 100) {
            return null;
        }
        long cursorBlockId = startingBlockId != null ? startingBlockId : Long.MIN_VALUE;
        return this.corruptReplicasMap.keySet().stream().filter(r -> {
            if (blockType == BlockType.STRIPED) {
                return bim.isStripedBlock((Block)r) && r.getBlockId() >= cursorBlockId;
            }
            return !bim.isStripedBlock((Block)r) && r.getBlockId() >= cursorBlockId;
        }).sorted().limit(numExpectedBlocks).mapToLong(Block::getBlockId).toArray();
    }

    Set<Block> getCorruptBlocksSet() {
        HashSet<Block> corruptBlocks = new HashSet<Block>();
        corruptBlocks.addAll(this.corruptReplicasMap.keySet());
        return corruptBlocks;
    }

    String getCorruptReason(Block block, DatanodeDescriptor node) {
        Enum reason = null;
        if (this.corruptReplicasMap.containsKey(block) && this.corruptReplicasMap.get(block).containsKey((Object)node)) {
            reason = this.corruptReplicasMap.get(block).get((Object)node);
        }
        if (reason != null) {
            return reason.toString();
        }
        return null;
    }

    long getCorruptBlocks() {
        return this.totalCorruptBlocks.longValue();
    }

    long getCorruptECBlockGroups() {
        return this.totalCorruptECBlockGroups.longValue();
    }

    public static enum Reason {
        NONE,
        ANY,
        GENSTAMP_MISMATCH,
        SIZE_MISMATCH,
        INVALID_STATE,
        CORRUPTION_REPORTED;

    }
}

