/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.soap.MTOM;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisExtensionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.PolicyServicePort;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.webservices.AbstractService;

@MTOM
@WebService(endpointInterface="org.apache.chemistry.opencmis.commons.impl.jaxb.PolicyServicePort")
public class PolicyService
extends AbstractService
implements PolicyServicePort {
    @Resource
    public WebServiceContext wsContext;

    public void applyPolicy(String repositoryId, String policyId, String objectId, Holder<CmisExtensionType> extension) throws CmisException {
        ExtensionsData extData;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block6;
                this.closeService(service);
                return;
            }
            service.applyPolicy(repositoryId, policyId, objectId, extData);
            if (!this.stopAfterService(service)) break block7;
            this.closeService(service);
            return;
        }
        try {
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public List<CmisObjectType> getAppliedPolicies(String repositoryId, String objectId, String filter, CmisExtensionType extension) throws CmisException {
        ArrayList<CmisObjectType> arrayList;
        List policies;
        CmisVersion cmisVersion;
        CmisService service;
        block10: {
            block9: {
                block8: {
                    service = null;
                    cmisVersion = null;
                    service = this.getService(this.wsContext, repositoryId);
                    cmisVersion = this.getCmisVersion(this.wsContext);
                    if (!this.stopBeforeService(service)) break block8;
                    List<CmisObjectType> list = null;
                    this.closeService(service);
                    return list;
                }
                policies = service.getAppliedPolicies(repositoryId, objectId, filter, WSConverter.convert((CmisExtensionType)extension));
                if (!this.stopAfterService(service)) break block9;
                List<CmisObjectType> list = null;
                this.closeService(service);
                return list;
            }
            if (policies != null) break block10;
            List<CmisObjectType> list = null;
            this.closeService(service);
            return list;
        }
        try {
            ArrayList<CmisObjectType> result = new ArrayList<CmisObjectType>();
            for (ObjectData object : policies) {
                result.add(WSConverter.convert((ObjectData)object, (CmisVersion)cmisVersion));
            }
            arrayList = result;
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return arrayList;
    }

    public void removePolicy(String repositoryId, String policyId, String objectId, Holder<CmisExtensionType> extension) throws CmisException {
        ExtensionsData extData;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block6;
                this.closeService(service);
                return;
            }
            service.removePolicy(repositoryId, policyId, objectId, extData);
            if (!this.stopAfterService(service)) break block7;
            this.closeService(service);
            return;
        }
        try {
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }
}

