/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.clients.consumer.internals.AbstractFetch;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.FetchConfig;
import org.apache.kafka.clients.consumer.internals.FetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.kafka.clients.consumer.internals.RequestFutureListener;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.slf4j.Logger;

public class Fetcher<K, V>
extends AbstractFetch<K, V> {
    private final Logger log;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    public Fetcher(LogContext logContext, ConsumerNetworkClient client, ConsumerMetadata metadata, SubscriptionState subscriptions, FetchConfig<K, V> fetchConfig, FetchMetricsManager metricsManager, Time time) {
        super(logContext, client, metadata, subscriptions, fetchConfig, metricsManager, time);
        this.log = logContext.logger(Fetcher.class);
    }

    public synchronized int sendFetches() {
        Map<Node, FetchSessionHandler.FetchRequestData> fetchRequestMap = this.prepareFetchRequests();
        for (Map.Entry<Node, FetchSessionHandler.FetchRequestData> entry : fetchRequestMap.entrySet()) {
            final Node fetchTarget = entry.getKey();
            final FetchSessionHandler.FetchRequestData data = entry.getValue();
            FetchRequest.Builder request = this.createFetchRequest(fetchTarget, data);
            RequestFutureListener<ClientResponse> listener = new RequestFutureListener<ClientResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSuccess(ClientResponse resp) {
                    Fetcher fetcher = Fetcher.this;
                    synchronized (fetcher) {
                        Fetcher.this.handleFetchResponse(fetchTarget, data, resp);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(RuntimeException e) {
                    Fetcher fetcher = Fetcher.this;
                    synchronized (fetcher) {
                        Fetcher.this.handleFetchResponse(fetchTarget, e);
                    }
                }
            };
            RequestFuture<ClientResponse> future = this.client.send(fetchTarget, request);
            future.addListener(listener);
        }
        return fetchRequestMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Timer timer) {
        if (!this.isClosed.compareAndSet(false, true)) {
            this.log.info("Fetcher {} is already closed.", (Object)this);
            return;
        }
        Fetcher fetcher = this;
        synchronized (fetcher) {
            super.close(timer);
        }
    }
}

