/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SaslPropertiesResolver;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.util.CombinedIPWhiteList;
import org.apache.hadoop.util.StringUtils;

public class WhitelistBasedResolver
extends SaslPropertiesResolver {
    public static final Log LOG = LogFactory.getLog(WhitelistBasedResolver.class);
    private static final String FIXEDWHITELIST_DEFAULT_LOCATION = "/etc/hadoop/fixedwhitelist";
    private static final String VARIABLEWHITELIST_DEFAULT_LOCATION = "/etc/hadoop/whitelist";
    public static final String HADOOP_SECURITY_SASL_FIXEDWHITELIST_FILE = "hadoop.security.sasl.fixedwhitelist.file";
    public static final String HADOOP_SECURITY_SASL_VARIABLEWHITELIST_ENABLE = "hadoop.security.sasl.variablewhitelist.enable";
    public static final String HADOOP_SECURITY_SASL_VARIABLEWHITELIST_FILE = "hadoop.security.sasl.variablewhitelist.file";
    public static final String HADOOP_SECURITY_SASL_VARIABLEWHITELIST_CACHE_SECS = "hadoop.security.sasl.variablewhitelist.cache.secs";
    public static final String HADOOP_RPC_PROTECTION_NON_WHITELIST = "hadoop.rpc.protection.non-whitelist";
    private CombinedIPWhiteList whiteList;
    private Map<String, String> saslProps;

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        String fixedFile = conf.get(HADOOP_SECURITY_SASL_FIXEDWHITELIST_FILE, FIXEDWHITELIST_DEFAULT_LOCATION);
        String variableFile = null;
        long expiryTime = 0L;
        if (conf.getBoolean(HADOOP_SECURITY_SASL_VARIABLEWHITELIST_ENABLE, false)) {
            variableFile = conf.get(HADOOP_SECURITY_SASL_VARIABLEWHITELIST_FILE, VARIABLEWHITELIST_DEFAULT_LOCATION);
            expiryTime = conf.getLong(HADOOP_SECURITY_SASL_VARIABLEWHITELIST_CACHE_SECS, 3600L) * 1000L;
        }
        this.whiteList = new CombinedIPWhiteList(fixedFile, variableFile, expiryTime);
        this.saslProps = WhitelistBasedResolver.getSaslProperties(conf);
    }

    @Override
    public Map<String, String> getServerProperties(InetAddress clientAddress) {
        if (clientAddress == null) {
            return this.saslProps;
        }
        return this.whiteList.isIn(clientAddress.getHostAddress()) ? this.getDefaultProperties() : this.saslProps;
    }

    public Map<String, String> getServerProperties(String clientAddress) throws UnknownHostException {
        if (clientAddress == null) {
            return this.saslProps;
        }
        return this.getServerProperties(InetAddress.getByName(clientAddress));
    }

    static Map<String, String> getSaslProperties(Configuration conf) {
        TreeMap<String, String> saslProps = new TreeMap<String, String>();
        String[] qop = conf.getStrings(HADOOP_RPC_PROTECTION_NON_WHITELIST, SaslRpcServer.QualityOfProtection.PRIVACY.toString());
        for (int i = 0; i < qop.length; ++i) {
            qop[i] = SaslRpcServer.QualityOfProtection.valueOf(qop[i].toUpperCase()).getSaslQop();
        }
        saslProps.put("javax.security.sasl.qop", StringUtils.join((CharSequence)",", qop));
        saslProps.put("javax.security.sasl.server.authentication", "true");
        return saslProps;
    }
}

