/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.rarfile;

import com.github.junrar.io.Raw;
import com.github.junrar.rarfile.BlockHeader;

public class ProtectHeader
extends BlockHeader {
    public static final int protectHeaderSize = 8;
    private byte version;
    private final short recSectors;
    private final int totalBlocks;
    private byte mark;

    public ProtectHeader(BlockHeader bh, byte[] protectHeader) {
        super(bh);
        int pos = 0;
        this.version = (byte)(this.version | protectHeader[pos] & 0xFF);
        this.recSectors = Raw.readShortLittleEndian(protectHeader, pos);
        this.totalBlocks = Raw.readIntLittleEndian(protectHeader, pos += 2);
        this.mark = (byte)(this.mark | protectHeader[pos += 4] & 0xFF);
    }

    public byte getMark() {
        return this.mark;
    }

    public short getRecSectors() {
        return this.recSectors;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public byte getVersion() {
        return this.version;
    }
}

