/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.amazons3;

import com.amazonaws.services.s3.model.CanonicalGrantee;
import com.amazonaws.services.s3.model.Grant;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.amazons3.S3Artifact;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.tika.metadata.Metadata;

public class AmazonS3DocumentProcessUtility {
    protected String[] getUsers(Set<Grant> grants) {
        HashSet<String> users = new HashSet<String>();
        for (Grant grant : grants) {
            if (grant == null || grant.getGrantee() == null) continue;
            Grantee grantee = grant.getGrantee();
            if (grantee instanceof CanonicalGrantee) {
                users.add(((CanonicalGrantee)grantee).getDisplayName());
                continue;
            }
            users.add(grantee.getIdentifier());
        }
        return users.toArray(new String[users.size()]);
    }

    protected String getDocumentURI(S3Artifact s3Artifact) {
        return String.format(Locale.ROOT, "%s.s3.amazonaws.com/%s", s3Artifact.getBucketName(), s3Artifact.getKey());
    }

    protected void addAllMetaData(RepositoryDocument rd, Metadata metadata2) throws ManifoldCFException {
        for (String field : metadata2.names()) {
            rd.addField(field, metadata2.get(field));
        }
    }

    protected S3Artifact getS3Artifact(String documentIdentifier) throws ManifoldCFException {
        String bucketName = documentIdentifier.split(",")[0];
        String key = documentIdentifier.split(",")[1];
        if (StringUtils.isEmpty((String)bucketName) || StringUtils.isEmpty((String)key)) {
            throw new ManifoldCFException("bucket or key name is empty");
        }
        return new S3Artifact(bucketName, key);
    }

    protected void addRawMetadata(RepositoryDocument rd, ObjectMetadata objectMetadata) {
        Map rawMetadata = objectMetadata.getRawMetadata();
        for (Map.Entry entry : rawMetadata.entrySet()) {
            try {
                String value = entry.getValue().toString();
                String key = (String)entry.getKey();
                rd.addField(key, value);
            }
            catch (ManifoldCFException e) {
                Logging.connectors.error((Object)"Error while adding metadata", (Throwable)e);
            }
        }
    }
}

