/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.alfresco;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.webservice.authentication.AuthenticationFault;
import org.alfresco.webservice.content.Content;
import org.alfresco.webservice.repository.QueryResult;
import org.alfresco.webservice.types.NamedValue;
import org.alfresco.webservice.types.Node;
import org.alfresco.webservice.types.Predicate;
import org.alfresco.webservice.types.Reference;
import org.alfresco.webservice.types.ResultSet;
import org.alfresco.webservice.types.ResultSetRow;
import org.alfresco.webservice.util.AuthenticationDetails;
import org.alfresco.webservice.util.AuthenticationUtils;
import org.alfresco.webservice.util.WebServiceException;
import org.alfresco.webservice.util.WebServiceFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.alfresco.ContentModelUtils;
import org.apache.manifoldcf.crawler.connectors.alfresco.ContentReader;
import org.apache.manifoldcf.crawler.connectors.alfresco.Messages;
import org.apache.manifoldcf.crawler.connectors.alfresco.NodeUtils;
import org.apache.manifoldcf.crawler.connectors.alfresco.PropertiesUtils;
import org.apache.manifoldcf.crawler.connectors.alfresco.SearchUtils;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;

public class AlfrescoRepositoryConnector
extends BaseRepositoryConnector {
    public static final String ACTIVITY_FETCH = "fetch";
    protected String username = null;
    protected String password = null;
    protected String protocol = null;
    protected String server = null;
    protected String port = null;
    protected String path = null;
    protected String endpoint = null;
    protected String tenantDomain = null;
    protected int socketTimeout = -1;
    protected AuthenticationDetails session = null;
    protected static final long timeToRelease = 300000L;
    protected long lastSessionFetch = -1L;
    protected static final String RELATIONSHIP_CHILD = "child";
    private static final String TAB_NAME_PARAM = "TabName";
    private static final String SEQ_NUM_PARAM = "SeqNum";
    private static final String SELECTED_NUM_PARAM = "SelectedNum";
    private static final String TAB_LABEL_LUCENE_QUERY_RESOURCE = "AlfrescoConnector.LuceneQuery";
    private static final String ALFRESCO_SERVER_TAB_RESOURCE = "AlfrescoConnector.Server";
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration.js";
    private static final String EDIT_CONFIG_FORWARD_SERVER = "editConfiguration_Server.html";
    private static final String EDIT_SPEC_HEADER_FORWARD = "editSpecification.js";
    private static final String EDIT_SPEC_FORWARD_LUCENEQUERY = "editSpecification_LuceneQuery.html";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration.html";
    private static final String VIEW_SPEC_FORWARD = "viewSpecification.html";
    private static final String JOB_STARTPOINT_NODE_TYPE = "startpoint";
    protected static final String ACTIVITY_READ = "read document";
    private static final String INGESTION_SEPARATOR_FOR_MULTI_BINARY = ";";

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_FETCH};
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.server};
    }

    public void disconnect() throws ManifoldCFException {
        if (this.session != null) {
            try {
                AuthenticationUtils.endSession();
            }
            catch (Exception e) {
                Logging.connectors.error((Object)("Alfresco: error disconnect:" + e.getMessage()), (Throwable)e);
                throw new ManifoldCFException("Alfresco: error disconnect:" + e.getMessage(), (Throwable)e);
            }
            this.session = null;
            this.lastSessionFetch = -1L;
        }
        this.username = null;
        this.password = null;
        this.protocol = null;
        this.server = null;
        this.port = null;
        this.path = null;
        this.endpoint = null;
        this.tenantDomain = null;
        this.socketTimeout = 120000;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.username = this.params.getParameter("username");
        this.password = this.params.getParameter("password");
        this.protocol = this.params.getParameter("protocol");
        this.server = this.params.getParameter("server");
        this.port = this.params.getParameter("port");
        this.path = this.params.getParameter("path");
        this.tenantDomain = this.params.getParameter("tenantDomain");
        this.socketTimeout = this.params.getParameter("socketTimeout") != null ? Integer.parseInt(this.params.getParameter("socketTimeout")) : 120000;
        if (StringUtils.isNotEmpty((String)this.protocol) && StringUtils.isNotEmpty((String)this.server) && StringUtils.isNotEmpty((String)this.port) && StringUtils.isNotEmpty((String)this.path)) {
            this.endpoint = this.protocol + "://" + this.server + ":" + this.port + this.path;
        }
        if (StringUtils.isNotEmpty((String)this.tenantDomain)) {
            this.username = this.username + "@" + this.tenantDomain;
        }
    }

    public String check() throws ManifoldCFException {
        try {
            this.checkConnection();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        if (this.session == null) {
            if (StringUtils.isEmpty((String)this.username)) {
                throw new ManifoldCFException("Parameter username required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Alfresco: Username = '" + this.username + "'"));
            }
            if (StringUtils.isEmpty((String)this.password)) {
                throw new ManifoldCFException("Parameter password required but not set");
            }
            Logging.connectors.debug((Object)"Alfresco: Password exists");
            if (StringUtils.isEmpty((String)this.protocol)) {
                throw new ManifoldCFException("Parameter protocol required but not set");
            }
            if (StringUtils.isEmpty((String)this.server)) {
                throw new ManifoldCFException("Parameter server required but not set");
            }
            if (StringUtils.isEmpty((String)this.port)) {
                throw new ManifoldCFException("Parameter port required but not set");
            }
            if (StringUtils.isEmpty((String)this.path)) {
                throw new ManifoldCFException("Parameter path required but not set");
            }
            this.endpoint = this.protocol + "://" + this.server + ":" + this.port + this.path;
            try {
                WebServiceFactory.setEndpointAddress((String)this.endpoint);
                WebServiceFactory.setTimeoutMilliseconds((int)this.socketTimeout);
                AuthenticationUtils.startSession((String)this.username, (String)this.password);
                this.session = AuthenticationUtils.getAuthenticationDetails();
            }
            catch (AuthenticationFault e) {
                Logging.connectors.warn((Object)("Alfresco: Error during authentication. Username: " + this.username + ", endpoint: " + this.endpoint + ". " + e.getMessage()), (Throwable)e);
                AlfrescoRepositoryConnector.handleIOException((IOException)((Object)e));
            }
            catch (WebServiceException e) {
                Logging.connectors.warn((Object)("Alfresco: Error during trying to authenticate the user. Username: " + this.username + ", endpoint: " + this.endpoint + ". Please check the connector parameters. " + e.getMessage()), (Throwable)e);
                throw new ManifoldCFException("Alfresco: Error during trying to authenticate the user. Username: " + this.username + ", endpoint: " + this.endpoint + ". Please check the connector parameters. " + e.getMessage(), (Throwable)e);
            }
            this.lastSessionFetch = System.currentTimeMillis();
        }
    }

    protected void releaseCheck() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            try {
                AuthenticationUtils.endSession();
            }
            catch (Exception e) {
                Logging.connectors.error((Object)"Alfresco: Error during releasing the connection.");
                throw new ManifoldCFException("Alfresco: Error during releasing the connection.");
            }
            this.session = null;
            this.lastSessionFetch = -1L;
        }
    }

    protected void checkConnection() throws ManifoldCFException, ServiceInterruption {
        try {
            this.getSession();
            String ticket = AuthenticationUtils.getTicket();
            if (StringUtils.isEmpty((String)ticket)) {
                Logging.connectors.error((Object)"Alfresco: Error during checking the connection.");
                throw new ManifoldCFException("Alfresco: Error during checking the connection.");
            }
            AuthenticationUtils.endSession();
        }
        catch (Exception e) {
            Logging.connectors.error((Object)"Alfresco: Error during checking the connection.");
            throw new ManifoldCFException("Alfresco: Error during checking the connection.");
        }
        this.session = null;
    }

    public void poll() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            try {
                AuthenticationUtils.endSession();
                this.session = null;
                this.lastSessionFetch = -1L;
            }
            catch (Exception e) {
                Logging.connectors.error((Object)("Alfresco: Error during polling: " + e.getMessage()), (Throwable)e);
                throw new ManifoldCFException("Alfresco: Error during polling: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        String luceneQuery = "";
        for (int i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (!sn.getType().equals(JOB_STARTPOINT_NODE_TYPE)) continue;
            luceneQuery = sn.getAttributeValue("luceneQuery");
            break;
        }
        try {
            QueryResult queryResult = null;
            queryResult = StringUtils.isEmpty((String)luceneQuery) ? SearchUtils.getChildrenFromCompanyHome(this.endpoint, this.username, this.password, this.socketTimeout, this.session) : SearchUtils.luceneSearch(this.endpoint, this.username, this.password, this.socketTimeout, this.session, luceneQuery);
            if (queryResult != null) {
                ResultSetRow[] resultSetRows;
                ResultSet resultSet = queryResult.getResultSet();
                for (ResultSetRow resultSetRow : resultSetRows = resultSet.getRows()) {
                    NamedValue[] properties = resultSetRow.getColumns();
                    String nodeReference = PropertiesUtils.getNodeReference(properties);
                    activities.addSeedDocument(nodeReference);
                }
            }
        }
        catch (IOException e) {
            Logging.connectors.warn((Object)("Alfresco: IOException: " + e.getMessage()), (Throwable)e);
            AlfrescoRepositoryConnector.handleIOException(e);
        }
        return "";
    }

    public int getMaxDocumentRequest() {
        return 1;
    }

    public String[] getRelationshipTypes() {
        return new String[]{RELATIONSHIP_CHILD};
    }

    private static void outputResource(String resName, IHTTPOutput out, Locale locale, Map<String, String> paramMap) throws ManifoldCFException {
        Messages.outputResourceWithVelocity(out, locale, resName, paramMap, true);
    }

    private static void fillInServerParameters(Map<String, String> paramMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String username = parameters.getParameter("username");
        if (username == null) {
            username = "admin";
        }
        paramMap.put("username", username);
        String password = parameters.getParameter("password");
        password = password == null ? "admin" : mapper.mapPasswordToKey(password);
        paramMap.put("password", password);
        String protocol = parameters.getParameter("protocol");
        if (protocol == null) {
            protocol = "http";
        }
        paramMap.put("protocol", protocol);
        String server = parameters.getParameter("server");
        if (server == null) {
            server = "localhost";
        }
        paramMap.put("server", server);
        String port = parameters.getParameter("port");
        if (port == null) {
            port = "8080";
        }
        paramMap.put("port", port);
        String path = parameters.getParameter("path");
        if (path == null) {
            path = "/alfresco/api";
        }
        paramMap.put("path", path);
        String tenantDomain = parameters.getParameter("tenantDomain");
        if (tenantDomain == null) {
            tenantDomain = "";
        }
        paramMap.put("tenantDomain", tenantDomain);
        String socketTimeout = parameters.getParameter("socketTimeout");
        if (socketTimeout == null) {
            socketTimeout = String.valueOf(120000);
        }
        paramMap.put("socketTimeout", socketTimeout);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        AlfrescoRepositoryConnector.fillInServerParameters(paramMap, (IPasswordMapperActivity)out, parameters);
        AlfrescoRepositoryConnector.outputResource(VIEW_CONFIG_FORWARD, out, locale, paramMap);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, ALFRESCO_SERVER_TAB_RESOURCE));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        AlfrescoRepositoryConnector.fillInServerParameters(paramMap, (IPasswordMapperActivity)out, parameters);
        AlfrescoRepositoryConnector.outputResource(EDIT_CONFIG_HEADER_FORWARD, out, locale, paramMap);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(TAB_NAME_PARAM, tabName);
        AlfrescoRepositoryConnector.fillInServerParameters(paramMap, (IPasswordMapperActivity)out, parameters);
        AlfrescoRepositoryConnector.outputResource(EDIT_CONFIG_FORWARD_SERVER, out, locale, paramMap);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String socketTimeout;
        String tenantDomain;
        String path;
        String port;
        String server;
        String protocol;
        String password;
        String username = variableContext.getParameter("username");
        if (username != null) {
            parameters.setParameter("username", username);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setParameter("password", variableContext.mapKeyToPassword(password));
        }
        if ((protocol = variableContext.getParameter("protocol")) != null) {
            parameters.setParameter("protocol", protocol);
        }
        if ((server = variableContext.getParameter("server")) != null) {
            parameters.setParameter("server", server);
        }
        if ((port = variableContext.getParameter("port")) != null) {
            parameters.setParameter("port", port);
        }
        if ((path = variableContext.getParameter("path")) != null) {
            parameters.setParameter("path", path);
        }
        if ((tenantDomain = variableContext.getParameter("tenantDomain")) != null) {
            parameters.setParameter("tenantDomain", tenantDomain);
        }
        if ((socketTimeout = variableContext.getParameter("socketTimeout")) != null) {
            parameters.setParameter("socketTimeout", socketTimeout);
        }
        return null;
    }

    private static void fillInLuceneQueryParameters(Map<String, String> paramMap, Specification ds) {
        String luceneQuery = "";
        for (int i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (!sn.getType().equals(JOB_STARTPOINT_NODE_TYPE)) continue;
            luceneQuery = sn.getAttributeValue("luceneQuery");
        }
        paramMap.put("luceneQuery", luceneQuery);
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        AlfrescoRepositoryConnector.fillInLuceneQueryParameters(paramMap, ds);
        paramMap.put(SEQ_NUM_PARAM, Integer.toString(connectionSequenceNumber));
        AlfrescoRepositoryConnector.outputResource(VIEW_SPEC_FORWARD, out, locale, paramMap);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String luceneQuery = variableContext.getParameter(seqPrefix + "luceneQuery");
        if (luceneQuery != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode oldNode = ds.getChild(i);
                if (oldNode.getType().equals(JOB_STARTPOINT_NODE_TYPE)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode node = new SpecificationNode(JOB_STARTPOINT_NODE_TYPE);
            node.setAttribute("luceneQuery", luceneQuery);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
        }
        return null;
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(TAB_NAME_PARAM, tabName);
        paramMap.put(SEQ_NUM_PARAM, Integer.toString(connectionSequenceNumber));
        paramMap.put(SELECTED_NUM_PARAM, Integer.toString(actualSequenceNumber));
        AlfrescoRepositoryConnector.fillInLuceneQueryParameters(paramMap, ds);
        AlfrescoRepositoryConnector.outputResource(EDIT_SPEC_FORWARD_LUCENEQUERY, out, locale, paramMap);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, TAB_LABEL_LUCENE_QUERY_RESOURCE));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(SEQ_NUM_PARAM, Integer.toString(connectionSequenceNumber));
        AlfrescoRepositoryConnector.fillInLuceneQueryParameters(paramMap, ds);
        AlfrescoRepositoryConnector.outputResource(EDIT_SPEC_HEADER_FORWARD, out, locale, paramMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        String[] stringArray = documentIdentifiers;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            boolean isVersioned;
            String documentIdentifier;
            String nodeReference = documentIdentifier = stringArray[i];
            String uuid = NodeUtils.getUuidFromNodeReference(nodeReference);
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Alfresco: Processing document identifier '" + nodeReference + "'"));
            }
            Reference reference = new Reference();
            reference.setStore(SearchUtils.STORE);
            reference.setUuid(uuid);
            Predicate predicate = new Predicate();
            predicate.setStore(SearchUtils.STORE);
            predicate.setNodes(new Reference[]{reference});
            Node resultNode = null;
            try {
                resultNode = NodeUtils.get(this.endpoint, this.username, this.password, this.socketTimeout, this.session, predicate);
            }
            catch (IOException e) {
                Logging.connectors.warn((Object)("Alfresco: IOException getting node: " + e.getMessage()), (Throwable)e);
                AlfrescoRepositoryConnector.handleIOException(e);
            }
            NamedValue[] properties = resultNode.getProperties();
            String versionString = "";
            boolean isDocument = properties != null ? ContentModelUtils.isDocument(properties) : false;
            if (isDocument && (isVersioned = NodeUtils.isVersioned(resultNode.getAspects()))) {
                versionString = NodeUtils.getVersionLabel(properties);
            }
            if (versionString.length() != 0 && !activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) continue;
            String errorCode = "OK";
            String errorDesc = "";
            Long fileLengthLong = null;
            long startTime = System.currentTimeMillis();
            try {
                try {
                    boolean isFolder = ContentModelUtils.isFolder(this.endpoint, this.username, this.password, this.socketTimeout, this.session, reference);
                    if (isFolder) {
                        ResultSetRow[] resultSetRows;
                        QueryResult queryResult = SearchUtils.getChildren(this.endpoint, this.username, this.password, this.socketTimeout, this.session, reference);
                        ResultSet resultSet = queryResult.getResultSet();
                        for (ResultSetRow resultSetRow : resultSetRows = resultSet.getRows()) {
                            NamedValue[] childProperties = resultSetRow.getColumns();
                            String childNodeReference = PropertiesUtils.getNodeReference(childProperties);
                            activities.addDocumentReference(childNodeReference, nodeReference, RELATIONSHIP_CHILD);
                        }
                    }
                }
                catch (IOException e) {
                    errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                    errorDesc = e.getMessage();
                    Logging.connectors.warn((Object)("Alfresco: IOException finding children: " + e.getMessage()), (Throwable)e);
                    AlfrescoRepositoryConnector.handleIOException(e);
                }
                if (!isDocument) continue;
                InputStream is = null;
                long fileLength = 0L;
                try {
                    RepositoryDocument rd = new RepositoryDocument();
                    List<NamedValue> contentProperties = PropertiesUtils.getContentProperties(properties);
                    PropertiesUtils.ingestProperties(rd, properties, contentProperties);
                    for (NamedValue contentProperty : contentProperties) {
                        Content binary = ContentReader.read(this.endpoint, this.username, this.password, this.socketTimeout, this.session, predicate, contentProperty.getName());
                        fileLength = binary.getLength();
                        is = ContentReader.getBinary(this.endpoint, binary, this.username, this.password, this.socketTimeout, this.session);
                        rd.setBinary(is, fileLength);
                        Object id = PropertiesUtils.getNodeReference(properties);
                        if (contentProperties.size() > 1) {
                            id = (String)id + INGESTION_SEPARATOR_FOR_MULTI_BINARY + contentProperty.getName();
                        }
                        String documentURI = binary.getUrl();
                        activities.ingestDocumentWithException(documentIdentifier, (String)id, versionString, documentURI, rd);
                        fileLengthLong = new Long(fileLength);
                    }
                    AuthenticationUtils.endSession();
                    continue;
                }
                catch (ParseException e) {
                    errorCode = "PARSEEXCEPTION";
                    errorDesc = e.getMessage();
                    Logging.connectors.warn((Object)("Alfresco: Error during the reading process of dates: " + e.getMessage()), (Throwable)e);
                    this.handleParseException(e);
                    continue;
                }
                catch (IOException e) {
                    errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                    errorDesc = e.getMessage();
                    Logging.connectors.warn((Object)("Alfresco: IOException: " + e.getMessage()), (Throwable)e);
                    AlfrescoRepositoryConnector.handleIOException(e);
                    continue;
                }
                finally {
                    this.session = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (InterruptedIOException e) {
                        errorCode = null;
                        throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
                    }
                    catch (IOException e) {
                        errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                        errorDesc = e.getMessage();
                        Logging.connectors.warn((Object)("Alfresco: IOException closing file input stream: " + e.getMessage()), (Throwable)e);
                        AlfrescoRepositoryConnector.handleIOException(e);
                    }
                }
            }
            catch (ManifoldCFException e) {
                if (e.getErrorCode() == 2) {
                    errorCode = null;
                }
                throw e;
            }
            finally {
                if (errorCode != null) {
                    activities.recordActivity(new Long(startTime), ACTIVITY_READ, fileLengthLong, nodeReference, errorCode, errorDesc, null);
                }
            }
        }
    }

    private static void handleIOException(IOException e) throws ManifoldCFException, ServiceInterruption {
        if (!(e instanceof SocketTimeoutException) && e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        long currentTime = System.currentTimeMillis();
        throw new ServiceInterruption("IO exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
    }

    private void handleParseException(ParseException e) throws ManifoldCFException {
        throw new ManifoldCFException("Alfresco: Error during parsing date values. This should never happen: " + e.getMessage(), (Throwable)e);
    }
}

