/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.confluence.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.manifoldcf.crawler.connectors.confluence.model.ConfluenceResource;
import org.apache.manifoldcf.crawler.connectors.confluence.model.builder.ConfluenceResourceBuilder;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ConfluenceResponse<T extends ConfluenceResource> {
    private List<T> results;
    private int start;
    private int limit;
    private Boolean isLast;

    public ConfluenceResponse(List<T> results, int start, int limit, Boolean isLast) {
        this.results = results;
        this.start = start;
        this.limit = limit;
        this.isLast = isLast;
    }

    public List<T> getResults() {
        return this.results;
    }

    public int getStart() {
        return this.start;
    }

    public int getLimit() {
        return this.limit;
    }

    public Boolean isLast() {
        return this.isLast;
    }

    public static <T extends ConfluenceResource> ConfluenceResponse<T> fromJson(JSONObject response, ConfluenceResourceBuilder<T> builder) {
        ArrayList<T> resources = new ArrayList<T>();
        JSONArray jsonArray = (JSONArray)response.get((Object)"results");
        int size = jsonArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject jsonPage = (JSONObject)jsonArray.get(i);
            T resource = builder.fromJson(jsonPage);
            resources.add(resource);
        }
        int limit = ((Long)response.get((Object)"limit")).intValue();
        int start = ((Long)response.get((Object)"start")).intValue();
        Boolean isLast = false;
        JSONObject links = (JSONObject)response.get((Object)"_links");
        if (links != null) {
            isLast = links.get((Object)"next") == null;
        }
        return new ConfluenceResponse(resources, start, limit, isLast);
    }
}

