/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.OutputStream;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.RenditionInfo;
import org.apache.chemistry.opencmis.server.impl.atompub.AbstractAtomPubServiceCall;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomFeed;

public class NavigationService {

    public static class GetCheckedOutDocs
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String folderId = this.getStringParameter(request, "folderId");
            String filter = this.getStringParameter(request, "filter");
            String orderBy = this.getStringParameter(request, "orderBy");
            Boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
            IncludeRelationships includeRelationships = this.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
            String renditionFilter = this.getStringParameter(request, "renditionFilter");
            BigInteger maxItems = this.getBigIntegerParameter(request, "maxItems");
            BigInteger skipCount = this.getBigIntegerParameter(request, "skipCount");
            if (this.stopBeforeService(service)) {
                return;
            }
            ObjectList checkedOut = service.getCheckedOutDocs(repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (checkedOut == null) {
                throw new CmisRuntimeException("Checked Out list is null!");
            }
            ObjectInfoImpl folderInfo = null;
            if (folderId != null) {
                folderInfo = service.getObjectInfo(repositoryId, folderId);
                if (folderInfo == null) {
                    throw new CmisRuntimeException("Folder Object Info is missing!");
                }
            } else {
                folderInfo = new ObjectInfoImpl();
                GregorianCalendar now = new GregorianCalendar();
                folderInfo.setId("uri:x-checkedout");
                folderInfo.setName("Checked Out");
                folderInfo.setCreatedBy("");
                folderInfo.setCreationDate(now);
                folderInfo.setLastModificationDate(now);
                folderInfo.setHasParent(false);
                folderInfo.setSupportsDescendants(false);
                folderInfo.setSupportsFolderTree(false);
            }
            response.setStatus(200);
            response.setContentType("application/atom+xml;type=feed");
            AtomFeed feed = new AtomFeed();
            feed.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            feed.startFeed(true);
            feed.writeFeedElements(folderInfo.getId(), folderInfo.getAtomId(), folderInfo.getCreatedBy(), folderInfo.getName(), folderInfo.getLastModificationDate(), null, checkedOut.getNumItems());
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            feed.writeServiceLink(baseUrl.toString(), repositoryId);
            UrlBuilder selfLink = this.compileUrlBuilder(baseUrl, "checkedout", folderInfo.getId());
            selfLink.addParameter("filter", (Object)filter);
            selfLink.addParameter("orderBy", (Object)orderBy);
            selfLink.addParameter("includeAllowableActions", (Object)includeAllowableActions);
            selfLink.addParameter("includeRelationships", (Object)includeRelationships);
            selfLink.addParameter("maxItems", (Object)maxItems);
            selfLink.addParameter("skipCount", (Object)skipCount);
            feed.writeSelfLink(selfLink.toString(), null);
            UrlBuilder pagingUrl = this.compileUrlBuilder(baseUrl, "checkedout", folderInfo.getId());
            pagingUrl.addParameter("filter", (Object)filter);
            pagingUrl.addParameter("orderBy", (Object)orderBy);
            pagingUrl.addParameter("includeAllowableActions", (Object)includeAllowableActions);
            pagingUrl.addParameter("includeRelationships", (Object)includeRelationships);
            pagingUrl.addParameter("renditionFilter", (Object)renditionFilter);
            feed.writePagingLinks(pagingUrl, maxItems, skipCount, checkedOut.getNumItems(), checkedOut.hasMoreItems(), PAGE_SIZE);
            if (checkedOut.getObjects() != null) {
                AtomEntry entry = new AtomEntry(feed.getWriter());
                for (ObjectData object : checkedOut.getObjects()) {
                    if (object == null) continue;
                    this.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, false, context.getCmisVersion());
                }
            }
            feed.writeExtensions((ExtensionsData)checkedOut);
            feed.endFeed();
            feed.endDocument();
        }
    }

    public static class GetObjectParents
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = this.getStringParameter(request, "id");
            String filter = this.getStringParameter(request, "filter");
            Boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
            IncludeRelationships includeRelationships = this.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
            String renditionFilter = this.getStringParameter(request, "renditionFilter");
            Boolean includeRelativePathSegment = this.getBooleanParameter(request, "includeRelativePathSegment");
            if (this.stopBeforeService(service)) {
                return;
            }
            List parents = service.getObjectParents(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includeRelativePathSegment, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (parents == null) {
                throw new CmisRuntimeException("Parents are null!");
            }
            ObjectInfo objectInfo = service.getObjectInfo(repositoryId, objectId);
            if (objectInfo == null) {
                throw new CmisRuntimeException("Object Info is missing!");
            }
            response.setStatus(200);
            response.setContentType("application/atom+xml;type=feed");
            AtomFeed feed = new AtomFeed();
            feed.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            feed.startFeed(true);
            feed.writeFeedElements(objectInfo.getId(), objectInfo.getAtomId(), objectInfo.getCreatedBy(), objectInfo.getName(), objectInfo.getLastModificationDate(), null, null);
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            feed.writeServiceLink(baseUrl.toString(), repositoryId);
            UrlBuilder selfLink = this.compileUrlBuilder(baseUrl, "parents", objectInfo.getId());
            selfLink.addParameter("filter", (Object)filter);
            selfLink.addParameter("includeAllowableActions", (Object)includeAllowableActions);
            selfLink.addParameter("includeRelationships", (Object)includeRelationships);
            selfLink.addParameter("renditionFilter", (Object)renditionFilter);
            selfLink.addParameter("includeRelativePathSegment", (Object)includeRelativePathSegment);
            feed.writeSelfLink(selfLink.toString(), null);
            AtomEntry entry = new AtomEntry(feed.getWriter());
            for (ObjectParentData object : parents) {
                if (object == null || object.getObject() == null) continue;
                this.writeObjectEntry(service, entry, object.getObject(), null, repositoryId, null, object.getRelativePathSegment(), baseUrl, false, context.getCmisVersion());
            }
            feed.endFeed();
            feed.endDocument();
        }
    }

    public static class GetFolderParent
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String folderId = this.getStringParameter(request, "id");
            String filter = this.getStringParameter(request, "filter");
            if (this.stopBeforeService(service)) {
                return;
            }
            ObjectData object = service.getFolderParent(repositoryId, folderId, filter, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            ObjectInfo objectInfo = service.getObjectInfo(repositoryId, folderId);
            if (objectInfo == null) {
                throw new CmisRuntimeException("Object Info is missing!");
            }
            response.setStatus(200);
            response.setContentType("application/atom+xml;type=entry");
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            AtomEntry entry = new AtomEntry();
            entry.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            this.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, true, context.getCmisVersion());
            entry.endDocument();
        }
    }

    public static class GetFolderTree
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String folderId = this.getStringParameter(request, "id");
            BigInteger depth = this.getBigIntegerParameter(request, "depth");
            String filter = this.getStringParameter(request, "filter");
            Boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
            IncludeRelationships includeRelationships = this.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
            String renditionFilter = this.getStringParameter(request, "renditionFilter");
            Boolean includePathSegment = this.getBooleanParameter(request, "includePathSegment");
            if (this.stopBeforeService(service)) {
                return;
            }
            List folderTree = service.getFolderTree(repositoryId, folderId, depth, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (folderTree == null) {
                throw new CmisRuntimeException("Folder tree is null!");
            }
            ObjectInfo folderInfo = service.getObjectInfo(repositoryId, folderId);
            if (folderInfo == null) {
                throw new CmisRuntimeException("Folder Object Info is missing!");
            }
            response.setStatus(200);
            response.setContentType("application/atom+xml;type=feed");
            AtomFeed feed = new AtomFeed();
            feed.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            feed.startFeed(true);
            feed.writeFeedElements(folderInfo.getId(), folderInfo.getAtomId(), folderInfo.getCreatedBy(), folderInfo.getName(), folderInfo.getLastModificationDate(), null, null);
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            feed.writeServiceLink(baseUrl.toString(), repositoryId);
            UrlBuilder selfLink = this.compileUrlBuilder(baseUrl, "foldertree", folderInfo.getId());
            selfLink.addParameter("depth", (Object)depth);
            selfLink.addParameter("filter", (Object)filter);
            selfLink.addParameter("includeAllowableActions", (Object)includeAllowableActions);
            selfLink.addParameter("includeRelationships", (Object)includeRelationships);
            selfLink.addParameter("renditionFilter", (Object)renditionFilter);
            selfLink.addParameter("includePathSegment", (Object)includePathSegment);
            feed.writeSelfLink(selfLink.toString(), null);
            feed.writeViaLink(this.compileUrl(baseUrl, "entry", folderInfo.getId()));
            feed.writeDownLink(this.compileUrl(baseUrl, "children", folderInfo.getId()), "application/atom+xml;type=feed");
            if (folderInfo.supportsDescendants()) {
                feed.writeDownLink(this.compileUrl(baseUrl, "descendants", folderInfo.getId()), "application/cmistree+xml");
            }
            if (folderInfo.hasParent()) {
                feed.writeUpLink(this.compileUrl(baseUrl, "parents", folderInfo.getId()), "application/atom+xml;type=feed");
            }
            AtomEntry entry = new AtomEntry(feed.getWriter());
            for (ObjectInFolderContainer container : folderTree) {
                if (container == null || container.getObject() == null || container.getObject().getObject() == null) continue;
                this.writeObjectEntry(service, entry, container.getObject().getObject(), container.getChildren(), repositoryId, container.getObject().getPathSegment(), null, baseUrl, false, context.getCmisVersion());
            }
            feed.endFeed();
            feed.endDocument();
        }
    }

    public static class GetDescendants
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String folderId = this.getStringParameter(request, "id");
            BigInteger depth = this.getBigIntegerParameter(request, "depth");
            String filter = this.getStringParameter(request, "filter");
            Boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
            IncludeRelationships includeRelationships = this.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
            String renditionFilter = this.getStringParameter(request, "renditionFilter");
            Boolean includePathSegment = this.getBooleanParameter(request, "includePathSegment");
            if (this.stopBeforeService(service)) {
                return;
            }
            List descendants = service.getDescendants(repositoryId, folderId, depth, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (descendants == null) {
                throw new CmisRuntimeException("Descendants are null!");
            }
            ObjectInfo folderInfo = service.getObjectInfo(repositoryId, folderId);
            if (folderInfo == null) {
                throw new CmisRuntimeException("Folder Object Info is missing!");
            }
            response.setStatus(200);
            response.setContentType("application/atom+xml;type=feed");
            AtomFeed feed = new AtomFeed();
            feed.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            feed.startFeed(true);
            feed.writeFeedElements(folderInfo.getId(), folderInfo.getAtomId(), folderInfo.getCreatedBy(), folderInfo.getName(), folderInfo.getLastModificationDate(), null, null);
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            feed.writeServiceLink(baseUrl.toString(), repositoryId);
            UrlBuilder selfLink = this.compileUrlBuilder(baseUrl, "descendants", folderInfo.getId());
            selfLink.addParameter("depth", (Object)depth);
            selfLink.addParameter("filter", (Object)filter);
            selfLink.addParameter("includeAllowableActions", (Object)includeAllowableActions);
            selfLink.addParameter("includeRelationships", (Object)includeRelationships);
            selfLink.addParameter("renditionFilter", (Object)renditionFilter);
            selfLink.addParameter("includePathSegment", (Object)includePathSegment);
            feed.writeSelfLink(selfLink.toString(), null);
            feed.writeViaLink(this.compileUrl(baseUrl, "entry", folderInfo.getId()));
            feed.writeDownLink(this.compileUrl(baseUrl, "children", folderInfo.getId()), "application/atom+xml;type=feed");
            if (folderInfo.supportsFolderTree()) {
                feed.writeFolderTreeLink(this.compileUrl(baseUrl, "foldertree", folderInfo.getId()));
            }
            if (folderInfo.hasParent()) {
                feed.writeUpLink(this.compileUrl(baseUrl, "parents", folderInfo.getId()), "application/atom+xml;type=feed");
            }
            AtomEntry entry = new AtomEntry(feed.getWriter());
            for (ObjectInFolderContainer container : descendants) {
                if (container == null || container.getObject() == null || container.getObject().getObject() == null) continue;
                this.writeObjectEntry(service, entry, container.getObject().getObject(), container.getChildren(), repositoryId, container.getObject().getPathSegment(), null, baseUrl, false, context.getCmisVersion());
            }
            feed.endFeed();
            feed.endDocument();
        }
    }

    public static class GetChildren
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String folderId = this.getStringParameter(request, "id");
            String filter = this.getStringParameter(request, "filter");
            String orderBy = this.getStringParameter(request, "orderBy");
            Boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
            IncludeRelationships includeRelationships = this.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
            String renditionFilter = this.getStringParameter(request, "renditionFilter");
            Boolean includePathSegment = this.getBooleanParameter(request, "includePathSegment");
            BigInteger maxItems = this.getBigIntegerParameter(request, "maxItems");
            BigInteger skipCount = this.getBigIntegerParameter(request, "skipCount");
            if (this.stopBeforeService(service)) {
                return;
            }
            ObjectInFolderList children = service.getChildren(repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, maxItems, skipCount, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (children == null) {
                throw new CmisRuntimeException("Children are null!");
            }
            ObjectInfo folderInfo = service.getObjectInfo(repositoryId, folderId);
            if (folderInfo == null) {
                throw new CmisRuntimeException("Folder Object Info is missing!");
            }
            response.setStatus(200);
            response.setContentType("application/atom+xml;type=feed");
            AtomFeed feed = new AtomFeed();
            feed.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            feed.startFeed(true);
            feed.writeFeedElements(folderInfo.getId(), folderInfo.getAtomId(), folderInfo.getCreatedBy(), folderInfo.getName(), folderInfo.getLastModificationDate(), null, children.getNumItems());
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            feed.writeServiceLink(baseUrl.toString(), repositoryId);
            UrlBuilder selfLink = this.compileUrlBuilder(baseUrl, "children", folderInfo.getId());
            selfLink.addParameter("filter", (Object)filter);
            selfLink.addParameter("orderBy", (Object)orderBy);
            selfLink.addParameter("includeAllowableActions", (Object)includeAllowableActions);
            selfLink.addParameter("includeRelationships", (Object)includeRelationships);
            selfLink.addParameter("renditionFilter", (Object)renditionFilter);
            selfLink.addParameter("includePathSegment", (Object)includePathSegment);
            selfLink.addParameter("maxItems", (Object)maxItems);
            selfLink.addParameter("skipCount", (Object)skipCount);
            feed.writeSelfLink(selfLink.toString(), null);
            feed.writeDescribedByLink(this.compileUrl(baseUrl, "type", folderInfo.getTypeId()));
            feed.writeAllowableActionsLink(this.compileUrl(baseUrl, "allowableactions", folderInfo.getId()));
            feed.writeDownLink(this.compileUrl(baseUrl, "children", folderInfo.getId()), "application/atom+xml;type=feed");
            if (folderInfo.supportsDescendants()) {
                feed.writeDownLink(this.compileUrl(baseUrl, "descendants", folderInfo.getId()), "application/cmistree+xml");
            }
            if (folderInfo.supportsFolderTree()) {
                feed.writeFolderTreeLink(this.compileUrl(baseUrl, "foldertree", folderInfo.getId()));
            }
            if (folderInfo.hasParent()) {
                feed.writeUpLink(this.compileUrl(baseUrl, "parents", folderInfo.getId()), "application/atom+xml;type=feed");
            }
            if (folderInfo.getRenditionInfos() != null) {
                for (RenditionInfo ri : folderInfo.getRenditionInfos()) {
                    feed.writeAlternateLink(this.compileUrl(baseUrl, "content", ri.getId()), ri.getContenType(), ri.getKind(), ri.getTitle(), ri.getLength());
                }
            }
            if (folderInfo.hasAcl()) {
                feed.writeAclLink(this.compileUrl(baseUrl, "acl", folderInfo.getId()));
            }
            if (folderInfo.supportsPolicies()) {
                feed.writePoliciesLink(this.compileUrl(baseUrl, "policies", folderInfo.getId()));
            }
            if (folderInfo.supportsRelationships()) {
                feed.writeRelationshipsLink(this.compileUrl(baseUrl, "relationships", folderInfo.getId()));
            }
            UrlBuilder pagingUrl = new UrlBuilder(this.compileUrlBuilder(baseUrl, "children", folderInfo.getId()));
            pagingUrl.addParameter("filter", (Object)filter);
            pagingUrl.addParameter("orderBy", (Object)orderBy);
            pagingUrl.addParameter("includeAllowableActions", (Object)includeAllowableActions);
            pagingUrl.addParameter("includeRelationships", (Object)includeRelationships);
            pagingUrl.addParameter("renditionFilter", (Object)renditionFilter);
            pagingUrl.addParameter("includePathSegment", (Object)includePathSegment);
            feed.writePagingLinks(pagingUrl, maxItems, skipCount, children.getNumItems(), children.hasMoreItems(), PAGE_SIZE);
            feed.writeCollection(this.compileUrl(baseUrl, "children", folderInfo.getId()), null, "Folder collection", "application/cmisatom+xml");
            if (children.getObjects() != null) {
                AtomEntry entry = new AtomEntry(feed.getWriter());
                for (ObjectInFolderData object : children.getObjects()) {
                    if (object == null || object.getObject() == null) continue;
                    this.writeObjectEntry(service, entry, object.getObject(), null, repositoryId, object.getPathSegment(), null, baseUrl, false, context.getCmisVersion());
                }
            }
            feed.writeExtensions((ExtensionsData)children);
            feed.endFeed();
            feed.endDocument();
        }
    }
}

