/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.PolicyIdList;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyData;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BindingsObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChoiceImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyIdListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.inmemory.DataObjectCreator;
import org.apache.chemistry.opencmis.inmemory.FilterParser;
import org.apache.chemistry.opencmis.inmemory.NameValidator;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.server.support.TypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyCreationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyCreationHelper.class);

    private PropertyCreationHelper() {
    }

    public static PropertyBooleanDefinitionImpl createBooleanDefinition(String id, String displayName, Updatability upd) {
        PropertyBooleanDefinitionImpl prop = new PropertyBooleanDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.BOOLEAN, displayName, Cardinality.SINGLE, upd);
        return prop;
    }

    public static PropertyBooleanDefinitionImpl createBooleanMultiDefinition(String id, String displayName, Updatability upd) {
        PropertyBooleanDefinitionImpl prop = new PropertyBooleanDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.BOOLEAN, displayName, Cardinality.MULTI, upd);
        return prop;
    }

    public static PropertyDateTimeDefinitionImpl createDateTimeDefinition(String id, String displayName, Updatability upd) {
        PropertyDateTimeDefinitionImpl prop = new PropertyDateTimeDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.DATETIME, displayName, Cardinality.SINGLE, upd);
        return prop;
    }

    public static PropertyDateTimeDefinitionImpl createDateTimeMultiDefinition(String id, String displayName, Updatability upd) {
        PropertyDateTimeDefinitionImpl prop = new PropertyDateTimeDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.DATETIME, displayName, Cardinality.MULTI, upd);
        return prop;
    }

    public static PropertyDecimalDefinitionImpl createDecimalDefinition(String id, String displayName, Updatability upd) {
        PropertyDecimalDefinitionImpl prop = new PropertyDecimalDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.DECIMAL, displayName, Cardinality.SINGLE, upd);
        return prop;
    }

    public static PropertyDecimalDefinitionImpl createDecimalMultiDefinition(String id, String displayName, Updatability upd) {
        PropertyDecimalDefinitionImpl prop = new PropertyDecimalDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.DECIMAL, displayName, Cardinality.MULTI, upd);
        return prop;
    }

    public static PropertyHtmlDefinitionImpl createHtmlDefinition(String id, String displayName, Updatability upd) {
        PropertyHtmlDefinitionImpl prop = new PropertyHtmlDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.HTML, displayName, Cardinality.SINGLE, upd);
        return prop;
    }

    public static PropertyHtmlDefinitionImpl createHtmlMultiDefinition(String id, String displayName, Updatability upd) {
        PropertyHtmlDefinitionImpl prop = new PropertyHtmlDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.HTML, displayName, Cardinality.MULTI, upd);
        return prop;
    }

    public static PropertyIdDefinitionImpl createIdDefinition(String id, String displayName, Updatability upd) {
        PropertyIdDefinitionImpl prop = new PropertyIdDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.ID, displayName, Cardinality.SINGLE, upd);
        return prop;
    }

    public static PropertyIdDefinitionImpl createIdMultiDefinition(String id, String displayName, Updatability upd) {
        PropertyIdDefinitionImpl prop = new PropertyIdDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.ID, displayName, Cardinality.MULTI, upd);
        return prop;
    }

    public static PropertyIntegerDefinitionImpl createIntegerDefinition(String id, String displayName, Updatability upd) {
        PropertyIntegerDefinitionImpl prop = new PropertyIntegerDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.INTEGER, displayName, Cardinality.SINGLE, upd);
        return prop;
    }

    public static PropertyIntegerDefinitionImpl createIntegerMultiDefinition(String id, String displayName, Updatability upd) {
        PropertyIntegerDefinitionImpl prop = new PropertyIntegerDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.INTEGER, displayName, Cardinality.MULTI, upd);
        return prop;
    }

    public static PropertyStringDefinitionImpl createStringDefinition(String id, String displayName, Updatability upd) {
        PropertyStringDefinitionImpl prop = new PropertyStringDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.STRING, displayName, Cardinality.SINGLE, upd);
        return prop;
    }

    public static PropertyStringDefinitionImpl createStringMultiDefinition(String id, String displayName, Updatability upd) {
        PropertyStringDefinitionImpl prop = new PropertyStringDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.STRING, displayName, Cardinality.MULTI, upd);
        return prop;
    }

    public static PropertyUriDefinitionImpl createUriDefinition(String id, String displayName, Updatability upd) {
        PropertyUriDefinitionImpl prop = new PropertyUriDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.URI, displayName, Cardinality.SINGLE, upd);
        return prop;
    }

    public static PropertyUriDefinitionImpl createUriMultiDefinition(String id, String displayName, Updatability upd) {
        PropertyUriDefinitionImpl prop = new PropertyUriDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.URI, displayName, Cardinality.MULTI, upd);
        return prop;
    }

    public static <T> void addElemToPicklist(AbstractPropertyDefinition<T> prop, T value) {
        ArrayList<ChoiceImpl> choiceList = prop.getChoices();
        if (choiceList == null) {
            choiceList = new ArrayList<ChoiceImpl>();
            prop.setChoices(choiceList);
        }
        ChoiceImpl elem = new ChoiceImpl();
        elem.setValue(Collections.singletonList(value));
        choiceList.add(elem);
    }

    public static <T> void setDefaultValue(AbstractPropertyDefinition<T> prop, T defVal) {
        prop.setDefaultValue(Collections.singletonList(defVal));
    }

    public static Properties getPropertiesFromObject(StoredObject so, ObjectStore objectStore, TypeManager typeManager, List<String> requestedIds, boolean fillOptionalPropertyData) {
        BindingsObjectFactoryImpl objectFactory = new BindingsObjectFactoryImpl();
        HashMap properties = new HashMap();
        so.fillProperties(properties, (BindingsObjectFactory)objectFactory, requestedIds);
        TypeDefinition td = typeManager.getTypeById(so.getTypeId()).getTypeDefinition();
        String typeId = so.getTypeId();
        if (so instanceof Folder && FilterParser.isContainedInFilter("cmis:path", requestedIds)) {
            String path = objectStore.getFolderPath(so.getId());
            properties.put("cmis:path", (PropertyData<?>)objectFactory.createPropertyStringData("cmis:path", path));
        }
        if (FilterParser.isContainedInFilter("cmis:baseTypeId", requestedIds)) {
            if (td == null) {
                LOG.warn("getPropertiesFromObject(), cannot get type definition, a type with id " + typeId + " is unknown");
                return null;
            }
            String baseTypeId = td.getBaseTypeId().value();
            properties.put("cmis:baseTypeId", (PropertyData<?>)objectFactory.createPropertyIdData("cmis:baseTypeId", baseTypeId));
        }
        Map propDefs = td.getPropertyDefinitions();
        for (Object propDef : propDefs.values()) {
            if (properties.containsKey(propDef.getId()) || !FilterParser.isContainedInFilter(propDef.getId(), requestedIds)) continue;
            properties.put(propDef.getId(), (PropertyData<?>)PropertyCreationHelper.getEmptyValue(propDef));
        }
        List<String> secTypeIds = so.getSecondaryTypeIds();
        for (String secTypeId : secTypeIds) {
            td = typeManager.getTypeById(secTypeId).getTypeDefinition();
            propDefs = td.getPropertyDefinitions();
            for (PropertyDefinition propDef : propDefs.values()) {
                if (properties.containsKey(propDef.getId()) || !FilterParser.isContainedInFilter(propDef.getId(), requestedIds)) continue;
                properties.put(propDef.getId(), (PropertyData<?>)PropertyCreationHelper.getEmptyValue(propDef));
            }
        }
        ArrayList propertiesList = new ArrayList(properties.values());
        if (fillOptionalPropertyData) {
            PropertyCreationHelper.fillOptionalPropertyData(td, propertiesList);
        }
        Properties props = objectFactory.createPropertiesData(propertiesList);
        return props;
    }

    public static Properties getPropertiesFromObject(TypeManager tm, StoredObject so, ObjectStore objectStore, TypeDefinition primaryType, List<TypeDefinition> secondaryTypes, Map<String, String> requestedIds, Map<String, String> requestedFuncs) {
        ArrayList<String> idList = new ArrayList<String>(requestedIds.values());
        BindingsObjectFactoryImpl objectFactory = new BindingsObjectFactoryImpl();
        HashMap properties = new HashMap();
        so.fillProperties(properties, (BindingsObjectFactory)objectFactory, idList);
        if (so instanceof Folder && FilterParser.isContainedInFilter("cmis:path", idList)) {
            String path = objectStore.getFolderPath(so.getId());
            properties.put("cmis:path", (PropertyData<?>)objectFactory.createPropertyStringData("cmis:path", path));
        }
        if (FilterParser.isContainedInFilter("cmis:baseTypeId", idList)) {
            String baseTypeId = primaryType.getBaseTypeId().value();
            properties.put("cmis:baseTypeId", (PropertyData<?>)objectFactory.createPropertyIdData("cmis:baseTypeId", baseTypeId));
        }
        HashMap mappedProperties = new HashMap();
        if (requestedIds.containsValue("*")) {
            for (Map.Entry entry : properties.entrySet()) {
                PropertyCreationHelper.addPropertyToMap(mappedProperties, primaryType, (PropertyData)entry.getValue(), null);
            }
            Iterator<Object> propDefs = primaryType.getPropertyDefinitions();
            for (PropertyDefinition propDef : propDefs.values()) {
                if (mappedProperties.containsKey(propDef.getQueryName())) continue;
                mappedProperties.put(propDef.getId(), (PropertyData<?>)PropertyCreationHelper.getEmptyValue(propDef));
            }
        } else {
            for (Map.Entry<String, String> entry : requestedIds.entrySet()) {
                String queryNameOrAlias = entry.getKey();
                PropertyData propertyData = (PropertyData)properties.get(entry.getValue());
                if (null != propertyData) {
                    PropertyCreationHelper.addPropertyToMap(mappedProperties, primaryType, propertyData, queryNameOrAlias);
                    continue;
                }
                PropertyCreationHelper.addNotSetPropertyToMap(mappedProperties, primaryType, entry.getValue(), queryNameOrAlias);
            }
        }
        if (null != secondaryTypes) {
            for (TypeDefinition typeDefinition : secondaryTypes) {
                if (requestedIds.containsValue("*")) {
                    for (Map.Entry entry : properties.entrySet()) {
                        PropertyCreationHelper.addPropertyToMap(mappedProperties, typeDefinition, (PropertyData)entry.getValue(), null);
                    }
                    Map propDefs = typeDefinition.getPropertyDefinitions();
                    for (PropertyDefinition propDef : propDefs.values()) {
                        if (mappedProperties.containsKey(propDef.getQueryName())) continue;
                        mappedProperties.put(propDef.getId(), (PropertyData<?>)PropertyCreationHelper.getEmptyValue(propDef));
                    }
                    continue;
                }
                for (Map.Entry<String, String> entry : requestedIds.entrySet()) {
                    String queryNameOrAlias = entry.getKey();
                    PropertyData prop4 = (PropertyData)properties.get(entry.getValue());
                    if (null != prop4) {
                        PropertyCreationHelper.addPropertyToMap(mappedProperties, typeDefinition, prop4, queryNameOrAlias);
                        continue;
                    }
                    PropertyCreationHelper.addNotSetPropertyToMap(mappedProperties, typeDefinition, entry.getValue(), queryNameOrAlias);
                }
            }
        }
        if (!requestedIds.containsValue("*")) {
            for (Map.Entry entry : requestedIds.entrySet()) {
                if (mappedProperties.containsKey(entry.getValue())) continue;
                PropertyData pd = (PropertyData)properties.get(entry.getValue());
                TypeDefinition typeDefinition = PropertyCreationHelper.findFirstTypeDefHavingProperty(tm, so, pd);
                PropertyCreationHelper.addPropertyToMap(mappedProperties, typeDefinition, pd, (String)entry.getKey());
            }
        }
        for (Map.Entry entry : requestedFuncs.entrySet()) {
            if (!((String)entry.getValue()).equals("SCORE")) continue;
            String queryName = "SEARCH_SCORE";
            if (!((String)entry.getKey()).equals("SCORE")) {
                queryName = (String)entry.getKey();
            }
            PropertyDecimalImpl propertyDecimalImpl = new PropertyDecimalImpl();
            propertyDecimalImpl.setValue((Object)BigDecimal.valueOf(1.0));
            propertyDecimalImpl.setId(queryName);
            propertyDecimalImpl.setQueryName(queryName);
            propertyDecimalImpl.setLocalName("SCORE");
            propertyDecimalImpl.setDisplayName("Score");
            mappedProperties.put((String)entry.getKey(), (PropertyData<?>)propertyDecimalImpl);
        }
        PropertiesImpl props = new PropertiesImpl(mappedProperties.values());
        return props;
    }

    private static TypeDefinition findFirstTypeDefHavingProperty(TypeManager tm, StoredObject so, PropertyData<?> pd) {
        List<String> typeIds = so.getSecondaryTypeIds();
        for (String typeId : typeIds) {
            TypeDefinition typeDef = tm.getTypeById(typeId).getTypeDefinition();
            Map propMap = typeDef.getPropertyDefinitions();
            if (!propMap.containsKey(pd.getId())) continue;
            return typeDef;
        }
        return null;
    }

    private static void addNotSetPropertyToMap(Map<String, PropertyData<?>> mappedProperties, TypeDefinition typeDef, String propId, String queryNameOrAlias) {
        PropertyDefinition propDef = (PropertyDefinition)typeDef.getPropertyDefinitions().get(propId);
        if (null != propDef) {
            AbstractPropertyData<?> ad = PropertyCreationHelper.getEmptyValue(propDef);
            String localName = propDef.getLocalName();
            String displayName = propDef.getDisplayName();
            ad.setQueryName(queryNameOrAlias);
            ad.setLocalName(localName);
            ad.setDisplayName(displayName);
            mappedProperties.put(queryNameOrAlias, (PropertyData<?>)ad);
        }
    }

    private static void addPropertyToMap(Map<String, PropertyData<?>> mappedProperties, TypeDefinition typeDef, PropertyData<?> propData, String queryNameOrAlias) {
        String propId = propData.getId();
        if (typeDef.getPropertyDefinitions().containsKey(propId)) {
            PropertyDefinition propDef = (PropertyDefinition)typeDef.getPropertyDefinitions().get(propId);
            String queryName = propDef.getQueryName();
            String localName = propDef.getLocalName();
            String displayName = propDef.getDisplayName();
            AbstractPropertyData<?> ad = PropertyCreationHelper.clonePropertyData(propData);
            ad.setQueryName(queryNameOrAlias == null ? queryName : queryNameOrAlias);
            ad.setLocalName(localName);
            ad.setDisplayName(displayName);
            mappedProperties.put(queryName, (PropertyData<?>)ad);
        }
    }

    public static ObjectData getObjectData(CallContext context, TypeManager tm, ObjectStore objectStore, StoredObject so, String filter, String user, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, ExtensionsData extension) {
        List<String> polIds;
        List<RenditionData> renditions;
        ObjectDataImpl od = new ObjectDataImpl();
        if (so == null) {
            throw new CmisObjectNotFoundException("Illegal object id: null");
        }
        List<String> requestedIds = FilterParser.getRequestedIdsFromFilter(filter);
        Properties props = PropertyCreationHelper.getPropertiesFromObject(so, objectStore, tm, requestedIds, true);
        if (null != includeAllowableActions && includeAllowableActions.booleanValue()) {
            AllowableActions allowableActions = so.getAllowableActions(context, user);
            od.setAllowableActions(allowableActions);
        }
        if (null != (renditions = objectStore.getRenditions(so, renditionFilter, 0L, 0L)) && renditions.size() > 0) {
            od.setRenditions(renditions);
        }
        if (null != includeACL && includeACL.booleanValue()) {
            int aclId = so instanceof DocumentVersion ? ((DocumentVersion)so).getParentDocument().getAclId() : so.getAclId();
            Acl acl = objectStore.getAcl(aclId);
            od.setAcl(acl);
        }
        od.setIsExactAcl(Boolean.valueOf(true));
        if (null != includePolicyIds && includePolicyIds.booleanValue()) {
            od.setPolicyIds(DataObjectCreator.fillPolicyIds(so));
        }
        if (null != includeRelationships && includeRelationships != IncludeRelationships.NONE) {
            od.setRelationships(DataObjectCreator.fillRelationships(context, tm, objectStore, includeRelationships, so, user));
        }
        if (null != includePolicyIds && includePolicyIds.booleanValue() && null != (polIds = so.getAppliedPolicies())) {
            PolicyIdListImpl policies = new PolicyIdListImpl();
            policies.setPolicyIds(polIds);
            od.setPolicyIds((PolicyIdList)policies);
        }
        od.setProperties(props);
        return od;
    }

    public static ObjectData getObjectDataQueryResult(CallContext context, TypeManager tm, ObjectStore objectStore, TypeDefinition primaryType, StoredObject so, String user, Map<String, String> requestedProperties, Map<String, String> requestedFuncs, List<TypeDefinition> secondaryTypes, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter) {
        List<RenditionData> renditions;
        ObjectDataImpl od = new ObjectDataImpl();
        Properties props = PropertyCreationHelper.getPropertiesFromObject(tm, so, objectStore, primaryType, secondaryTypes, requestedProperties, requestedFuncs);
        if (null != includeAllowableActions && includeAllowableActions.booleanValue()) {
            AllowableActions allowableActions = so.getAllowableActions(context, user);
            od.setAllowableActions(allowableActions);
        }
        int aclId = so.getAclId();
        Acl acl = objectStore.getAcl(aclId);
        od.setAcl(acl);
        od.setIsExactAcl(Boolean.valueOf(true));
        if (null != includeRelationships && includeRelationships != IncludeRelationships.NONE) {
            od.setRelationships(DataObjectCreator.fillRelationships(context, tm, objectStore, includeRelationships, so, user));
        }
        if (null != (renditions = objectStore.getRenditions(so, renditionFilter, 0L, 0L)) && renditions.size() > 0) {
            od.setRenditions(renditions);
        }
        od.setProperties(props);
        return od;
    }

    private static void createStandardDefinition(AbstractPropertyDefinition<?> prop, String id, PropertyType propType, String displayName, Cardinality card, Updatability upd) {
        if (!NameValidator.isValidId(id)) {
            throw new CmisInvalidArgumentException("Name contains illegal characters, not allowed are '/', '\\', ':', '\"', '*'. '?', '<','>', '|'");
        }
        prop.setId(id);
        if (displayName == null) {
            prop.setDisplayName("Sample " + prop.getId() + " boolean property");
        } else {
            prop.setDisplayName(displayName);
        }
        prop.setDescription("This is a " + prop.getDisplayName() + " property.");
        prop.setLocalName(id);
        prop.setLocalNamespace(null);
        prop.setQueryName(id);
        prop.setIsInherited(Boolean.valueOf(false));
        prop.setCardinality(card);
        prop.setIsOpenChoice(Boolean.valueOf(false));
        prop.setIsQueryable(Boolean.valueOf(true));
        prop.setIsRequired(Boolean.valueOf(false));
        prop.setIsOrderable(Boolean.valueOf(card == Cardinality.SINGLE));
        prop.setPropertyType(propType);
        prop.setUpdatability(upd);
    }

    private static void fillOptionalPropertyData(TypeDefinition td, List<PropertyData<?>> properties) {
        for (PropertyData<?> pd : properties) {
            PropertyCreationHelper.fillOptionalPropertyData(td, (AbstractPropertyData)pd);
        }
    }

    private static void fillOptionalPropertyData(TypeDefinition td, AbstractPropertyData<?> property) {
        PropertyDefinition pd = (PropertyDefinition)td.getPropertyDefinitions().get(property.getId());
        if (null != pd) {
            String displayName = pd.getDisplayName();
            String queryName = pd.getQueryName();
            String localName = pd.getLocalName();
            property.setDisplayName(displayName);
            property.setLocalName(localName);
            property.setQueryName(queryName);
        }
    }

    private static AbstractPropertyData<?> getEmptyValue(PropertyDefinition<?> propDef) {
        PropertyBooleanImpl emptyValue;
        if (propDef.getPropertyType().equals((Object)PropertyType.BOOLEAN)) {
            emptyValue = new PropertyBooleanImpl(propDef.getId(), (Boolean)null);
        } else if (propDef.getPropertyType().equals((Object)PropertyType.DATETIME)) {
            emptyValue = new PropertyDateTimeImpl(propDef.getId(), (GregorianCalendar)null);
        } else if (propDef.getPropertyType().equals((Object)PropertyType.DECIMAL)) {
            emptyValue = new PropertyDecimalImpl(propDef.getId(), (BigDecimal)null);
        } else if (propDef.getPropertyType().equals((Object)PropertyType.HTML)) {
            emptyValue = new PropertyHtmlImpl(propDef.getId(), (String)null);
        } else if (propDef.getPropertyType().equals((Object)PropertyType.ID)) {
            emptyValue = new PropertyIdImpl(propDef.getId(), (String)null);
        } else if (propDef.getPropertyType().equals((Object)PropertyType.INTEGER)) {
            emptyValue = new PropertyIntegerImpl(propDef.getId(), (BigInteger)null);
        } else if (propDef.getPropertyType().equals((Object)PropertyType.STRING)) {
            emptyValue = new PropertyStringImpl(propDef.getId(), (String)null);
        } else if (propDef.getPropertyType().equals((Object)PropertyType.URI)) {
            emptyValue = new PropertyUriImpl(propDef.getId(), (String)null);
        } else {
            throw new CmisRuntimeException("Unknown property type " + propDef.getPropertyType());
        }
        emptyValue.setDisplayName(propDef.getDisplayName());
        emptyValue.setQueryName(propDef.getQueryName());
        emptyValue.setLocalName(propDef.getLocalName());
        return emptyValue;
    }

    private static AbstractPropertyData<?> clonePropertyData(PropertyData<?> prop) {
        PropertyBooleanImpl ad = null;
        if (prop instanceof PropertyBooleanImpl) {
            PropertyBooleanImpl clone = new PropertyBooleanImpl();
            clone.setValues(((PropertyBooleanImpl)prop).getValues());
            ad = clone;
        } else if (prop instanceof PropertyDateTimeImpl) {
            PropertyDateTimeImpl clone = new PropertyDateTimeImpl();
            clone.setValues(((PropertyDateTimeImpl)prop).getValues());
            ad = clone;
        } else if (prop instanceof PropertyDecimalImpl) {
            PropertyDecimalImpl clone = new PropertyDecimalImpl();
            clone.setValues(((PropertyDecimalImpl)prop).getValues());
            ad = clone;
        } else if (prop instanceof PropertyHtmlImpl) {
            PropertyHtmlImpl clone = new PropertyHtmlImpl();
            clone.setValues(((PropertyHtmlImpl)prop).getValues());
            ad = clone;
        } else if (prop instanceof PropertyIdImpl) {
            PropertyIdImpl clone = new PropertyIdImpl();
            clone.setValues(((PropertyIdImpl)prop).getValues());
            ad = clone;
        } else if (prop instanceof PropertyIntegerImpl) {
            PropertyIntegerImpl clone = new PropertyIntegerImpl();
            clone.setValues(((PropertyIntegerImpl)prop).getValues());
            ad = clone;
        } else if (prop instanceof PropertyStringImpl) {
            PropertyStringImpl clone = new PropertyStringImpl();
            clone.setValues(((PropertyStringImpl)prop).getValues());
            ad = clone;
        } else if (prop instanceof PropertyUriImpl) {
            PropertyUriImpl clone = new PropertyUriImpl();
            clone.setValues(((PropertyUriImpl)prop).getValues());
            ad = clone;
        } else {
            throw new CmisRuntimeException("Unknown property type: " + prop.getClass());
        }
        ad.setDisplayName(prop.getDisplayName());
        ad.setId(prop.getId());
        ad.setLocalName(prop.getLocalName());
        ad.setQueryName(prop.getQueryName());
        ad.setExtensions(prop.getExtensions());
        return ad;
    }
}

