/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BulkUpdateObjectIdAndChangeTokenImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CmisExtensionElementImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FailedToDeleteDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.inmemory.FilterParser;
import org.apache.chemistry.opencmis.inmemory.NameValidator;
import org.apache.chemistry.opencmis.inmemory.TypeValidator;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryAbstractServiceImpl;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryServiceFactoryImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Content;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Document;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Fileable;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Filing;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;
import org.apache.chemistry.opencmis.inmemory.types.DocumentTypeCreationHelper;
import org.apache.chemistry.opencmis.inmemory.types.PropertyCreationHelper;
import org.apache.chemistry.opencmis.server.support.TypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryObjectServiceImpl
extends InMemoryAbstractServiceImpl {
    private static final String UNKNOWN_USER = "unknown";
    private static final String UNKNOWN_OBJECT_ID = "Unknown object id: ";
    private static final Logger LOG = LoggerFactory.getLogger((String)InMemoryServiceFactoryImpl.class.getName());

    public InMemoryObjectServiceImpl(StoreManager storeManager) {
        super(storeManager);
    }

    public String createDocument(CallContext context, String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        LOG.debug("start createDocument()");
        StoredObject so = this.createDocumentIntern(context, repositoryId, properties, folderId, contentStream, versioningState, policies, addAces, removeAces, extension);
        LOG.debug("stop createDocument()");
        return so.getId();
    }

    public String createDocumentFromSource(CallContext context, String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        LOG.debug("start createDocumentFromSource()");
        StoredObject so = this.validator.createDocumentFromSource(context, repositoryId, sourceId, folderId, policies, extension);
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        ContentStream content = this.getContentStream(context, repositoryId, sourceId, null, BigInteger.valueOf(-1L), BigInteger.valueOf(-1L), null);
        if (so == null) {
            throw new CmisObjectNotFoundException(UNKNOWN_OBJECT_ID + sourceId);
        }
        List<String> requestedIds = FilterParser.getRequestedIdsFromFilter("*");
        TypeManager tm = this.fStoreManager.getTypeManager(repositoryId);
        Properties existingProps = PropertyCreationHelper.getPropertiesFromObject(so, objectStore, tm, requestedIds, true);
        PropertiesImpl newPD = new PropertiesImpl();
        for (PropertyData prop : existingProps.getProperties().values()) {
            newPD.addProperty(prop);
        }
        if (null != properties) {
            for (PropertyData prop : properties.getProperties().values()) {
                newPD.addProperty(prop);
            }
        }
        String res = this.createDocument(context, repositoryId, (Properties)newPD, folderId, content, versioningState, policies, addAces, removeAces, null);
        LOG.debug("stop createDocumentFromSource()");
        return res;
    }

    public String createFolder(CallContext context, String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        LOG.debug("start createFolder()");
        Folder folder = this.createFolderIntern(context, repositoryId, properties, folderId, policies, addAces, removeAces, extension);
        LOG.debug("stop createFolder()");
        return folder.getId();
    }

    public String createPolicy(CallContext context, String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        LOG.debug("start createPolicy()");
        StoredObject so = this.createPolicyIntern(context, repositoryId, properties, folderId, policies, addAces, removeAces, extension);
        LOG.debug("stop createPolicy()");
        return so == null ? null : so.getId();
    }

    public String createRelationship(CallContext context, String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        LOG.debug("start createRelationship()");
        StoredObject so = this.createRelationshipIntern(context, repositoryId, properties, policies, addAces, removeAces, extension);
        LOG.debug("stop createRelationship()");
        return so == null ? null : so.getId();
    }

    public String createItem(CallContext context, String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        StoredObject so = this.createItemIntern(context, repositoryId, properties, folderId, policies, addAces, removeAces, extension);
        return so.getId();
    }

    public String create(CallContext context, String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        String typeId;
        if (null == properties || null == properties.getProperties()) {
            throw new CmisInvalidArgumentException("Cannot create object, without properties.");
        }
        PropertyData pd = (PropertyData)properties.getProperties().get("cmis:objectTypeId");
        String string = typeId = pd == null ? null : (String)pd.getFirstValue();
        if (null == typeId) {
            throw new CmisInvalidArgumentException("Cannot create object, without a type (no property with id CMIS_OBJECT_TYPE_ID).");
        }
        boolean cmis11 = context.getCmisVersion() != CmisVersion.CMIS_1_0;
        TypeDefinitionContainer typeDefC = this.fStoreManager.getTypeById(repositoryId, typeId, cmis11);
        if (typeDefC == null) {
            throw new CmisInvalidArgumentException("Cannot create object, a type with id " + typeId + " is unknown");
        }
        BaseTypeId typeBaseId = typeDefC.getTypeDefinition().getBaseTypeId();
        StoredObject so = null;
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        if (typeBaseId.equals((Object)DocumentTypeCreationHelper.getCmisDocumentType().getBaseTypeId())) {
            so = this.createDocumentIntern(context, repositoryId, properties, folderId, contentStream, versioningState, null, null, null, null);
        } else if (typeBaseId.equals((Object)DocumentTypeCreationHelper.getCmisFolderType().getBaseTypeId())) {
            so = this.createFolderIntern(context, repositoryId, properties, folderId, null, null, null, null);
        } else if (typeBaseId.equals((Object)DocumentTypeCreationHelper.getCmisPolicyType().getBaseTypeId())) {
            so = this.createPolicyIntern(context, repositoryId, properties, folderId, null, null, null, null);
        } else if (typeBaseId.equals((Object)DocumentTypeCreationHelper.getCmisRelationshipType().getBaseTypeId())) {
            so = this.createRelationshipIntern(context, repositoryId, properties, null, null, null, null);
        } else if (typeBaseId.equals((Object)DocumentTypeCreationHelper.getCmisItemType().getBaseTypeId())) {
            so = this.createItemIntern(context, repositoryId, properties, folderId, null, null, null, null);
        } else {
            LOG.error("The type contains an unknown base object id, object can't be created");
        }
        TypeManager tm = this.fStoreManager.getTypeManager(repositoryId);
        ObjectData od = PropertyCreationHelper.getObjectData(context, tm, objStore, so, null, context.getUsername(), false, IncludeRelationships.NONE, null, false, false, extension);
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(context, repositoryId, so, od, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        return so != null ? so.getId() : null;
    }

    public void deleteContentStream(CallContext context, String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        LOG.debug("start deleteContentStream()");
        StoredObject so = this.validator.deleteContentStream(context, repositoryId, objectId, extension);
        if (so == null) {
            throw new CmisObjectNotFoundException(UNKNOWN_OBJECT_ID + objectId);
        }
        if (!(so.getChangeToken() == null || changeToken != null && so.getChangeToken().equals(changeToken.getValue()))) {
            throw new CmisUpdateConflictException("deleteContentStream failed, ChangeToken does not match.");
        }
        if (!(so instanceof Content)) {
            throw new CmisObjectNotFoundException("Id" + objectId + " does not refer to a document, but only documents can have content");
        }
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        objectStore.setContent(so, null);
        if (null != changeToken) {
            String changeTokenVal = so.getChangeToken();
            LOG.debug("deleteContentStream(), new change token is: " + changeTokenVal);
            changeToken.setValue((Object)changeTokenVal);
        }
        LOG.debug("stop deleteContentStream()");
    }

    public void deleteObject(CallContext context, String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        LOG.debug("start deleteObject()");
        this.validator.deleteObject(context, repositoryId, objectId, allVersions, extension);
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        LOG.debug("delete object for id: " + objectId);
        if (objectId.equals(objectStore.getRootFolder().getId())) {
            throw new CmisNotSupportedException("You can't delete a root folder");
        }
        objectStore.deleteObject(objectId, allVersions, context.getUsername());
        LOG.debug("stop deleteObject()");
    }

    public FailedToDeleteData deleteTree(CallContext context, String repositoryId, String folderId, Boolean allVers, UnfileObject unfile, Boolean continueOnFail, ExtensionsData extension) {
        LOG.debug("start deleteTree()");
        boolean allVersions = null == allVers ? true : allVers;
        UnfileObject unfileObjects = null == unfile ? UnfileObject.DELETE : unfile;
        boolean continueOnFailure = null == continueOnFail ? false : continueOnFail;
        StoredObject so = this.validator.deleteTree(context, repositoryId, folderId, allVersions, unfileObjects, extension);
        ArrayList<String> failedToDeleteIds = new ArrayList<String>();
        FailedToDeleteDataImpl result = new FailedToDeleteDataImpl();
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        if (null == so) {
            throw new CmisInvalidArgumentException("Cannot delete object with id  " + folderId + ". Object does not exist.");
        }
        if (!(so instanceof Folder)) {
            throw new CmisInvalidArgumentException("deleteTree can only be invoked on a folder, but id " + folderId + " does not refer to a folder");
        }
        if (unfileObjects == UnfileObject.UNFILE) {
            throw new CmisNotSupportedException("This repository does not support unfile operations.");
        }
        if (folderId.equals(objectStore.getRootFolder().getId())) {
            throw new CmisNotSupportedException("You can't delete a root folder");
        }
        this.deleteRecursive(objectStore, (Folder)so, continueOnFailure, allVersions, failedToDeleteIds, context.getUsername());
        result.setIds(failedToDeleteIds);
        LOG.debug("stop deleteTree()");
        return result;
    }

    public AllowableActions getAllowableActions(CallContext context, String repositoryId, String objectId, ExtensionsData extension) {
        LOG.debug("start getAllowableActions()");
        StoredObject so = this.validator.getAllowableActions(context, repositoryId, objectId, extension);
        this.fStoreManager.getObjectStore(repositoryId);
        if (so == null) {
            throw new CmisObjectNotFoundException(UNKNOWN_OBJECT_ID + objectId);
        }
        String user = context.getUsername();
        AllowableActions allowableActions = so.getAllowableActions(context, user);
        LOG.debug("stop getAllowableActions()");
        return allowableActions;
    }

    public ContentStream getContentStream(CallContext context, String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        LOG.debug("start getContentStream()");
        StoredObject so = this.validator.getContentStream(context, repositoryId, objectId, streamId, extension);
        if (so == null) {
            throw new CmisObjectNotFoundException(UNKNOWN_OBJECT_ID + objectId);
        }
        if (!(so instanceof Content) && objectId.endsWith("-rendition")) {
            throw new CmisConstraintException("Id" + objectId + " does not refer to a document or version, but only those can have content");
        }
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        ContentStream csd = InMemoryObjectServiceImpl.getContentStream(objStore, so, streamId, offset, length);
        if (null == csd) {
            throw new CmisConstraintException("Object " + so.getId() + " does not have content.");
        }
        LOG.debug("stop getContentStream()");
        return csd;
    }

    public ObjectData getObject(CallContext context, String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        LOG.debug("start getObject()");
        StoredObject so = this.validator.getObject(context, repositoryId, objectId, extension);
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        if (so == null) {
            throw new CmisObjectNotFoundException(UNKNOWN_OBJECT_ID + objectId);
        }
        String user = context.getUsername();
        TypeManager tm = this.fStoreManager.getTypeManager(repositoryId);
        ObjectData od = PropertyCreationHelper.getObjectData(context, tm, objStore, so, filter, user, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(context, repositoryId, so, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        String ns = "http://apache.org/opencmis/inmemory";
        ArrayList<CmisExtensionElementImpl> extElements = new ArrayList<CmisExtensionElementImpl>();
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("type", so.getTypeId());
        extElements.add(new CmisExtensionElementImpl(ns, "objectId", attr, objectId));
        extElements.add(new CmisExtensionElementImpl(ns, "name", null, so.getName()));
        od.setExtensions(Collections.singletonList(new CmisExtensionElementImpl(ns, "exampleExtension", null, extElements)));
        LOG.debug("stop getObject()");
        return od;
    }

    public ObjectData getObjectByPath(CallContext context, String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        LOG.debug("start getObjectByPath()");
        StoredObject so = this.validator.getObjectByPath(context, repositoryId, path, extension);
        if (so instanceof VersionedDocument) {
            VersionedDocument verDoc = (VersionedDocument)so;
            so = verDoc.getLatestVersion(false);
        }
        String user = context.getUsername();
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        TypeManager tm = this.fStoreManager.getTypeManager(repositoryId);
        ObjectData od = PropertyCreationHelper.getObjectData(context, tm, objStore, so, filter, user, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
        LOG.debug("stop getObjectByPath()");
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(context, repositoryId, so, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        return od;
    }

    public Properties getProperties(CallContext context, String repositoryId, String objectId, String filter, ExtensionsData extension) {
        LOG.debug("start getProperties()");
        StoredObject so = this.validator.getProperties(context, repositoryId, objectId, extension);
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        if (so == null) {
            throw new CmisObjectNotFoundException(UNKNOWN_OBJECT_ID + objectId);
        }
        List<String> requestedIds = FilterParser.getRequestedIdsFromFilter(filter);
        TypeManager tm = this.fStoreManager.getTypeManager(repositoryId);
        Properties props = PropertyCreationHelper.getPropertiesFromObject(so, objectStore, tm, requestedIds, true);
        LOG.debug("stop getProperties()");
        return props;
    }

    public List<RenditionData> getRenditions(CallContext context, String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        LOG.debug("start getRenditions()");
        StoredObject so = this.validator.getRenditions(context, repositoryId, objectId, extension);
        if (so == null) {
            throw new CmisObjectNotFoundException(UNKNOWN_OBJECT_ID + objectId);
        }
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        List<RenditionData> renditions = objStore.getRenditions(so, renditionFilter, maxItems == null ? 0L : maxItems.longValue(), skipCount == null ? 0L : skipCount.longValue());
        LOG.debug("stop getRenditions()");
        return renditions;
    }

    public ObjectData moveObject(CallContext context, String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        LOG.debug("start moveObject()");
        StoredObject[] sos = this.validator.moveObject(context, repositoryId, objectId, targetFolderId, sourceFolderId, extension);
        StoredObject so = sos[0];
        Folder targetFolder = null;
        Folder sourceFolder = null;
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        String user = context.getUsername();
        if (null == so) {
            throw new CmisObjectNotFoundException("Unknown object: " + (String)objectId.getValue());
        }
        if (!(so instanceof Filing)) {
            throw new CmisInvalidArgumentException("Object must be fileable: " + (String)objectId.getValue());
        }
        StoredObject soTarget = objectStore.getObjectById(targetFolderId);
        if (null == soTarget) {
            throw new CmisObjectNotFoundException("Unknown target folder: " + targetFolderId);
        }
        if (!(soTarget instanceof Folder)) {
            throw new CmisNotSupportedException("Destination " + targetFolderId + " of a move operation must be a folder");
        }
        targetFolder = (Folder)soTarget;
        StoredObject soSource = objectStore.getObjectById(sourceFolderId);
        if (null == soSource) {
            throw new CmisObjectNotFoundException("Unknown source folder: " + sourceFolderId);
        }
        if (!(soSource instanceof Folder)) {
            throw new CmisNotSupportedException("Source " + sourceFolderId + " of a move operation must be a folder");
        }
        sourceFolder = (Folder)soSource;
        boolean foundOldParent = false;
        for (String parentId : objectStore.getParentIds(so, user)) {
            if (!parentId.equals(soSource.getId())) continue;
            foundOldParent = true;
            break;
        }
        if (!foundOldParent) {
            throw new CmisNotSupportedException("Cannot move object, source folder " + sourceFolderId + "is not a parent of object " + (String)objectId.getValue());
        }
        if (so instanceof Folder && this.hasDescendant(context.getUsername(), objectStore, (Folder)so, targetFolder)) {
            throw new CmisNotSupportedException("Destination of a move cannot be a subfolder of the source");
        }
        objectStore.move(so, sourceFolder, targetFolder, user);
        objectId.setValue((Object)so.getId());
        LOG.debug("stop moveObject()");
        TypeManager tm = this.fStoreManager.getTypeManager(repositoryId);
        ObjectData od = PropertyCreationHelper.getObjectData(context, tm, objectStore, so, null, user, false, IncludeRelationships.NONE, null, false, false, extension);
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(context, repositoryId, so, od, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        return od;
    }

    public void setContentStream(CallContext context, String repositoryId, Holder<String> objectId, Boolean overwrite, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        Fileable content;
        LOG.debug("start setContentStream()");
        boolean overwriteFlag = overwrite == null ? true : overwrite;
        StoredObject so = this.validator.setContentStream(context, repositoryId, objectId, overwriteFlag, extension);
        if (changeToken != null && changeToken.getValue() != null && Long.valueOf(so.getChangeToken()) > Long.valueOf((String)changeToken.getValue())) {
            throw new CmisUpdateConflictException("setContentStream failed: changeToken does not match");
        }
        if (!(so instanceof Document || so instanceof VersionedDocument || so instanceof DocumentVersion)) {
            throw new CmisObjectNotFoundException("Id" + objectId + " does not refer to a document, but only documents can have content");
        }
        boolean cmis11 = context.getCmisVersion() != CmisVersion.CMIS_1_0;
        TypeDefinition typeDef = this.getTypeDefinition(repositoryId, so, cmis11);
        if (!(typeDef instanceof DocumentTypeDefinition)) {
            throw new CmisInvalidArgumentException("Object does not refer to a document, can't set content");
        }
        org.apache.chemistry.opencmis.server.support.TypeValidator.validateContentAllowed((DocumentTypeDefinition)((DocumentTypeDefinition)typeDef), (null != contentStream ? 1 : 0) != 0);
        if (so instanceof Document) {
            content = (Document)so;
        } else if (so instanceof DocumentVersion) {
            String user = context.getUsername();
            this.testHasProperCheckedOutStatus(so, user);
            content = (DocumentVersion)so;
        } else {
            throw new IllegalArgumentException("Content cannot be set on this object (must be document or version)");
        }
        if (!overwriteFlag && content.hasContent()) {
            throw new CmisContentAlreadyExistsException("cannot overwrite existing content if overwrite flag is not set");
        }
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        objStore.setContent(so, contentStream);
        so.updateSystemBasePropertiesWhenModified(null, context.getUsername());
        if (null != changeToken) {
            String changeTokenVal = so.getChangeToken();
            LOG.debug("setContentStream(), new change token is: " + changeTokenVal);
            changeToken.setValue((Object)changeTokenVal);
        }
        LOG.debug("stop setContentStream()");
    }

    public void updateProperties(CallContext context, String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, Acl acl, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        LOG.debug("start updateProperties()");
        if (properties == null) {
            throw new CmisRuntimeException("update properties: no properties given for object id: " + (String)objectId.getValue());
        }
        StoredObject so = this.validator.updateProperties(context, repositoryId, objectId, extension);
        String user = context.getUsername();
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        boolean cmis11 = context.getCmisVersion() != CmisVersion.CMIS_1_0;
        TypeDefinition typeDef = this.getTypeDefinition(repositoryId, so, cmis11);
        boolean isCheckedOut = false;
        isCheckedOut = this.isCheckedOut(so, user);
        HashMap oldProperties = new HashMap();
        this.validateProperties(repositoryId, so, properties, false, cmis11);
        if (changeToken != null && changeToken.getValue() != null && Long.valueOf(so.getChangeToken()) > Long.valueOf((String)changeToken.getValue())) {
            throw new CmisUpdateConflictException("updateProperties failed: changeToken does not match");
        }
        boolean hasUpdatedProp = false;
        List<String> existingSecondaryTypeIds = so.getSecondaryTypeIds();
        PropertyData pdSec = (PropertyData)properties.getProperties().get("cmis:secondaryObjectTypeIds");
        List newSecondaryTypeIds = pdSec == null ? null : pdSec.getValues();
        HashSet<String> secondaryTypeIds = new HashSet<String>();
        if (null != existingSecondaryTypeIds) {
            secondaryTypeIds.addAll(existingSecondaryTypeIds);
        }
        if (null != newSecondaryTypeIds) {
            secondaryTypeIds.addAll(newSecondaryTypeIds);
        }
        if (null != newSecondaryTypeIds) {
            List<String> propertiesIdToDelete = this.getListOfPropertiesToDeleteFromRemovedSecondaryTypes(context, repositoryId, so, newSecondaryTypeIds);
            Iterator iterator = propertiesIdToDelete.iterator();
            while (iterator.hasNext()) {
                String propIdToRemove = (String)iterator.next();
                oldProperties.put(propIdToRemove, null);
            }
        }
        for (String key : properties.getProperties().keySet()) {
            if (key.equals("cmis:name")) continue;
            PropertyData value = (PropertyData)properties.getProperties().get(key);
            PropertyDefinition propDef = (PropertyDefinition)typeDef.getPropertyDefinitions().get(key);
            if (cmis11 && null == propDef) {
                TypeDefinition typeDefSecondary = this.getSecondaryTypeDefinition(context, repositoryId, secondaryTypeIds, key);
                if (null == typeDefSecondary) {
                    throw new CmisInvalidArgumentException("Cannot update property " + key + ": not contained in type");
                }
                propDef = (PropertyDefinition)typeDefSecondary.getPropertyDefinitions().get(key);
            }
            if (null == propDef) {
                throw new CmisInvalidArgumentException("Unknown property " + key + ": not contained in type (or any secondary type)");
            }
            if (value.getValues() == null || value.getFirstValue() == null) {
                if (propDef.isRequired().booleanValue()) {
                    throw new CmisConstraintException("updateProperties failed, following property can't be deleted, because it is required: " + key);
                }
                oldProperties.put(key, null);
                hasUpdatedProp = true;
                continue;
            }
            if (propDef.getUpdatability() == Updatability.WHENCHECKEDOUT) {
                if (!isCheckedOut) {
                    throw new CmisUpdateConflictException("updateProperties failed, following property can't be updated, because it is not checked-out: " + key);
                }
            } else if (propDef.getUpdatability() != Updatability.READWRITE) {
                throw new CmisConstraintException("updateProperties failed, following property can't be updated, because it is not writable: " + key);
            }
            oldProperties.put(key, value);
            hasUpdatedProp = true;
        }
        PropertyData pd = (PropertyData)properties.getProperties().get("cmis:name");
        if (pd != null && so instanceof Filing) {
            String newName = (String)pd.getFirstValue();
            boolean hasParent = ((Filing)((Object)so)).hasParent();
            if (so instanceof Folder && !hasParent) {
                throw new CmisConstraintException("updateProperties failed, you cannot rename the root folder");
            }
            if (newName == null || newName.equals("")) {
                throw new CmisConstraintException("updateProperties failed, name must not be empty.");
            }
            if (!NameValidator.isValidName(newName)) {
                throw new CmisInvalidArgumentException("Name contains illegal characters, not allowed are '/', '\\', ':', '\"', '*'. '?', '<','>', '|'");
            }
            objStore.rename((Fileable)so, (String)pd.getFirstValue(), user);
            hasUpdatedProp = true;
        }
        objStore.updateObject(so, oldProperties, user);
        if (hasUpdatedProp) {
            objectId.setValue((Object)so.getId());
            if (null != changeToken) {
                String changeTokenVal = so.getChangeToken();
                LOG.debug("updateProperties(), new change token is: " + changeTokenVal);
                changeToken.setValue((Object)changeTokenVal);
            }
        }
        if (null != acl) {
            objStore.applyAcl(so, acl, AclPropagation.OBJECTONLY, user);
        }
        TypeManager tm = this.fStoreManager.getTypeManager(repositoryId);
        ObjectData od = PropertyCreationHelper.getObjectData(context, tm, objStore, so, null, user, false, IncludeRelationships.NONE, null, false, false, extension);
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(context, repositoryId, so, od, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        LOG.debug("stop updateProperties()");
    }

    public void appendContentStream(CallContext context, String repositoryId, Holder<String> objectId, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        LOG.debug("start appendContentStream()");
        StoredObject so = this.validator.appendContentStream(context, repositoryId, objectId, extension);
        if (changeToken != null && changeToken.getValue() != null && Long.valueOf(so.getChangeToken()) > Long.valueOf((String)changeToken.getValue())) {
            throw new CmisUpdateConflictException("appendContentStream failed: changeToken does not match");
        }
        if (!(so instanceof Document || so instanceof VersionedDocument || so instanceof DocumentVersion)) {
            throw new CmisObjectNotFoundException("Id" + objectId + " does not refer to a document, but only documents can have content");
        }
        boolean cmis11 = context.getCmisVersion() != CmisVersion.CMIS_1_0;
        TypeDefinition typeDef = this.getTypeDefinition(repositoryId, so, cmis11);
        if (!(typeDef instanceof DocumentTypeDefinition)) {
            throw new CmisInvalidArgumentException("Object does not refer to a document, can't set content");
        }
        org.apache.chemistry.opencmis.server.support.TypeValidator.validateContentAllowed((DocumentTypeDefinition)((DocumentTypeDefinition)typeDef), (null != contentStream ? 1 : 0) != 0);
        if (so instanceof DocumentVersion) {
            String user = context.getUsername();
            this.testHasProperCheckedOutStatus(so, user);
        } else if (!(so instanceof Document)) {
            throw new IllegalArgumentException("Content cannot be set on this object (must be document or version)");
        }
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        objStore.appendContent(so, contentStream);
        so.updateSystemBasePropertiesWhenModified(null, context.getUsername());
        if (null != changeToken) {
            String changeTokenVal = so.getChangeToken();
            LOG.debug("appendContentStream(), new change token is: " + changeTokenVal);
            changeToken.setValue((Object)changeTokenVal);
        }
    }

    public List<BulkUpdateObjectIdAndChangeToken> bulkUpdateProperties(CallContext context, String repositoryId, List<BulkUpdateObjectIdAndChangeToken> objectIdAndChangeToken, Properties properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        ArrayList<BulkUpdateObjectIdAndChangeToken> result = new ArrayList<BulkUpdateObjectIdAndChangeToken>();
        for (BulkUpdateObjectIdAndChangeToken obj : objectIdAndChangeToken) {
            Holder objId = new Holder((Object)obj.getId());
            Holder changeToken = new Holder((Object)obj.getChangeToken());
            try {
                this.updateProperties(context, repositoryId, (Holder<String>)objId, (Holder<String>)changeToken, properties, null, null, objectInfos);
                result.add((BulkUpdateObjectIdAndChangeToken)new BulkUpdateObjectIdAndChangeTokenImpl(obj.getId(), (String)changeToken.getValue()));
            }
            catch (Exception e) {
                LOG.error("updating properties in bulk upadate failed for object" + obj.getId() + ": ", (Throwable)e);
            }
        }
        return result;
    }

    private StoredObject createDocumentIntern(CallContext context, String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        Acl aclAdd = TypeValidator.expandAclMakros(context.getUsername(), addACEs);
        Acl aclRemove = TypeValidator.expandAclMakros(context.getUsername(), removeACEs);
        StoredObject so = this.validator.createDocument(context, repositoryId, folderId, policies, extension);
        org.apache.chemistry.opencmis.server.support.TypeValidator.validateRequiredSystemProperties((Properties)properties);
        String user = context.getUsername();
        boolean cmis11 = context.getCmisVersion() != CmisVersion.CMIS_1_0;
        TypeDefinition typeDef = this.getTypeDefinition(repositoryId, properties, cmis11);
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        Map<String, PropertyData<?>> propMap = properties.getProperties();
        PropertyData pd = (PropertyData)propMap.get("cmis:name");
        String name = (String)pd.getFirstValue();
        org.apache.chemistry.opencmis.server.support.TypeValidator.validateAcl((TypeDefinition)typeDef, (Acl)aclAdd, (Acl)aclRemove);
        Folder folder = null;
        if (null != folderId) {
            if (null == so) {
                throw new CmisInvalidArgumentException(" Cannot create document, folderId: " + folderId + " is invalid");
            }
            if (!(so instanceof Folder)) {
                throw new CmisInvalidArgumentException("Can't creat document, folderId does not refer to a folder: " + folderId);
            }
            folder = (Folder)so;
            org.apache.chemistry.opencmis.server.support.TypeValidator.validateAllowedChildObjectTypes((TypeDefinition)typeDef, folder.getAllowedChildObjectTypeIds());
        }
        if (!typeDef.getBaseTypeId().equals((Object)BaseTypeId.CMIS_DOCUMENT)) {
            throw new CmisInvalidArgumentException("Cannot create a document, with a non-document type: " + typeDef.getId());
        }
        if (!NameValidator.isValidName(name)) {
            throw new CmisInvalidArgumentException("Name contains illegal characters, not allowed are '/', '\\', ':', '\"', '*'. '?', '<','>', '|' Name is: " + name);
        }
        org.apache.chemistry.opencmis.server.support.TypeValidator.validateContentAllowed((DocumentTypeDefinition)((DocumentTypeDefinition)typeDef), (null != contentStream ? 1 : 0) != 0);
        org.apache.chemistry.opencmis.server.support.TypeValidator.validateVersionStateForCreate((DocumentTypeDefinition)((DocumentTypeDefinition)typeDef), (VersioningState)versioningState);
        if (typeDef instanceof DocumentTypeDefinition && ((DocumentTypeDefinition)typeDef).isVersionable().booleanValue() && null != versioningState && versioningState.equals((Object)VersioningState.CHECKEDOUT)) {
            throw new CmisConstraintException("Creating of checked-out documents is not supported.");
        }
        Map<String, PropertyData<?>> propMapNew = this.setDefaultProperties(typeDef, propMap);
        if (propMapNew != propMap) {
            properties = new PropertiesImpl(propMapNew.values());
            propMap = propMapNew;
        }
        this.validateProperties(repositoryId, null, properties, false, cmis11);
        if (user == null) {
            user = UNKNOWN_USER;
        }
        Fileable createdDoc = null;
        ContentStream contentStreamNew = contentStream;
        if (null != contentStream && (contentStream.getFileName() == null || contentStream.getFileName().length() == 0 || contentStream.getMimeType() == null || contentStream.getMimeType().length() == 0)) {
            ContentStreamImpl cs = new ContentStreamImpl();
            cs.setStream(contentStream.getStream());
            if (contentStream.getFileName() == null || contentStream.getFileName().length() == 0) {
                cs.setFileName(name);
            } else {
                cs.setFileName(contentStream.getFileName());
            }
            cs.setLength(contentStream.getBigLength());
            if (contentStream.getMimeType() == null || contentStream.getMimeType().length() == 0) {
                cs.setMimeType("application/octet-stream");
            } else {
                cs.setMimeType(contentStream.getMimeType());
            }
            cs.setExtensions(contentStream.getExtensions());
            contentStreamNew = cs;
        }
        if (((DocumentTypeDefinition)typeDef).isVersionable().booleanValue()) {
            DocumentVersion version = objectStore.createVersionedDocument(name, propMap, user, folder, policies, aclAdd, aclRemove, contentStreamNew, versioningState);
            createdDoc = version;
        } else {
            Document doc;
            createdDoc = doc = objectStore.createDocument(propMap, user, folder, contentStreamNew, policies, aclAdd, aclRemove);
        }
        return createdDoc;
    }

    private Folder createFolderIntern(CallContext context, String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        Acl aclAdd = TypeValidator.expandAclMakros(context.getUsername(), addAces);
        Acl aclRemove = TypeValidator.expandAclMakros(context.getUsername(), removeAces);
        Properties propertiesNew = properties;
        this.validator.createFolder(context, repositoryId, folderId, policies, extension);
        org.apache.chemistry.opencmis.server.support.TypeValidator.validateRequiredSystemProperties((Properties)properties);
        String user = context.getUsername();
        ObjectStore fs = this.fStoreManager.getObjectStore(repositoryId);
        Folder parent = null;
        PropertyData pd = (PropertyData)properties.getProperties().get("cmis:name");
        String folderName = (String)pd.getFirstValue();
        if (null == folderName || folderName.length() == 0) {
            throw new CmisInvalidArgumentException("Cannot create a folder without a name.");
        }
        if (!NameValidator.isValidName(folderName)) {
            throw new CmisInvalidArgumentException("Name contains illegal characters, not allowed are '/', '\\', ':', '\"', '*'. '?', '<','>', '|' Name is: " + folderName);
        }
        boolean cmis11 = context.getCmisVersion() != CmisVersion.CMIS_1_0;
        TypeDefinition typeDef = this.getTypeDefinition(repositoryId, properties, cmis11);
        if (!typeDef.getBaseTypeId().equals((Object)BaseTypeId.CMIS_FOLDER)) {
            throw new CmisInvalidArgumentException("Cannot create a folder, with a non-folder type: " + typeDef.getId());
        }
        Map propMap = propertiesNew.getProperties();
        Map<String, PropertyData<?>> propMapNew = this.setDefaultProperties(typeDef, propMap);
        if (propMapNew != propMap) {
            propertiesNew = new PropertiesImpl(propMapNew.values());
        }
        this.validateProperties(repositoryId, null, propertiesNew, false, cmis11);
        org.apache.chemistry.opencmis.server.support.TypeValidator.validateAcl((TypeDefinition)typeDef, (Acl)aclAdd, (Acl)aclRemove);
        StoredObject so = null;
        try {
            LOG.debug("get folder for id: " + folderId);
            so = fs.getObjectById(folderId);
        }
        catch (Exception e) {
            throw new CmisObjectNotFoundException("Failed to retrieve folder.", (Throwable)e);
        }
        if (!(so instanceof Folder)) {
            throw new CmisInvalidArgumentException("Can't create folder, folderId does not refer to a folder: " + folderId);
        }
        parent = (Folder)so;
        if (user == null) {
            user = UNKNOWN_USER;
        }
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        Folder newFolder = objStore.createFolder(folderName, propertiesNew.getProperties(), user, parent, policies, aclAdd, aclRemove);
        LOG.debug("stop createFolder()");
        return newFolder;
    }

    private StoredObject createPolicyIntern(CallContext context, String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        Acl aclAdd = addAces;
        Acl aclRemove = removeAces;
        this.validator.createPolicy(context, repositoryId, folderId, aclAdd, aclRemove, policies, extension);
        aclAdd = TypeValidator.expandAclMakros(context.getUsername(), aclAdd);
        aclRemove = TypeValidator.expandAclMakros(context.getUsername(), aclRemove);
        String user = context.getUsername();
        Map propMap = properties.getProperties();
        PropertyData pd = (PropertyData)propMap.get("cmis:name");
        String name = (String)pd.getFirstValue();
        pd = (PropertyData)propMap.get("cmis:policyText");
        String policyText = pd == null ? null : (String)pd.getFirstValue();
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        StoredObject storedObject = objStore.createPolicy(name, policyText, propMap, user, aclAdd, aclRemove);
        return storedObject;
    }

    private StoredObject createRelationshipIntern(CallContext context, String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        org.apache.chemistry.opencmis.server.support.TypeValidator.validateRequiredSystemProperties((Properties)properties);
        String user = context.getUsername();
        Acl aclAdd = TypeValidator.expandAclMakros(context.getUsername(), addAces);
        Acl aclRemove = TypeValidator.expandAclMakros(context.getUsername(), removeAces);
        PropertyData pd = (PropertyData)properties.getProperties().get("cmis:sourceId");
        String sourceId = (String)pd.getFirstValue();
        if (null == sourceId || sourceId.length() == 0) {
            throw new CmisInvalidArgumentException("Cannot create a relationship without a sourceId.");
        }
        pd = (PropertyData)properties.getProperties().get("cmis:targetId");
        String targetId = (String)pd.getFirstValue();
        if (null == targetId || targetId.length() == 0) {
            throw new CmisInvalidArgumentException("Cannot create a relationship without a targetId.");
        }
        boolean cmis11 = context.getCmisVersion() != CmisVersion.CMIS_1_0;
        TypeDefinition typeDef = this.getTypeDefinition(repositoryId, properties, cmis11);
        if (!typeDef.getBaseTypeId().equals((Object)BaseTypeId.CMIS_RELATIONSHIP)) {
            throw new CmisInvalidArgumentException("Cannot create a relationship, with a non-relationship type: " + typeDef.getId());
        }
        StoredObject[] relationObjects = this.validator.createRelationship(context, repositoryId, sourceId, targetId, policies, extension);
        Map propMap = properties.getProperties();
        Map<String, PropertyData<?>> propMapNew = this.setDefaultProperties(typeDef, propMap);
        Object propertiesNew = propMapNew != propMap ? new PropertiesImpl(propMapNew.values()) : properties;
        this.validateProperties(repositoryId, null, (Properties)propertiesNew, false, cmis11);
        org.apache.chemistry.opencmis.server.support.TypeValidator.validateAcl((TypeDefinition)typeDef, (Acl)aclAdd, (Acl)aclRemove);
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        TypeDefinition sourceTypeDef = this.fStoreManager.getTypeById(repositoryId, objStore.getObjectById(sourceId).getTypeId(), cmis11).getTypeDefinition();
        TypeDefinition targetTypeDef = this.fStoreManager.getTypeById(repositoryId, objStore.getObjectById(targetId).getTypeId(), cmis11).getTypeDefinition();
        org.apache.chemistry.opencmis.server.support.TypeValidator.validateAllowedRelationshipTypes((RelationshipTypeDefinition)((RelationshipTypeDefinition)typeDef), (TypeDefinition)sourceTypeDef, (TypeDefinition)targetTypeDef);
        pd = (PropertyData)propMap.get("cmis:name");
        String name = (String)pd.getFirstValue();
        StoredObject storedObject = objStore.createRelationship(name, relationObjects[0], relationObjects[1], propMapNew, user, aclAdd, aclRemove);
        return storedObject;
    }

    private StoredObject createItemIntern(CallContext context, String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        StoredObject so = this.validator.createItem(context, repositoryId, properties, folderId, policies, addAces, removeAces, extension);
        Acl aclAdd = TypeValidator.expandAclMakros(context.getUsername(), addAces);
        Acl aclRemove = TypeValidator.expandAclMakros(context.getUsername(), removeAces);
        this.validator.createDocument(context, repositoryId, folderId, policies, extension);
        org.apache.chemistry.opencmis.server.support.TypeValidator.validateRequiredSystemProperties((Properties)properties);
        String user = context.getUsername();
        boolean cmis11 = context.getCmisVersion() != CmisVersion.CMIS_1_0;
        TypeDefinition typeDef = this.getTypeDefinition(repositoryId, properties, cmis11);
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        Map propMap = properties.getProperties();
        PropertyData pd = (PropertyData)propMap.get("cmis:name");
        String name = (String)pd.getFirstValue();
        org.apache.chemistry.opencmis.server.support.TypeValidator.validateAcl((TypeDefinition)typeDef, (Acl)aclAdd, (Acl)aclRemove);
        Folder folder = null;
        if (null != folderId) {
            if (null == so) {
                throw new CmisInvalidArgumentException(" Cannot create item, folderId: " + folderId + " is invalid");
            }
            if (!(so instanceof Folder)) {
                throw new CmisInvalidArgumentException("Can't create item, folderId does not refer to a folder: " + folderId);
            }
            folder = (Folder)so;
            org.apache.chemistry.opencmis.server.support.TypeValidator.validateAllowedChildObjectTypes((TypeDefinition)typeDef, folder.getAllowedChildObjectTypeIds());
        }
        if (!typeDef.getBaseTypeId().equals((Object)BaseTypeId.CMIS_ITEM)) {
            throw new CmisInvalidArgumentException("Cannot create an item, with a non-item type: " + typeDef.getId());
        }
        if (!NameValidator.isValidName(name)) {
            throw new CmisInvalidArgumentException("Name contains illegal characters, not allowed are '/', '\\', ':', '\"', '*'. '?', '<','>', '|' Name is: " + name);
        }
        Properties propertiesNew = properties;
        Map<String, PropertyData<?>> propMapNew = this.setDefaultProperties(typeDef, propMap);
        if (propMapNew != propMap) {
            propertiesNew = new PropertiesImpl(propMapNew.values());
        }
        this.validateProperties(repositoryId, null, propertiesNew, false, cmis11);
        if (user == null) {
            user = UNKNOWN_USER;
        }
        StoredObject item = null;
        item = objectStore.createItem(name, propMapNew, user, folder, policies, aclAdd, aclRemove);
        return item;
    }

    private boolean hasDescendant(String user, ObjectStore objStore, Folder sourceFolder, Folder targetFolder) {
        String sourceId = sourceFolder.getId();
        String targetId = targetFolder.getId();
        Folder folder = targetFolder;
        while (targetId != null) {
            if (targetId.equals(sourceId)) {
                return true;
            }
            List<String> parentIds = objStore.getParentIds(folder, user);
            targetId = parentIds == null || parentIds.isEmpty() ? null : parentIds.get(0);
            if (null == targetId) continue;
            folder = (Folder)objStore.getObjectById(targetId);
        }
        return false;
    }

    private boolean deleteRecursive(ObjectStore objStore, Folder parentFolder, boolean continueOnFailure, boolean allVersions, List<String> failedToDeleteIds, String user) {
        ObjectStore.ChildrenResult childrenResult = objStore.getChildren(parentFolder, -1, -1, "Admin", true);
        List<Fileable> children = childrenResult.getChildren();
        if (null == children) {
            return true;
        }
        for (Fileable child : children) {
            if (child instanceof Folder) {
                boolean mustContinue = this.deleteRecursive(objStore, (Folder)child, continueOnFailure, allVersions, failedToDeleteIds, user);
                if (mustContinue || continueOnFailure) continue;
                return false;
            }
            try {
                objStore.deleteObject(child.getId(), allVersions, user);
            }
            catch (Exception e) {
                failedToDeleteIds.add(child.getId());
            }
        }
        objStore.deleteObject(parentFolder.getId(), allVersions, user);
        return true;
    }

    private static ContentStream getContentStream(ObjectStore objStore, StoredObject so, String streamId, BigInteger offset, BigInteger length) {
        long lLength;
        ContentStream csd = null;
        long lOffset = offset == null ? 0L : offset.longValue();
        long l = lLength = length == null ? -1L : length.longValue();
        if (streamId == null) {
            csd = objStore.getContent(so, lOffset, lLength);
        } else if (streamId.endsWith("-rendition")) {
            csd = objStore.getRenditionContent(so, streamId, lOffset, lLength);
        }
        return csd;
    }

    private Map<String, PropertyData<?>> setDefaultProperties(TypeDefinition typeDef, Map<String, PropertyData<?>> properties) {
        Map<String, PropertyData<?>> propertiesReturn = properties;
        Map propDefs = typeDef.getPropertyDefinitions();
        boolean hasCopied = false;
        for (PropertyDefinition propDef : propDefs.values()) {
            String propId = propDef.getId();
            List defaultVal = propDef.getDefaultValue();
            if (defaultVal == null || defaultVal.isEmpty() || null != properties.get(propId)) continue;
            if (!hasCopied) {
                propertiesReturn = new HashMap(properties);
                hasCopied = true;
            }
            List value = propDef.getCardinality() == Cardinality.SINGLE ? defaultVal.get(0) : defaultVal;
            PropertyData pd = this.fStoreManager.getObjectFactory().createPropertyData(propDef, (Object)value);
            propertiesReturn.put(propId, pd);
        }
        return propertiesReturn;
    }

    private void validateProperties(String repositoryId, StoredObject so, Properties properties, boolean checkMandatory, boolean cmis11) {
        List<String> secondaryTypeIds;
        TypeDefinition typeDef = null != so ? this.getTypeDefinition(repositoryId, so, cmis11) : this.getTypeDefinition(repositoryId, properties, cmis11);
        if (!cmis11) {
            org.apache.chemistry.opencmis.server.support.TypeValidator.validateProperties((TypeDefinition)typeDef, (Properties)properties, (boolean)checkMandatory, (boolean)cmis11);
            return;
        }
        PropertyData pd = (PropertyData)properties.getProperties().get("cmis:secondaryObjectTypeIds");
        List<String> list = secondaryTypeIds = pd == null ? null : pd.getValues();
        if (null != so && (null == secondaryTypeIds || secondaryTypeIds.size() == 0)) {
            secondaryTypeIds = so.getSecondaryTypeIds();
        }
        if (null != secondaryTypeIds && secondaryTypeIds.size() != 0) {
            ArrayList<String> allTypeIds = new ArrayList<String>(secondaryTypeIds);
            allTypeIds.add(typeDef.getId());
            List<TypeDefinition> typeDefs = this.getTypeDefinition(repositoryId, allTypeIds, cmis11);
            org.apache.chemistry.opencmis.server.support.TypeValidator.validateProperties(typeDefs, (Properties)properties, (boolean)checkMandatory);
        } else {
            org.apache.chemistry.opencmis.server.support.TypeValidator.validateProperties((TypeDefinition)typeDef, (Properties)properties, (boolean)checkMandatory, (boolean)true);
        }
    }

    private TypeDefinition getSecondaryTypeDefinition(CallContext context, String repositoryId, Set<String> secondaryTypeIds, String propertyId) {
        if (null == secondaryTypeIds || secondaryTypeIds.isEmpty()) {
            return null;
        }
        boolean cmis11 = context.getCmisVersion() != CmisVersion.CMIS_1_0;
        for (String typeId : secondaryTypeIds) {
            TypeDefinitionContainer typeDefC = this.fStoreManager.getTypeById(repositoryId, typeId, cmis11);
            TypeDefinition typeDef = typeDefC.getTypeDefinition();
            if (!org.apache.chemistry.opencmis.server.support.TypeValidator.typeContainsProperty((TypeDefinition)typeDef, (String)propertyId)) continue;
            return typeDef;
        }
        return null;
    }

    private List<String> getListOfPropertiesToDeleteFromRemovedSecondaryTypes(CallContext context, String repositoryId, StoredObject so, List<String> newSecondaryTypeIds) {
        ArrayList<String> propertiesToDelete = new ArrayList<String>();
        List<String> existingSecondaryTypeIds = so.getSecondaryTypeIds();
        ArrayList<String> delta = new ArrayList<String>(existingSecondaryTypeIds);
        delta.removeAll(newSecondaryTypeIds);
        boolean cmis11 = context.getCmisVersion() != CmisVersion.CMIS_1_0;
        for (String typeDefId : delta) {
            TypeDefinitionContainer typeDefC = this.fStoreManager.getTypeById(repositoryId, typeDefId, cmis11);
            TypeDefinition typeDef = typeDefC.getTypeDefinition();
            propertiesToDelete.addAll(typeDef.getPropertyDefinitions().keySet());
        }
        return propertiesToDelete;
    }
}

