/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.inmemory.DataObjectCreator;
import org.apache.chemistry.opencmis.inmemory.FilterParser;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ContentStreamDataImpl;

public class StoredObjectImpl
implements StoredObject {
    private static final int BUFFER_SIZE = 65536;
    private static final String UNKNOWN_USER = "unknown";
    protected String fId;
    protected String fName;
    protected String fTypeId;
    protected String fCreatedBy;
    protected String fModifiedBy;
    protected GregorianCalendar fCreatedAt;
    protected GregorianCalendar fModifiedAt;
    protected String fRepositoryId;
    protected Map<String, PropertyData<?>> fProperties;
    protected int fAclId;
    protected String description;
    protected List<String> secondaryTypeIds;
    protected List<String> policyIds;

    StoredObjectImpl() {
        GregorianCalendar now = StoredObjectImpl.getNow();
        now.setTime(new Date());
        this.fCreatedAt = now;
        this.fModifiedAt = now;
        this.secondaryTypeIds = new ArrayList<String>();
        this.policyIds = null;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public void setId(String id) {
        this.fId = id;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public String getTypeId() {
        return this.fTypeId;
    }

    @Override
    public void setTypeId(String type) {
        this.fTypeId = type;
    }

    @Override
    public String getCreatedBy() {
        return this.fCreatedBy;
    }

    @Override
    public void setCreatedBy(String createdBy) {
        this.fCreatedBy = createdBy;
    }

    @Override
    public String getModifiedBy() {
        return this.fModifiedBy;
    }

    @Override
    public void setModifiedBy(String modifiedBy) {
        this.fModifiedBy = modifiedBy;
    }

    @Override
    public GregorianCalendar getCreatedAt() {
        return this.fCreatedAt;
    }

    @Override
    public void setCreatedAt(GregorianCalendar createdAt) {
        this.fCreatedAt = createdAt;
    }

    @Override
    public GregorianCalendar getModifiedAt() {
        return this.fModifiedAt;
    }

    @Override
    public void setModifiedAtNow() {
        GregorianCalendar now = StoredObjectImpl.getNow();
        while (now.getTimeInMillis() == this.fModifiedAt.getTimeInMillis()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            now = StoredObjectImpl.getNow();
        }
        this.fModifiedAt = now;
    }

    @Override
    public void setModifiedAt(GregorianCalendar cal) {
        this.fModifiedAt = cal;
    }

    @Override
    public void setRepositoryId(String repositoryId) {
        this.fRepositoryId = repositoryId;
    }

    @Override
    public String getRepositoryId() {
        return this.fRepositoryId;
    }

    @Override
    public List<String> getAppliedPolicies() {
        if (null == this.policyIds) {
            return null;
        }
        return Collections.unmodifiableList(this.policyIds);
    }

    public void setAppliedPolicies(List<String> newPolicies) {
        if (null == newPolicies) {
            this.policyIds = null;
        } else {
            if (null == this.policyIds) {
                this.policyIds = new ArrayList<String>();
            }
            this.policyIds.addAll(newPolicies);
        }
    }

    @Override
    public void addAppliedPolicy(String policyId) {
        if (null == this.policyIds) {
            this.policyIds = new ArrayList<String>();
        }
        if (!this.policyIds.contains(policyId)) {
            this.policyIds.add(policyId);
        }
    }

    @Override
    public void removePolicy(String policyId) {
        if (null != this.policyIds && this.policyIds.contains(policyId)) {
            this.policyIds.remove(policyId);
            if (this.policyIds.isEmpty()) {
                this.policyIds = null;
            }
        }
    }

    @Override
    public void setDescription(String descr) {
        this.description = descr;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getSecondaryTypeIds() {
        return Collections.unmodifiableList(this.secondaryTypeIds);
    }

    @Override
    public void setProperties(Map<String, PropertyData<?>> props) {
        this.fProperties = props;
    }

    @Override
    public Map<String, PropertyData<?>> getProperties() {
        return this.fProperties;
    }

    @Override
    public String getChangeToken() {
        GregorianCalendar lastModified = this.getModifiedAt();
        String token = Long.valueOf(lastModified.getTimeInMillis()).toString();
        return token;
    }

    @Override
    public void createSystemBasePropertiesWhenCreated(Map<String, PropertyData<?>> properties, String user) {
        this.addSystemBaseProperties(properties, user, true);
    }

    @Override
    public void updateSystemBasePropertiesWhenModified(Map<String, PropertyData<?>> properties, String user) {
        this.addSystemBaseProperties(properties, user, false);
    }

    @Override
    public void fillProperties(Map<String, PropertyData<?>> properties, BindingsObjectFactory objFactory, List<String> requestedIds) {
        if (FilterParser.isContainedInFilter("cmis:name", requestedIds)) {
            properties.put("cmis:name", (PropertyData<?>)objFactory.createPropertyStringData("cmis:name", this.getName()));
        }
        if (FilterParser.isContainedInFilter("cmis:objectId", requestedIds)) {
            properties.put("cmis:objectId", (PropertyData<?>)objFactory.createPropertyIdData("cmis:objectId", this.getId()));
        }
        if (FilterParser.isContainedInFilter("cmis:objectTypeId", requestedIds)) {
            properties.put("cmis:objectTypeId", (PropertyData<?>)objFactory.createPropertyIdData("cmis:objectTypeId", this.getTypeId()));
        }
        if (FilterParser.isContainedInFilter("cmis:createdBy", requestedIds)) {
            properties.put("cmis:createdBy", (PropertyData<?>)objFactory.createPropertyStringData("cmis:createdBy", this.getCreatedBy()));
        }
        if (FilterParser.isContainedInFilter("cmis:creationDate", requestedIds)) {
            properties.put("cmis:creationDate", (PropertyData<?>)objFactory.createPropertyDateTimeData("cmis:creationDate", this.getCreatedAt()));
        }
        if (FilterParser.isContainedInFilter("cmis:lastModifiedBy", requestedIds)) {
            properties.put("cmis:lastModifiedBy", (PropertyData<?>)objFactory.createPropertyStringData("cmis:lastModifiedBy", this.getModifiedBy()));
        }
        if (FilterParser.isContainedInFilter("cmis:lastModificationDate", requestedIds)) {
            properties.put("cmis:lastModificationDate", (PropertyData<?>)objFactory.createPropertyDateTimeData("cmis:lastModificationDate", this.getModifiedAt()));
        }
        if (FilterParser.isContainedInFilter("cmis:changeToken", requestedIds)) {
            String token = this.getChangeToken();
            properties.put("cmis:changeToken", (PropertyData<?>)objFactory.createPropertyStringData("cmis:changeToken", token));
        }
        if (FilterParser.isContainedInFilter("cmis:description", requestedIds)) {
            properties.put("cmis:description", (PropertyData<?>)objFactory.createPropertyStringData("cmis:description", this.description));
        }
        if (FilterParser.isContainedInFilter("cmis:secondaryObjectTypeIds", requestedIds)) {
            properties.put("cmis:secondaryObjectTypeIds", (PropertyData<?>)objFactory.createPropertyIdData("cmis:secondaryObjectTypeIds", this.secondaryTypeIds));
        }
        if (null != this.fProperties) {
            for (Map.Entry<String, PropertyData<?>> prop : this.fProperties.entrySet()) {
                if (!FilterParser.isContainedInFilter(prop.getKey(), requestedIds)) continue;
                properties.put(prop.getKey(), prop.getValue());
            }
        }
    }

    @Override
    public void setCustomProperties(Map<String, PropertyData<?>> properties) {
        HashMap propertiesNew = new HashMap(properties);
        StoredObjectImpl.removeAllSystemProperties(propertiesNew);
        this.setProperties(propertiesNew);
    }

    private static GregorianCalendar getNow() {
        GregorianCalendar now = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        return now;
    }

    private void addSystemBaseProperties(Map<String, PropertyData<?>> properties, String user, boolean isCreated) {
        if (user == null) {
            user = UNKNOWN_USER;
        }
        this.setModifiedBy(user);
        if (null != properties) {
            PropertyData<?> secondaryTypeProp;
            if (null != properties.get("cmis:description")) {
                this.setDescription((String)properties.get("cmis:description").getFirstValue());
            }
            if (properties.containsKey("cmis:secondaryObjectTypeIds")) {
                this.secondaryTypeIds.clear();
            }
            if (null != (secondaryTypeProp = properties.get("cmis:secondaryObjectTypeIds"))) {
                this.secondaryTypeIds.addAll(secondaryTypeProp.getValues());
            }
        }
        if (isCreated) {
            this.setCreatedBy(user);
            this.setName((String)properties.get("cmis:name").getFirstValue());
            this.setTypeId((String)properties.get("cmis:objectTypeId").getFirstValue());
        } else {
            this.setModifiedAtNow();
        }
    }

    protected void setSystemBasePropertiesWhenCreatedDirect(String name, String typeId, String user) {
        this.setModifiedBy(user);
        this.setCreatedBy(user);
        this.setName(name);
        this.setTypeId(typeId);
    }

    private static void removeAllSystemProperties(Map<String, PropertyData<?>> properties) {
        if (properties.containsKey("cmis:name")) {
            properties.remove("cmis:name");
        }
        if (properties.containsKey("cmis:objectId")) {
            properties.remove("cmis:objectId");
        }
        if (properties.containsKey("cmis:objectTypeId")) {
            properties.remove("cmis:objectTypeId");
        }
        if (properties.containsKey("cmis:baseTypeId")) {
            properties.remove("cmis:baseTypeId");
        }
        if (properties.containsKey("cmis:createdBy")) {
            properties.remove("cmis:createdBy");
        }
        if (properties.containsKey("cmis:creationDate")) {
            properties.remove("cmis:creationDate");
        }
        if (properties.containsKey("cmis:lastModifiedBy")) {
            properties.remove("cmis:lastModifiedBy");
        }
        if (properties.containsKey("cmis:lastModificationDate")) {
            properties.remove("cmis:lastModificationDate");
        }
        if (properties.containsKey("cmis:changeToken")) {
            properties.remove("cmis:changeToken");
        }
        if (properties.containsKey("cmis:isImmutable")) {
            properties.remove("cmis:isImmutable");
        }
        if (properties.containsKey("cmis:isLatestVersion")) {
            properties.remove("cmis:isLatestVersion");
        }
        if (properties.containsKey("cmis:isMajorVersion")) {
            properties.remove("cmis:isMajorVersion");
        }
        if (properties.containsKey("cmis:isLatestMajorVersion")) {
            properties.remove("cmis:isLatestMajorVersion");
        }
        if (properties.containsKey("cmis:versionLabel")) {
            properties.remove("cmis:versionLabel");
        }
        if (properties.containsKey("cmis:versionSeriesId")) {
            properties.remove("cmis:versionSeriesId");
        }
        if (properties.containsKey("cmis:isVersionSeriesCheckedOut")) {
            properties.remove("cmis:isVersionSeriesCheckedOut");
        }
        if (properties.containsKey("cmis:versionSeriesCheckedOutBy")) {
            properties.remove("cmis:versionSeriesCheckedOutBy");
        }
        if (properties.containsKey("cmis:versionSeriesCheckedOutId")) {
            properties.remove("cmis:versionSeriesCheckedOutId");
        }
        if (properties.containsKey("cmis:checkinComment")) {
            properties.remove("cmis:checkinComment");
        }
        if (properties.containsKey("cmis:contentStreamLength")) {
            properties.remove("cmis:contentStreamLength");
        }
        if (properties.containsKey("cmis:contentStreamMimeType")) {
            properties.remove("cmis:contentStreamMimeType");
        }
        if (properties.containsKey("cmis:contentStreamFileName")) {
            properties.remove("cmis:contentStreamFileName");
        }
        if (properties.containsKey("cmis:contentStreamId")) {
            properties.remove("cmis:contentStreamId");
        }
        if (properties.containsKey("cmis:parentId")) {
            properties.remove("cmis:parentId");
        }
        if (properties.containsKey("cmis:allowedChildObjectTypeIds")) {
            properties.remove("cmis:allowedChildObjectTypeIds");
        }
        if (properties.containsKey("cmis:path")) {
            properties.remove("cmis:path");
        }
        if (properties.containsKey("cmis:sourceId")) {
            properties.remove("cmis:sourceId");
        }
        if (properties.containsKey("cmis:targetId")) {
            properties.remove("cmis:targetId");
        }
        if (properties.containsKey("cmis:policyText")) {
            properties.remove("cmis:policyText");
        }
    }

    @Override
    public int getAclId() {
        return this.fAclId;
    }

    public void setAclId(int aclId) {
        this.fAclId = aclId;
    }

    @Override
    public AllowableActions getAllowableActions(CallContext context, String user) {
        AllowableActions actions = DataObjectCreator.fillAllowableActions(context, this, user);
        return actions;
    }

    @Override
    public boolean hasRendition(String user) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentStream getIconFromResourceDir(String name) throws IOException {
        InputStream imageStream = StoredObjectImpl.class.getResourceAsStream(name);
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        byte[] buffer = new byte[65536];
        int noBytesRead = 0;
        try {
            while ((noBytesRead = imageStream.read(buffer)) >= 0) {
                ba.write(buffer, 0, noBytesRead);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)ba);
            IOUtils.closeQuietly((Closeable)imageStream);
        }
        ContentStreamDataImpl content = new ContentStreamDataImpl(0L);
        content.setFileName(name);
        content.setMimeType("image/png");
        content.setContent(new ByteArrayInputStream(ba.toByteArray()));
        return content;
    }

    protected boolean testRenditionFilterForImage(String[] formats) {
        if (formats.length == 1 && null != formats[0] && formats[0].equals("cmis:none")) {
            return false;
        }
        return this.arrayContainsString(formats, "*") || this.arrayContainsString(formats, "image/*") || this.arrayContainsString(formats, "image/jpeg");
    }

    private boolean arrayContainsString(String[] formats, String val) {
        for (String s : formats) {
            if (!val.equals(s)) continue;
            return true;
        }
        return false;
    }
}

