/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.DataBarFormatting;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFConditionalFormattingThreshold;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataBar;

public class XSSFDataBarFormatting
implements DataBarFormatting {
    IndexedColorMap _colorMap;
    CTDataBar _databar;

    XSSFDataBarFormatting(CTDataBar databar, IndexedColorMap colorMap) {
        this._databar = databar;
        this._colorMap = colorMap;
    }

    public boolean isIconOnly() {
        if (this._databar.isSetShowValue()) {
            return !this._databar.getShowValue();
        }
        return false;
    }

    public void setIconOnly(boolean only) {
        this._databar.setShowValue(!only);
    }

    public boolean isLeftToRight() {
        return true;
    }

    public void setLeftToRight(boolean ltr) {
    }

    public int getWidthMin() {
        return 0;
    }

    public void setWidthMin(int width) {
    }

    public int getWidthMax() {
        return 100;
    }

    public void setWidthMax(int width) {
    }

    public XSSFColor getColor() {
        return XSSFColor.from(this._databar.getColor(), this._colorMap);
    }

    public void setColor(Color color) {
        this._databar.setColor(((XSSFColor)color).getCTColor());
    }

    public XSSFConditionalFormattingThreshold getMinThreshold() {
        return new XSSFConditionalFormattingThreshold(this._databar.getCfvoArray(0));
    }

    public XSSFConditionalFormattingThreshold getMaxThreshold() {
        return new XSSFConditionalFormattingThreshold(this._databar.getCfvoArray(1));
    }

    public XSSFConditionalFormattingThreshold createThreshold() {
        return new XSSFConditionalFormattingThreshold(this._databar.addNewCfvo());
    }
}

