/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.ResponseParser;

public abstract class SolrClientBuilder<B extends SolrClientBuilder<B>> {
    protected HttpClient httpClient;
    protected ResponseParser responseParser;
    protected Integer connectionTimeoutMillis = 15000;
    protected Integer socketTimeoutMillis = 120000;

    public abstract B getThis();

    public B withHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this.getThis();
    }

    public B withResponseParser(ResponseParser responseParser) {
        this.responseParser = responseParser;
        return this.getThis();
    }

    public B withConnectionTimeout(int connectionTimeoutMillis) {
        if (connectionTimeoutMillis < 0) {
            throw new IllegalArgumentException("connectionTimeoutMillis must be a non-negative integer.");
        }
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        return this.getThis();
    }

    public B withSocketTimeout(int socketTimeoutMillis) {
        if (socketTimeoutMillis < 0) {
            throw new IllegalArgumentException("socketTimeoutMillis must be a non-negative integer.");
        }
        this.socketTimeoutMillis = socketTimeoutMillis;
        return this.getThis();
    }
}

